/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.model;

import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.precess.DownloadPrecessHelper;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.update.check.ICacheState;
import com.kingdee.eas.client.startup.update.model.UpdateSuccessListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateModel {
    private static final Logger logger = ClientStartLogger.getLogger();
    private ICacheState cacheState;
    private List<EASClientFile> needUpdate;
    private Map<EASClientFile, List<String>> updateFailed = new HashMap<EASClientFile, List<String>>();
    private List<EASClientFile> updateSuccess = new ArrayList<EASClientFile>();
    private List<UpdateSuccessListener> listeners = new ArrayList<UpdateSuccessListener>();

    public UpdateModel(ICacheState cacheState) {
        this.cacheState = cacheState;
        this.needUpdate = this.copy(cacheState.getUpdatedResources());
        logger.info((Object)("\u9700\u8981\u66f4\u65b0\u7684\u6587\u4ef6\u5171\u6709" + this.needUpdate.size() + "\u4e2a\uff1a" + this.needUpdate));
    }

    private List<EASClientFile> copy(List<EASClientFile> list) {
        List<EASClientFile> asList = Arrays.asList(new EASClientFile[list.size()]);
        ArrayList<EASClientFile> newList = new ArrayList<EASClientFile>(asList);
        Collections.copy(newList, list);
        return newList;
    }

    public List<EASClientFile> getNeedUpdate() {
        return this.copy(this.needUpdate);
    }

    public ICacheState getCacheState() {
        return this.cacheState;
    }

    public void addUpdateSuccessListener(UpdateSuccessListener listener) {
        this.listeners.add(listener);
    }

    public void updateSuccess(EASClientFile info) {
        boolean removeSucess = this.needUpdate.remove(info);
        if (!removeSucess) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u5f15\u7528,\u8bf7\u4f7f\u7528\u901a\u8fc7\u672c\u6a21\u578b\u83b7\u53d6\u7684\u6570\u636e\u4f5c\u53c2\u6570,\u4e0d\u8981\u81ea\u5df1\u521b\u5efa\u5bf9\u8c61\u4f5c\u53c2\u6570");
        }
        this.updateSuccess.add(info);
        this.updateFailed.remove(info);
        DownloadPrecessHelper.updateSuccess(info.getPath());
    }

    public void updateFail(EASClientFile info, String failReason) {
        List<String> failReasonList = this.updateFailed.get(info);
        if (null == failReasonList) {
            failReasonList = new ArrayList<String>();
            this.updateFailed.put(info, failReasonList);
        }
        failReasonList.add(failReason);
    }

    public void store() {
        for (UpdateSuccessListener listener : this.listeners) {
            listener.storeUpdateSuccess(this.updateSuccess);
        }
        this.updateSuccess.clear();
    }

    public Map<EASClientFile, List<String>> getUpdateFailed() {
        return this.updateFailed;
    }
}

