/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.util;

import com.kingdee.eas.client.startup.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesUtils {
    private static final Pattern expandPattern = Pattern.compile("\\$\\{([^\\$\\{\\}]*)\\}");

    public static void load(Properties props, InputStream is) throws IOException {
        PropertiesUtils.load(props, new InputStreamReader(is));
    }

    public static void load(Properties props, Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line;
        while ((line = in.readLine()) != null) {
            char firstChar;
            if ((line = StringUtils.trimLeadingWhitespace(line)).length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (PropertiesUtils.endsWithContinuationMarker(line)) {
                String nextLine = in.readLine();
                line = line.substring(0, line.length() - 1);
                if (nextLine == null) continue;
                line = line + StringUtils.trimLeadingWhitespace(nextLine);
            }
            int separatorIndex = line.indexOf("=");
            if (separatorIndex == -1) {
                separatorIndex = line.indexOf(":");
            }
            String key = separatorIndex != -1 ? line.substring(0, separatorIndex) : line;
            String value = separatorIndex != -1 ? line.substring(separatorIndex + 1) : "";
            key = StringUtils.trimTrailingWhitespace(key);
            value = StringUtils.trimLeadingWhitespace(value);
            props.put(PropertiesUtils.unescape(key), PropertiesUtils.unescape(value));
        }
        return;
    }

    protected static boolean endsWithContinuationMarker(String line) {
        boolean evenSlashCount = true;
        for (int index = line.length() - 1; index >= 0 && line.charAt(index) == '\\'; --index) {
            evenSlashCount = !evenSlashCount;
        }
        return !evenSlashCount;
    }

    public static String unescape(String str) {
        StringBuffer outBuffer = new StringBuffer(str.length());
        int index = 0;
        while (index < str.length()) {
            char c;
            if ((c = str.charAt(index++)) == '\\') {
                outBuffer.append('/');
                continue;
            }
            outBuffer.append(c);
        }
        return outBuffer.toString();
    }

    public static void store(Properties props, Writer writer, String header) throws IOException {
        BufferedWriter out = new BufferedWriter(writer);
        if (header != null) {
            out.write("#" + header);
            out.newLine();
        }
        out.write("#" + new Date());
        out.newLine();
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val = props.getProperty(key);
            out.write(PropertiesUtils.escape(key, true) + "=" + PropertiesUtils.escape(val, false));
            out.newLine();
        }
        out.flush();
    }

    public static String escape(String str, boolean isKey) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        for (int index = 0; index < len; ++index) {
            char c = str.charAt(index);
            if (c == '\\') {
                outBuffer.append("/");
                continue;
            }
            outBuffer.append(c);
        }
        return outBuffer.toString();
    }

    public static String getProperty(Properties prop, String propName, String defaultValue) {
        String value = defaultValue;
        if (prop != null) {
            value = prop.getProperty(propName);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static Properties getStandardSystemProperties() {
        String[] propname = new String[]{"java.version", "java.vendor", "java.vendor.url", "java.class.version", "os.name", "os.version", "os.arch", "file.separator", "path.separator", "line.separator", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name"};
        Properties props = new Properties();
        for (int i = 0; i < propname.length; ++i) {
            props.setProperty(propname[i], System.getProperty(propname[i]));
        }
        return props;
    }

    public static Properties getPropertiesWithPrefix(String prefix, Properties properties) {
        Properties props = new Properties();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            if (!key.startsWith(prefix)) continue;
            try {
                props.setProperty(key, properties.getProperty(key));
            }
            catch (SecurityException e) {}
        }
        return props;
    }

    public static Properties getPropertiesWithoutPrefix(String prefix, Properties properties) {
        Properties props = new Properties();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            if (key.startsWith(prefix)) continue;
            try {
                props.setProperty(key, properties.getProperty(key));
            }
            catch (SecurityException e) {}
        }
        return props;
    }

    public static void expandProperties(Properties props) {
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            HashSet references = new HashSet();
            props.setProperty(key, PropertiesUtils.expandProperty(props, key, references));
        }
    }

    private static String expandProperty(Properties props, String key, Set references) {
        String originalValue;
        String value = originalValue = props.getProperty(key);
        boolean done = false;
        while (!done) {
            Matcher m = expandPattern.matcher(value);
            StringBuffer sb = new StringBuffer();
            done = true;
            while (m.find()) {
                done = false;
                String pKey = m.group(1);
                String pVal = props.getProperty(pKey);
                if (pVal == null) {
                    throw new IllegalArgumentException("Unresolved property: " + pKey);
                }
                if (expandPattern.matcher(pVal).find()) {
                    if (references.contains(pKey)) {
                        throw new IllegalArgumentException("Circular reference at " + pKey + " = " + pVal);
                    }
                    references.add(pKey);
                    pVal = PropertiesUtils.expandProperty(props, pKey, references);
                }
                m.appendReplacement(sb, pVal);
            }
            m.appendTail(sb);
            value = sb.toString();
        }
        return value;
    }

    public static String list(String title, Properties props) {
        StringBuffer sb = new StringBuffer();
        sb.append("-------");
        sb.append(title);
        sb.append("-------");
        sb.append("\n\r");
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                sb.append("\t" + key + "=" + props.getProperty(key));
                sb.append("\n\r");
            }
        }
        sb.append("-------------------");
        return sb.toString();
    }
}

