/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.util;

import com.kingdee.eas.client.startup.exception.EASClientException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.BitSet;

public class URLUtil {
    static BitSet encodedInPath = new BitSet(256);

    public static void setHostHeader(URLConnection urlc) {
        int port = urlc.getURL().getPort();
        String host = urlc.getURL().getHost();
        if (port != -1 && port != 80) {
            host = host + ":" + String.valueOf(port);
        }
        urlc.setRequestProperty("Host", host);
    }

    public static URL getBase(URL url) {
        if (url == null) {
            return null;
        }
        String file = url.getFile();
        if (file != null) {
            int idx = file.lastIndexOf(47);
            if (idx != -1) {
                file = file.substring(0, idx + 1);
            }
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public static URL asPathURL(URL url) {
        if (url == null) {
            return null;
        }
        String path = url.getFile();
        if (path != null && !path.endsWith("/")) {
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile() + "/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public static boolean equals(URL u1, URL u2) {
        if (u1 == null || u2 == null) {
            return u2 == u1;
        }
        if ("http".equals(u1.getProtocol()) && "http".equals(u2.getProtocol()) && u1.getPort() != u2.getPort()) {
            u1 = URLUtil.normalizePort(u1);
            u2 = URLUtil.normalizePort(u2);
        }
        return u1.toString().equals(u2.toString());
    }

    public static int compareTo(URL u1, URL u2) {
        if ("http".equals(u1.getProtocol()) && "http".equals(u2.getProtocol()) && u1.getPort() != u2.getPort()) {
            u1 = URLUtil.normalizePort(u1);
            u2 = URLUtil.normalizePort(u2);
        }
        return u1.toString().compareTo(u2.toString());
    }

    private static URL normalizePort(URL url) {
        if (url.getPort() != -1) {
            return url;
        }
        try {
            return new URL(url.getProtocol(), url.getHost(), 80, url.getFile());
        }
        catch (MalformedURLException mue) {
            return url;
        }
    }

    public static String encodePath(String path) {
        StringBuffer sb = new StringBuffer();
        int n = path.length();
        for (int i = 0; i < n; ++i) {
            char c = path.charAt(i);
            if (c == File.separatorChar) {
                sb.append('/');
                continue;
            }
            if (c <= '\u007f') {
                if (encodedInPath.get(c)) {
                    URLUtil.escape(sb, c);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c > '\u07ff') {
                URLUtil.escape(sb, (char)(0xE0 | c >> 12 & 0xF));
                URLUtil.escape(sb, (char)(0x80 | c >> 6 & 0x3F));
                URLUtil.escape(sb, (char)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            URLUtil.escape(sb, (char)(0xC0 | c >> 6 & 0x1F));
            URLUtil.escape(sb, (char)(0x80 | c >> 0 & 0x3F));
        }
        return sb.toString();
    }

    private static void escape(StringBuffer s, char c) {
        s.append('%');
        s.append(Character.forDigit(c >> 4 & 0xF, 16));
        s.append(Character.forDigit(c & 0xF, 16));
    }

    public static String decodePath(String path) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            if (c != '%') {
                ++i;
            } else {
                try {
                    c = URLUtil.unescape(path, i);
                    i += 3;
                    if ((c & 0x80) != 0) {
                        switch (c >> 4) {
                            case 12: 
                            case 13: {
                                char c2 = URLUtil.unescape(path, i);
                                i += 3;
                                c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                                break;
                            }
                            case 14: {
                                char c2 = URLUtil.unescape(path, i);
                                char c3 = URLUtil.unescape(path, i += 3);
                                i += 3;
                                c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                break;
                            }
                            default: {
                                new IllegalArgumentException();
                            }
                        }
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static char unescape(String s, int i) {
        return (char)Integer.parseInt(s.substring(i + 1, i + 3), 16);
    }

    public static String getEncodedPath(File file) {
        String path = file.getAbsolutePath();
        if (!path.endsWith(File.separator) && file.isDirectory()) {
            path = path + File.separator;
        }
        return URLUtil.encodePath(path);
    }

    public static String getDecodedPath(URL url) {
        String path = url.getFile();
        path = path.replace('/', File.separatorChar);
        return URLUtil.decodePath(path);
    }

    public static String getPathFromURL(URL url) {
        return URLUtil.getDecodedPath(url);
    }

    public static String getRelativePath(URL codebase, URL resource) {
        assert (codebase != null);
        assert (resource != null);
        String codebasePath = codebase.getPath();
        String resourcePath = resource.getPath();
        if (codebasePath.length() == 0) {
            return resourcePath;
        }
        if (resourcePath.startsWith(codebasePath)) {
            return resourcePath.substring(codebasePath.length());
        }
        assert (false) : "invalidate codebase[" + codebasePath + "] and resource[" + resourcePath + "]";
        return resource.toString();
    }

    public static URL convertString2URL(String urlStr) {
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new EASClientException("\u9519\u8bef\u7684URL\u683c\u5f0f" + urlStr, e);
        }
    }

    public static URL convertString2URL(URL context, String spec) {
        try {
            return new URL(context, spec);
        }
        catch (MalformedURLException e) {
            throw new EASClientException("\u9519\u8bef\u7684URL\u683c\u5f0f:context=" + context.toString() + ",spec=" + spec, e);
        }
    }

    public static void main(String[] args) throws MalformedURLException {
        URL codebase = new URL("file://Web/");
        URL resource = new URL("file://Web/lib/a.jar");
        System.out.println(URLUtil.getRelativePath(codebase, resource));
    }

    static {
        encodedInPath.set(61);
        encodedInPath.set(59);
        encodedInPath.set(63);
        encodedInPath.set(47);
        encodedInPath.set(35);
        encodedInPath.set(32);
        encodedInPath.set(60);
        encodedInPath.set(62);
        encodedInPath.set(37);
        encodedInPath.set(34);
        encodedInPath.set(123);
        encodedInPath.set(125);
        encodedInPath.set(124);
        encodedInPath.set(92);
        encodedInPath.set(94);
        encodedInPath.set(91);
        encodedInPath.set(93);
        encodedInPath.set(96);
        for (int i = 0; i < 32; ++i) {
            encodedInPath.set(i);
        }
        encodedInPath.set(127);
    }
}

