/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.command.impl;

import com.kingdee.bos.cloud.command.AbstractCommand;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import javax.servlet.ServletException;

public class CheckInMDCommand
extends AbstractCommand {
    private static final String UPDATE_VIEW_SQL = "UPDATE T_BIM_MDVIEW SET fCheckOutUser = null WHERE fProjectName=? AND fPath=? AND (fCheckOutUser = ?  OR fCheckOutUser is null)";
    private static final String MainMenuConfigFile = "FnMenuTree.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException, ServletException {
        String[] pks = StringUtils.split((String)this.request.getParameter("metadatapks"), (String)";");
        String projectName = this.getProjectName();
        String sql = UPDATE_VIEW_SQL;
        String username = this.getUserName();
        Connection conn = null;
        try {
            if (pks.length != 1 || !MainMenuConfigFile.equals(pks[0])) {
                pks = this.getRelationMetas(pks);
            }
            ArrayList<String> faildList = new ArrayList<String>();
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, projectName);
            pstmt.setString(3, username);
            for (int i = 0; i < pks.length; ++i) {
                String pk = pks[i].trim();
                if (StringUtils.isEmpty((String)pk)) continue;
                pstmt.setString(2, pk);
                int count = pstmt.executeUpdate();
                if (count >= 1) continue;
                faildList.add(pk);
            }
            pstmt.close();
            if (faildList.isEmpty()) {
                return;
            }
            String selectSql = "SELECT fPath, fCheckOutUser FROM T_BIM_MDVIEW WHERE fProjectName = ? AND (";
            for (int i = 0; i < faildList.size(); ++i) {
                if (i > 0) {
                    selectSql = selectSql + " OR ";
                }
                selectSql = selectSql + "fPath =?";
            }
            selectSql = selectSql + ")";
            PreparedStatement stmt = conn.prepareStatement(selectSql);
            stmt.setString(1, projectName);
            for (int i = 0; i < faildList.size(); ++i) {
                stmt.setString(i + 2, faildList.get(i).toString());
            }
            ResultSet rs = stmt.executeQuery();
            PrintWriter out = this.response.getWriter();
            while (rs.next()) {
                out.println(rs.getString(1) + ":" + rs.getString(2));
            }
            out.flush();
            out.close();
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.response.sendError(401, "check out metadata fail:" + this.getTrace(ex));
            return;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

