/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.command.impl;

import com.kingdee.bos.cloud.command.AbstractCommand;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.servlet.ServletException;

public class CheckOutMDCommand
extends AbstractCommand {
    private static final String UPDATE_VIEW_SQL = "UPDATE T_BIM_MDVIEW SET fCheckOutUser = ?, fCheckOutTime=? WHERE fProjectName=? AND fPath=? AND (fCheckOutUser is null OR fCheckOutUser = ?)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException, ServletException {
        String[] pks = this.request.getParameter("metadatapks").split(";");
        String sql = UPDATE_VIEW_SQL;
        String username = this.getUserName();
        Connection conn = null;
        boolean flag = true;
        ArrayList<String> faildList = new ArrayList<String>();
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            PreparedStatement pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, username);
            pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            pstmt.setString(3, this.getProjectName());
            pstmt.setString(5, username);
            for (int i = 0; i < pks.length; ++i) {
                String pk = pks[i].trim();
                if (StringUtils.isEmpty((String)pk)) continue;
                pstmt.setString(4, pk);
                int count = pstmt.executeUpdate();
                if (count >= 1) continue;
                flag = false;
                faildList.add(pk);
            }
            pstmt.close();
            if (flag) {
                conn.commit();
            } else {
                conn.rollback();
                StringBuffer querySql = new StringBuffer();
                querySql.append("SELECT fPath, fCheckOutUser FROM T_BIM_MDVIEW WHERE fProjectName=? AND (");
                int n = faildList.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        querySql.append(" OR");
                    }
                    querySql.append(" fPath=?");
                }
                querySql.append(")");
                PreparedStatement stmt = conn.prepareStatement(querySql.toString());
                stmt.setString(1, this.getProjectName());
                int n2 = faildList.size();
                for (int i = 0; i < n2; ++i) {
                    stmt.setString(i + 2, faildList.get(i).toString());
                }
                ResultSet rs = stmt.executeQuery();
                StringBuffer sb = new StringBuffer();
                while (rs.next()) {
                    sb.append(rs.getString(1) + ":" + rs.getString(2) + ";");
                }
                PrintWriter out = this.response.getWriter();
                out.println(sb.toString());
                out.flush();
                rs.close();
                stmt.close();
            }
        }
        catch (Exception ex) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            ex.printStackTrace();
            this.response.sendError(401, "check out metadata fail:" + this.getTrace(ex));
            return;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

