/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus;

import com.kingdee.bos.eventbus.IEventHandler;
import com.kingdee.bos.eventbus.RequestContext;
import com.kingdee.bos.eventbus.ResponseContext;

public abstract class KDEvent {
    private boolean dead;
    private Object source;
    private boolean needReturn = true;
    private Object successResult = null;
    private Object jsonResult = null;
    private boolean isIgnoreSource = false;
    private RequestContext reqeustContext;
    private ResponseContext responseContext;

    public final Object getSource() {
        this.assertLive();
        return this.source;
    }

    public String toDebugString() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        return "event: " + name + ":";
    }

    public String toString() {
        return "An event type:" + this.getClass().getName();
    }

    protected void assertLive() {
        assert (!this.dead) : "This event has already finished being processed by its original handler manager, so you can no longer access it";
    }

    protected abstract void dispatch(IEventHandler var1) throws Exception;

    public final boolean isLive() {
        return !this.dead;
    }

    public void kill() {
        this.dead = true;
    }

    protected final void revive() {
        this.dead = false;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public final RequestContext getReqeustContext() {
        if (this.reqeustContext == null) {
            this.reqeustContext = new RequestContext();
        }
        return this.reqeustContext;
    }

    public final ResponseContext getResponseContext() {
        if (this.responseContext == null) {
            this.responseContext = new ResponseContext();
        }
        return this.responseContext;
    }

    public void setResponseContext(ResponseContext responseContext) {
        this.responseContext = responseContext;
    }

    public boolean isIgnoreSource() {
        return this.isIgnoreSource;
    }

    public void setIgnoreSource(boolean isIgnoreSource) {
        this.isIgnoreSource = isIgnoreSource;
    }

    public Object getSuccessResult() {
        return this.successResult;
    }

    public void setSuccessResult(Object successResult) {
        this.successResult = successResult;
    }

    public void setJsonResult(Object jsonResult) {
        this.jsonResult = jsonResult;
    }

    public Object getJsonResult() {
        return this.jsonResult;
    }

    public boolean isNeedReturn() {
        return this.needReturn;
    }

    public void setNeedReturn(boolean needReturn) {
        this.needReturn = needReturn;
    }
}

