/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.converter;

import com.kingdee.bos.eventbus.converter.IConverterRegister;
import com.kingdee.bos.eventbus.parse.ConfigurationParseException;
import com.kingdee.bos.eventbus.parse.IConfigurationParser;
import com.kingdee.bos.eventbus.parse.ParserContext;
import com.kingdee.bos.eventbus.parse.XmlFileReader;
import java.util.Iterator;
import org.jdom2.Element;

class ConvertersXmlParser
implements IConfigurationParser {
    private ParserContext parserContext;
    private IConverterRegister converterRegister;

    public ConvertersXmlParser(ParserContext parserContext, IConverterRegister converterRegister) {
        this.parserContext = parserContext;
        this.converterRegister = converterRegister;
    }

    @Override
    public void parse() throws ConfigurationParseException {
        XmlFileReader reader = new XmlFileReader();
        Element root = reader.read(this.parserContext);
        this.doParse(root);
    }

    private void doParse(Element root) {
        Iterator iter = root.getChildren().iterator();
        while (iter.hasNext()) {
            this.parseConverter((Element)iter.next());
        }
    }

    private void parseConverter(Element element) {
        String converterName = element.getChildText("name");
        String[] types = this.parseTypes(element.getChild("types"));
        this.converterRegister.registerConverter(converterName, types);
    }

    private String[] parseTypes(Element element) {
        String[] types = new String[element.getChildren().size()];
        Iterator iter = element.getChildren().iterator();
        int i = 0;
        while (iter.hasNext()) {
            types[i++] = ((Element)iter.next()).getText();
        }
        return types;
    }
}

