/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.definition;

import com.kingdee.bos.eventbus.application.IApplication;
import com.kingdee.bos.eventbus.definition.RuleDefinition;
import com.kingdee.bos.eventbus.definition.UIConfig;
import com.kingdee.bos.eventbus.exception.UIConfigException;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Condition {
    private String expression;
    private String preparedExpression;
    private Map<String, Set<String>> expressionVariables;
    private String ruleId;
    private RuleDefinition rule;

    public RuleDefinition getRuleDefinition(IApplication application, UIConfig uiConfig) {
        if (this.rule == null) {
            this.initRuleDefinition(application, uiConfig);
        }
        return this.rule;
    }

    private void initRuleDefinition(IApplication application, UIConfig uiConfig) {
        if (!StringUtils.isEmpty((String)this.ruleId)) {
            this.rule = uiConfig.getRuleDefinition(this.ruleId);
            if (this.rule == null) {
                throw new UIConfigException(String.format("There is no %s rule in UI configuration.", this.ruleId));
            }
            this.rule.prepareExpression(application.getModelService().getEntityMetadata());
            return;
        }
        if (!StringUtils.isEmpty((String)this.expression)) {
            this.rule = new RuleDefinition(this.expression);
            this.rule.prepareExpression(application.getModelService().getEntityMetadata());
            return;
        }
    }

    void setExpression(String expression) {
        this.expression = expression;
    }

    void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public boolean booleanValue(List context) {
        if (this.rule == null) {
            return true;
        }
        boolean result = (Boolean)this.rule.evaluateValue(context);
        return result;
    }
}

