/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.register;

import com.kingdee.bos.eventbus.IKDEventFireFirer;
import com.kingdee.bos.eventbus.KDEvent;
import com.kingdee.bos.eventbus.application.IApplication;
import com.kingdee.bos.eventbus.definition.ActionDefinition;
import com.kingdee.bos.eventbus.event.action.KDActionEvent;
import com.kingdee.bos.eventbus.exception.EventCreateException;

public abstract class AbstractKDEventFirer
implements IKDEventFireFirer {
    private IApplication application;

    protected IApplication getApplication() {
        return this.application;
    }

    public AbstractKDEventFirer(IApplication application) {
        this.application = application;
    }

    @Override
    public final void fireActionEvent(String actionName, Object source) {
        ActionDefinition actionDefinition;
        KDEvent event = this.createActionEvent(actionName);
        if (source != null) {
            event.setSource(source);
        }
        if ((actionDefinition = this.application.getUIConfig().getActionDefinition(actionName)) != null) {
            actionDefinition.fireEvent(this.application.getEventBus(), event);
        } else {
            this.application.getEventBus().fireEvent(event);
        }
    }

    @Override
    public KDEvent createActionEvent(String actionName) {
        ActionDefinition action = this.application.getUIConfig().getActionDefinition(actionName);
        if (action == null) {
            throw new EventCreateException(String.format("The definition of Action [%s] does not exist in UIC.", actionName));
        }
        KDEvent event = (KDEvent)action.getEvent().createInstance(this.application);
        if (event instanceof KDActionEvent) {
            ((KDActionEvent)event).setActionName(actionName);
        }
        event.setSource(action.getSource());
        return event;
    }
}

