/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.support;

import com.kingdee.bos.eventbus.IEventHandler;
import com.kingdee.bos.eventbus.IExtendedBaseHandler;
import com.kingdee.bos.eventbus.PointCutEnum;
import com.kingdee.bos.eventbus.annotation.Action;
import com.kingdee.bos.eventbus.annotation.OnEvent;
import com.kingdee.bos.eventbus.application.IApplication;
import com.kingdee.bos.eventbus.application.IEventRegiterAssistant;
import com.kingdee.bos.eventbus.definition.ActionDefinition;
import com.kingdee.bos.eventbus.definition.Event;
import com.kingdee.bos.eventbus.definition.Handler;
import com.kingdee.bos.eventbus.definition.IComponentInitialize;
import com.kingdee.bos.eventbus.definition.Plugin;
import com.kingdee.bos.eventbus.register.IEventHandlerRegister;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class EventHandlerRegister
implements IEventHandlerRegister {
    private IApplication application;
    private IEventRegiterAssistant registerAssistant;

    public EventHandlerRegister(IApplication application, IEventRegiterAssistant registerAssistant) {
        this.application = application;
        this.registerAssistant = registerAssistant;
    }

    @Override
    public void registerHandlers(Map<String, Collection<Plugin>> pluginMap) {
        if (pluginMap == null) {
            return;
        }
        for (Collection<Plugin> plugins : pluginMap.values()) {
            for (Plugin plugin : plugins) {
                if (plugin.getHandler().isAnnotation()) {
                    this.registerAnnotationHandler(plugin);
                    continue;
                }
                this.registerHandler(plugin);
            }
        }
    }

    private void registerRPCPackingInvokeHandler(Plugin plugin, Collection<Plugin> serverPlugins) {
        IEventHandler handler = this.registerAssistant.createRPCPackingInvokeHandler(serverPlugins);
        if (this.application instanceof IComponentInitialize) {
            ((IComponentInitialize)((Object)this.application)).afterComponentCreate(handler);
        }
        this.registerHandler(plugin.getEventClass(), handler, plugin.getHandler());
    }

    private void registerHandler(Plugin plugin) {
        Class eventClass = plugin.getEventClass();
        IEventHandler handler = (IEventHandler)plugin.getHandler().createInstance(this.application);
        if (handler instanceof IExtendedBaseHandler) {
            ((IExtendedBaseHandler)((Object)handler)).setScript(plugin.getScript());
        }
        this.registerHandler(eventClass, handler, plugin.getHandler());
    }

    private void registerHandler(Class eventClass, IEventHandler handler, Handler handlerMeta) {
        Object source = handlerMeta.getSource();
        if (source == null) {
            this.application.getEventBus().addHandler(eventClass, handler);
        } else {
            Object exactSource = handlerMeta.getExactSource();
            this.application.getEventBus().addHandlerToSource(eventClass, exactSource, handler);
            if (exactSource instanceof String) {
                this.application.getEventFirer().fireComponentEvent(eventClass, (String)exactSource, handlerMeta.getParamsMap());
            }
        }
    }

    private void registerAnnotationHandler(Plugin plugin) {
        PointCutEnum pointcut = plugin.getPointcut();
        Object handlerInvoker = plugin.getHandler().createInstance(this.application);
        Method method = plugin.getHandler().getAnnotationMethod();
        OnEvent onEvent = method.getAnnotation(OnEvent.class);
        Class eventClass = Event.getEventClass(onEvent, method);
        Action action = this.parseAction(method, onEvent);
        IEventHandler handler = this.registerAssistant.createAnnotationEventHandler(handlerInvoker, method);
        this.registerHandler(eventClass, handler, plugin.getHandler());
    }

    private Action parseAction(Method method, OnEvent onEvent) {
        if (!method.isAnnotationPresent(Action.class)) {
            return null;
        }
        Action action = method.getAnnotation(Action.class);
        String actionName = action.value();
        ActionDefinition actionDefinition = this.application.getUIConfig().getThisActionDefinition(actionName);
        if (actionDefinition == null) {
            Class eventClass = Event.getEventClass(onEvent, method);
            actionDefinition = ActionDefinition.createActionDefinition(actionName, Event.createEvent(eventClass.getName()), action.method(), action.batchAction());
            if (!StringUtils.isEmpty((String)onEvent.source())) {
                actionDefinition.setSource(onEvent.source());
            }
            this.application.getUIConfig().addActionDefinition(actionDefinition);
        }
        return action;
    }

    @Override
    public void registerServerHandlers(Map<String, Collection<Plugin>> preparePlugins, Map<String, Collection<Plugin>> serverPlugins) {
        ArrayList<String> evtTypes = new ArrayList<String>();
        if (preparePlugins != null) {
            evtTypes.addAll(preparePlugins.keySet());
        }
        if (serverPlugins != null) {
            evtTypes.addAll(serverPlugins.keySet());
        }
        for (String evtType : evtTypes) {
            Plugin plugin;
            Collection<Plugin> prePlugins = preparePlugins.get(evtType);
            Collection<Plugin> srvPlugins = serverPlugins.get(evtType);
            if (prePlugins != null && prePlugins.size() > 0) {
                plugin = prePlugins.iterator().next();
            } else {
                if (srvPlugins == null || srvPlugins.size() <= 0) continue;
                plugin = srvPlugins.iterator().next();
            }
            this.registerRPCPackingInvokeHandler(plugin, srvPlugins);
        }
    }
}

