/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.support;

import com.kingdee.bos.eventbus.application.IApplication;
import com.kingdee.bos.eventbus.application.IServicesAccess;
import com.kingdee.bos.eventbus.definition.Service;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class ServicesContainer
implements IServicesAccess {
    private final IApplication application;
    private Map<String, Object> services = new HashMap<String, Object>();

    public ServicesContainer(IApplication application) {
        this.application = application;
    }

    @Override
    public <T> T getService(Class<T> interfaceType) {
        assert (interfaceType != null);
        Service service = this.application.getUIConfig().getServiceByInterface(interfaceType.getName());
        return interfaceType.cast(this.getService(service.getId()));
    }

    public void createServiceInstances() {
        Collection<Service> collection = this.application.getUIConfig().getIntegralServices();
        if (collection.size() == 0) {
            return;
        }
        for (Service service : collection) {
            if (this.services.containsKey(service.getId()) || service.isLazyInit()) continue;
            Object object = this.createServiceInstance(service);
        }
    }

    private Object createServiceInstance(Service service) {
        if (service == null) {
            return null;
        }
        Object instance = service.createInstance(this.application);
        this.services.put(service.getId(), instance);
        return instance;
    }

    @Override
    public Object getService(String serviceName) {
        Object serviceInstance = this.services.get(serviceName);
        if (serviceInstance == null) {
            Service service = this.application.getUIConfig().getService(serviceName);
            this.createServiceInstance(service);
            serviceInstance = this.services.get(serviceName);
        }
        return serviceInstance;
    }

    public void destroy() throws Exception {
        for (String sname : this.services.keySet()) {
            Object instance = this.services.get(sname);
            Service service = this.application.getUIConfig().getService(sname);
            service.destroyInstance(instance);
        }
    }
}

