/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.expression;

import com.kingdee.bos.expression.ExpressionExecutor;
import com.kingdee.bos.expression.ExpressionToken;
import com.kingdee.bos.expression.IllegalExpressionException;
import com.kingdee.bos.expression.VariableContainer;
import com.kingdee.bos.expression.datameta.Constant;
import com.kingdee.bos.expression.datameta.Variable;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PreparedExpression {
    private String orgExpression;
    private List<ExpressionToken> expTokens;
    private Map<String, Variable> variableMap;

    PreparedExpression(String orgExpression, List<ExpressionToken> expTokens, Map<String, Variable> variableMap) {
        this.orgExpression = orgExpression;
        this.expTokens = expTokens;
        this.variableMap = new HashMap<String, Variable>(variableMap);
    }

    public synchronized void setArgument(String name, Object value) {
        Variable v = this.variableMap.get(name);
        if (v == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u8bc6\u522b\u7684\u8868\u8fbe\u5f0f\u53c2\u6570\uff1a" + name);
        }
        v.setVariableValue(value);
    }

    public Object execute() {
        ExpressionExecutor ee = new ExpressionExecutor();
        try {
            VariableContainer.setVariableMap(new HashMap<String, Variable>(this.variableMap));
            Constant constant = ee.execute(this.expTokens);
            Object object = constant.toJavaObject();
            return object;
        }
        catch (IllegalExpressionException e) {
            e.printStackTrace();
            throw new RuntimeException("\u8868\u8fbe\u5f0f\uff1a\"" + this.orgExpression + "\" \u6267\u884c\u5f02\u5e38");
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException("\u8868\u8fbe\u5f0f\uff1a\"" + this.orgExpression + "\" \u6267\u884c\u5f02\u5e38");
        }
        finally {
            VariableContainer.removeVariableMap();
        }
    }
}

