/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.expression.function;

import com.kingdee.bos.eventbus.parse.ConfigurationParseException;
import com.kingdee.bos.eventbus.parse.IConfigurationParser;
import com.kingdee.bos.eventbus.parse.ParserContext;
import com.kingdee.bos.eventbus.parse.XmlFileReader;
import com.kingdee.bos.expression.function.Function;
import com.kingdee.bos.expression.function.FunctionLoader;
import com.kingdee.bos.expression.function.Parameter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;

public final class FunctionXmlParser
implements IConfigurationParser {
    private ParserContext parserContext;

    public FunctionXmlParser() {
    }

    FunctionXmlParser(ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    @Override
    public void parse() throws ConfigurationParseException {
        XmlFileReader reader = new XmlFileReader();
        Element root = reader.read(this.parserContext);
        this.doParse(root);
    }

    public void doParse(Element root) {
        Iterator iter = root.getChildren().iterator();
        while (iter.hasNext()) {
            this.parseFunctionBean((Element)iter.next());
        }
    }

    private void parseFunctionBean(Element element) {
        String className = element.getAttributeValue("class");
        try {
            Class<?> _class = Class.forName(className);
            List<Parameter> constructorArgs = this.parseConstructorArgs(element.getChild("constructor"));
            HashSet<Function> functions = this.parseFunctions(element);
            if (functions.size() <= 0) {
                return;
            }
            Object instance = null;
            if (constructorArgs == null || constructorArgs.size() <= 0) {
                instance = _class.newInstance();
            } else {
                Class[] cs = this.getParameterTypes(constructorArgs);
                Object[] ps = this.getParameterValues(constructorArgs);
                Constructor<?> c = _class.getConstructor(cs);
                instance = c.newInstance(ps);
            }
            for (Function f : functions) {
                Method method = _class.getMethod(f.methodName, this.getParameterTypes(f.types));
                FunctionLoader.addFunction(f.name, instance, method);
            }
        }
        catch (Exception e) {
            throw new FunctionRegisterException("" + className + "", e);
        }
    }

    private List<Parameter> parseConstructorArgs(Element element) {
        if (element == null) {
            return null;
        }
        ArrayList<Parameter> args = new ArrayList<Parameter>();
        for (Element child : element.getChildren()) {
            String type = child.getAttributeValue("type");
            String value = child.getAttributeValue("value");
            args.add(new Parameter(type, value));
        }
        return args;
    }

    private HashSet<Function> parseFunctions(Element element) {
        HashSet<Function> functions = new HashSet<Function>();
        for (Element child : element.getChildren()) {
            if (!child.getName().equals("function") || functions.add(this.parseFunction(child))) continue;
            throw new FunctionRegisterException("");
        }
        return functions;
    }

    private Function parseFunction(Element element) {
        String name = element.getAttributeValue("name");
        String methodName = element.getAttributeValue("method");
        Function f = new Function(name, methodName);
        Iterator iter = element.getChildren().iterator();
        while (iter.hasNext()) {
            f.addType(((Element)iter.next()).getText());
        }
        return f;
    }

    private Class[] getParameterTypes(List<Parameter> parameters) {
        if (parameters == null) {
            return null;
        }
        Class[] types = new Class[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            types[i] = parameters.get((int)i).type;
        }
        return types;
    }

    private Object[] getParameterValues(List<Parameter> parameters) {
        if (parameters == null) {
            return null;
        }
        Object[] values = new Object[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            values[i] = parameters.get((int)i).value;
        }
        return values;
    }

    class FunctionRegisterException
    extends RuntimeException {
        FunctionRegisterException(String message) {
            super(message);
        }

        FunctionRegisterException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

