/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.meta;

import com.kingdee.bos.meta.MetaDTO;
import com.kingdee.bos.meta.entity.IEntityMetadata;
import com.kingdee.bos.meta.query.IQueryMetadata;
import com.kingdee.bos.meta.ui.MetaListUI;
import com.kingdee.bos.util.BOSObjectType;
import java.util.HashMap;
import java.util.Map;

public final class MetadataCache {
    private static final MetadataCache instance = new MetadataCache();
    private static final Map<BOSObjectType, IEntityMetadata> metaEntityCache = new HashMap<BOSObjectType, IEntityMetadata>();
    private static final Map<String, IQueryMetadata> metaQueryCache = new HashMap<String, IQueryMetadata>();
    private static final Map<String, MetaListUI> metaListUICache = new HashMap<String, MetaListUI>();

    public static MetadataCache getInstance() {
        return instance;
    }

    public IEntityMetadata getEntityMetadata(BOSObjectType bosType) {
        return metaEntityCache.get(bosType);
    }

    public IQueryMetadata getQueryMetadata(String pk) {
        return metaQueryCache.get(pk);
    }

    public MetaListUI getDynamicUIMetadata(String pk) {
        return metaListUICache.get(pk);
    }

    public void clearUMetadata(String pk) {
        metaListUICache.remove(pk);
    }

    public void putMetaDTO(MetaDTO dto) {
        metaEntityCache.put(dto.metaEntity.getBosType(), dto.metaEntity);
        metaQueryCache.put(dto.metaQuery.getFullName(), dto.metaQuery);
        metaListUICache.put(dto.metaUI.getName(), dto.metaUI);
    }

    private MetadataCache() {
    }
}

