/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.meta.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.meta.query.MetaField;
import com.kingdee.bos.meta.query.MetaQuery;
import com.kingdee.bos.meta.query.QueryInfoVisitor;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QueryInfoVisitorImpl
implements QueryInfoVisitor {
    private MetaQuery metaQuery = new MetaQuery();
    private Map<String, List<String>> structure = new HashMap<String, List<String>>();
    private String mainObjectName;

    @Override
    public void visit(QueryInfo queryInfo) throws BOSException {
        this.metaQuery.fullName = queryInfo.getFullName();
        this.mainObjectName = queryInfo.getMainObject().getName();
        SubObjectCollection subs = queryInfo.getSubObjects();
        int size = subs.size();
        for (int i = 0; i < size; ++i) {
            SubObjectInfo sub = subs.get(i);
            this.visit(sub);
        }
        PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
        size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo)) continue;
            QueryFieldInfo fieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i);
            this.visit(fieldInfo);
        }
    }

    @Override
    public void visit(QueryFieldInfo fieldInfo) {
        MetaField field = new MetaField();
        field.name = fieldInfo.getName();
        String refPropertyName = fieldInfo.getRefPropertyName();
        PropertyRefInfo refInfo = fieldInfo.getPropertyRefs().get(0);
        String subName = refInfo.getSubEntity().getName();
        String prefix = this.retriveParentPrefix(this.mainObjectName, subName);
        field.fullPropertyName = prefix != null ? prefix + "." + refPropertyName : refPropertyName;
        this.addMetaField(field);
    }

    private void addMetaField(MetaField field) {
        this.metaQuery.queryFields.add(field);
    }

    private String retriveParentPrefix(String parentName, String subName) {
        if (this.mainObjectName.equals(subName)) {
            return null;
        }
        String shortName = parentName;
        int idx = parentName.lastIndexOf(46);
        if (idx > 0) {
            shortName = parentName.substring(idx + 1);
        }
        List<String> children = this.structure.get(shortName);
        Iterator<String> iter = children.iterator();
        HashSet<String> hasChildren = new HashSet<String>();
        while (iter.hasNext()) {
            String name = iter.next();
            if (name.equals(subName)) {
                return (this.mainObjectName.equals(parentName) ? "" : parentName + ".") + name;
            }
            if (!this.structure.containsKey(name)) continue;
            hasChildren.add(name);
        }
        for (String name : hasChildren) {
            String prefix = this.retriveParentPrefix((this.mainObjectName.equals(parentName) ? "" : parentName + ".") + name, subName);
            if (prefix == null) continue;
            return prefix;
        }
        return null;
    }

    @Override
    public void visit(SubObjectInfo sub) {
        String subName = sub.getName();
        JoinCollection jc = sub.getJoinsFromClient();
        if (jc.size() == 0) {
            return;
        }
        List<String> children = this.structure.get(subName);
        if (children == null) {
            children = new ArrayList<String>(jc.size());
            this.structure.put(subName, children);
        }
        int jsize = jc.size();
        for (int j = 0; j < jsize; ++j) {
            JoinInfo join = jc.get(j);
            String rightName = join.getRightObject().getName();
            children.add(rightName);
        }
    }

    public MetaQuery getMetaQuery() {
        return this.metaQuery;
    }
}

