/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.consumer.ack;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.rabbitmq.amqp.Channel;
import com.kingdee.bos.rabbitmq.connection.ChannelFactory;
import com.kingdee.bos.rabbitmq.consumer.QueueManager;
import com.kingdee.bos.rabbitmq.consumer.ack.MessageAcker;
import com.kingdee.bos.rabbitmq.entity.ConnectionEntity;
import com.kingdee.bos.rabbitmq.entity.ExtendEntity;
import com.kingdee.bos.rabbitmq.entity.ProductorEntity;
import com.kingdee.bos.rabbitmq.initialize.ConfigManager;
import com.kingdee.bos.rabbitmq.productor.publish.RabbitMQPublisher;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import java.io.IOException;
import org.apache.log4j.Logger;

public class RabbitAcker
implements MessageAcker {
    private static final Logger logger = Logger.getLogger((String)RabbitAcker.class.getName());
    private Channel channel;
    private boolean autoAck;
    private boolean needCallBack;
    private String queueName;
    private String region;
    private String productorName;
    private ProductorEntity autoCallBackProductor;
    private ConnectionEntity connectionInfo;
    private boolean isFinsh;

    public RabbitAcker(Channel channel, boolean autoAck, boolean needCallBack, String queueName, String region, String productorName) {
        this.channel = channel;
        this.autoAck = autoAck;
        this.needCallBack = needCallBack;
        this.queueName = queueName;
        this.region = region;
        this.productorName = productorName;
    }

    public RabbitAcker(Channel channel, boolean autoAck, boolean needCallBack, String queueName, String region, ProductorEntity autoCallBackProductor, ConnectionEntity connectionInfo) {
        this.channel = channel;
        this.autoAck = autoAck;
        this.needCallBack = needCallBack;
        this.queueName = queueName;
        this.region = region;
        this.autoCallBackProductor = autoCallBackProductor;
        this.connectionInfo = connectionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ack(String messageId, String data) {
        if (this.isFinsh) {
            return;
        }
        this.setFinsh();
        if (!this.autoAck) {
            long deliveryTag = this.toTag(messageId);
            try {
                try {
                    this.dealCallBackMsg(data);
                }
                catch (Exception e) {
                    logger.error((Object)"isc-rabbitmq \u5904\u7406\u81ea\u52a8\u53cd\u9988\u5f02\u5e38", (Throwable)e);
                }
                finally {
                    this.channel.basicAck(deliveryTag, false);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("can't ack the message " + deliveryTag, e);
            }
        }
    }

    private void dealCallBackMsg(String data) {
        if (StringUtils.isEmpty(data)) {
            logger.warn((Object)"the deal callback message ,message body is null.");
            return;
        }
        if (this.needCallBack) {
            this.sendCallBackMsg(data);
        }
    }

    private void sendCallBackMsg(String data) {
        ExtendEntity extendEntity = null;
        JSONObject entendData = null;
        Channel backChannel = null;
        if (StringUtils.isNotEmpty(this.productorName)) {
            ProductorEntity productor = ConfigManager.getProductor(this.productorName);
            if (!StringUtils.isNullObj(productor)) {
                ConnectionEntity prodConn = ConfigManager.getConnection(productor.getConnection());
                backChannel = ChannelFactory.getChannel(this.region, prodConn);
                extendEntity = productor.getExtend();
            }
        } else if (null != this.autoCallBackProductor) {
            backChannel = ChannelFactory.getChannel(this.region, this.connectionInfo);
            extendEntity = this.autoCallBackProductor.getExtend();
        }
        if (!StringUtils.isNullObj(extendEntity)) {
            entendData = extendEntity.getExtendData();
        }
        String realQueueName = QueueManager.getCallbackQueueName(this.queueName, true);
        QueueManager.declareIfNeed(backChannel, this.region, realQueueName);
        RabbitMQPublisher mqPublisher = new RabbitMQPublisher(realQueueName, backChannel, entendData);
        mqPublisher.publish(data);
        mqPublisher.close();
    }

    private long toTag(String messageId) {
        return Long.parseLong(messageId);
    }

    @Override
    public void deny(String messageId) {
        if (this.isFinsh) {
            return;
        }
        this.setFinsh();
        if (!this.autoAck) {
            long deliveryTag = this.toTag(messageId);
            try {
                this.channel.basicReject(deliveryTag, true);
            }
            catch (IOException e) {
                throw new RuntimeException("can't ack the message " + deliveryTag, e);
            }
        }
    }

    @Override
    public boolean isFinsh() {
        return this.isFinsh;
    }

    public void setFinsh() {
        this.isFinsh = true;
    }

    @Override
    public void setFinsh(boolean finsh) {
        this.isFinsh = finsh;
    }
}

