/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.initialize;

import com.kingdee.bos.rabbitmq.constant.MQConstantEnum;
import com.kingdee.bos.rabbitmq.entity.MQConfInfoEntity;
import com.kingdee.bos.rabbitmq.thread.RefreshReadTask;
import com.kingdee.bos.rabbitmq.util.PropertiesUtils;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.log4j.Logger;

public class InitConfig {
    private static Logger log = Logger.getLogger((String)InitConfig.class.getName());
    private static MQConfInfoEntity mqConfigCache;
    private static Properties sysProperties;

    protected static MQConfInfoEntity getConfig() {
        try {
            sysProperties = PropertiesUtils.loadProperties();
        }
        catch (Exception e) {
            log.error((Object)"the path:/com/kingdee/bos/rabbitmq/config.properties properties file read failed.");
            throw new RuntimeException("The path:/com/kingdee/bos/rabbitmq/config.properties properties file read failed", e);
        }
        if (null != mqConfigCache) {
            return mqConfigCache;
        }
        InitConfig.refreshRead(sysProperties.getProperty(MQConstantEnum.MQ_CONFIG_REFRESH.getDesc()));
        return InitConfig.readConfig();
    }

    protected static MQConfInfoEntity getPublishConfig() {
        sysProperties = PropertiesUtils.loadProperties();
        if (null != mqConfigCache) {
            return mqConfigCache;
        }
        return InitConfig.readConfig();
    }

    public static MQConfInfoEntity loadMQConfigInfo(String dealClass, String path) throws Exception {
        MQConfInfoEntity mqConfig = null;
        if (StringUtils.isEmpty(dealClass) || StringUtils.isEmpty(path)) {
            log.error((Object)"the config file deal class or config path is not exist.");
            return mqConfig;
        }
        Class<?> clazz = Class.forName(dealClass);
        Method method = clazz.getMethod("execute", String.class);
        mqConfig = (MQConfInfoEntity)method.invoke(clazz.newInstance(), path);
        return mqConfig;
    }

    public static synchronized void cacheMQConfigInfo(String sysType, MQConfInfoEntity mqConfig) throws Exception {
        if (MQConstantEnum.IERP_SYSTME.getDesc().equals(sysType) && null != mqConfig) {
            Class<?> cacheClazz = Class.forName(MQConstantEnum.IERP_CACHE_REFLECT_CLASS.getDesc());
            Method cacheMethod = cacheClazz.getMethod("setMQConfig", MQConfInfoEntity.class);
            Method clearCacheMethod = cacheClazz.getMethod("clearMQConfig", new Class[0]);
            clearCacheMethod.invoke(cacheClazz.newInstance(), new Object[0]);
            cacheMethod.invoke(cacheClazz.newInstance(), mqConfig);
        } else {
            mqConfigCache = mqConfig;
        }
    }

    private static MQConfInfoEntity readConfig() {
        MQConfInfoEntity mqConfig = null;
        if (null == sysProperties) {
            log.error((Object)"the rabbitmq system properties config file is null.");
            return mqConfig;
        }
        String path = sysProperties.getProperty(MQConstantEnum.MQ_CONFIG_PATH.getDesc());
        String dealClass = sysProperties.getProperty(MQConstantEnum.MQ_CONFIG_INITCLASS.getDesc());
        try {
            mqConfig = InitConfig.loadMQConfigInfo(dealClass, path);
        }
        catch (Exception e) {
            log.error((Object)("Load MQ config information faild." + e.getMessage()));
            throw new RuntimeException("Load MQ config information faild", e);
        }
        return mqConfig;
    }

    private static void refreshRead(String strRefresh) {
        int refreshTime = 0;
        if (StringUtils.isNotEmpty(strRefresh) && strRefresh.matches("^[0]|[1-9][0-9]*$")) {
            refreshTime = Integer.parseInt(strRefresh);
        }
        if (refreshTime <= 0) {
            return;
        }
        new Thread(new RefreshReadTask(sysProperties)).start();
    }
}

