/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.productor.mqfactory;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.rabbitmq.constant.MQConstantEnum;
import com.kingdee.bos.rabbitmq.entity.ConnectionEntity;
import com.kingdee.bos.rabbitmq.entity.ProductorEntity;
import com.kingdee.bos.rabbitmq.entity.PublisherEntity;
import com.kingdee.bos.rabbitmq.initialize.ConfigManager;
import com.kingdee.bos.rabbitmq.productor.mqfactory.MQBatchFactory;
import com.kingdee.bos.rabbitmq.productor.mqfactory.RabbitMQFactory;
import com.kingdee.bos.rabbitmq.productor.publish.MessagePublisher;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class MQFactory {
    private static Logger logger = Logger.getLogger((String)MQFactory.class.getName());
    private static ProductorEntity productor;
    private static ConnectionEntity connection;
    private static PublisherEntity publisherEntity;

    public abstract MessagePublisher createSimplePublisher(String var1, String var2, String var3);

    public abstract List<MessagePublisher> createSimplePublisher();

    protected abstract MessagePublisher createSimplePublisher(String var1, String var2, String var3, String var4, ConnectionEntity var5, JSONObject var6);

    protected abstract MessagePublisher createSimplePublisher(String var1, String var2, String var3, ConnectionEntity var4, JSONObject var5);

    public static MQFactory get(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        productor = ConfigManager.getProductor(name);
        String conName = null;
        String mqType = null;
        if (!StringUtils.isNullObj(productor)) {
            conName = productor.getConnection();
            mqType = productor.getType();
        }
        connection = ConfigManager.getConnection(conName);
        if (MQConstantEnum.RABBITMQ_TYPE.getDesc().equals(mqType)) {
            return new RabbitMQFactory();
        }
        return null;
    }

    public static MQFactory getPublisher(String name) {
        if (StringUtils.isEmpty(name)) {
            logger.error((Object)"get publisher info failed,becauser the parameter is null.");
            return null;
        }
        publisherEntity = ConfigManager.getPublisherEntity(name);
        if (null == publisherEntity) {
            logger.error((Object)"get publisher information is not exist.");
            return null;
        }
        String productor = publisherEntity.getProductor();
        return MQFactory.get(productor);
    }

    protected static MQFactory get() {
        return new RabbitMQFactory();
    }

    protected ProductorEntity getProductor() {
        return productor;
    }

    protected ConnectionEntity getConnection() {
        return connection;
    }

    public PublisherEntity getPublisherEntity() {
        return publisherEntity;
    }

    private static MQBatchFactory getBatch(List<String> names) {
        return new MQBatchFactory(names);
    }
}

