/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.support;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.rabbitmq.entity.ProductorParamEntity;
import com.kingdee.bos.rabbitmq.productor.mqfactory.MQProductor;
import com.kingdee.bos.rabbitmq.support.EASModelConvert;
import com.kingdee.bos.rabbitmq.util.MQThreadLocalUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.rabbitmq.rabbit.MQDataRecordFactory;
import com.kingdee.eas.rabbitmq.rabbit.MQDataRecordInfo;
import com.kingdee.eas.rabbitmq.rabbit.MQDataRecordTreeFactory;
import com.kingdee.eas.rabbitmq.rabbit.MQDataRecordTreeInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitPublishFactory;
import com.kingdee.eas.rabbitmq.rabbit.RabbitPublishInfo;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class EASMQPublish {
    private static Logger logger = Logger.getLogger((String)EASMQPublish.class.getName());

    public static void publish(Context ctx, String publishId, String message) throws Exception {
        int currentPage = MQThreadLocalUtil.getCurrentPage();
        try {
            JSONObject sendData = JSONObject.parseObject((String)message);
            if (StringUtils.isEmpty((String)sendData.getString("page"))) {
                sendData.put("page", (Object)currentPage);
            }
            message = sendData.toJSONString();
        }
        catch (Throwable sendData) {
            // empty catch block
        }
        ProductorParamEntity proudctor = EASModelConvert.convertProductorParam(ctx, publishId);
        MQProductor.easPublish(proudctor, message);
        EASMQPublish.saveMQData(ctx, publishId, message, currentPage);
    }

    public static void rePublish(Context ctx, String publishId, String message) throws Exception {
        ProductorParamEntity proudctor = EASModelConvert.convertProductorParam(ctx, publishId);
        MQProductor.easPublish(proudctor, message);
    }

    private static void saveMQData(Context ctx, String publishId, String message, int currentPage) throws Exception {
        if (!MQThreadLocalUtil.isInit()) {
            return;
        }
        MQDataRecordTreeInfo treeInfo = MQThreadLocalUtil.getTreeInfo(publishId);
        if (treeInfo == null) {
            treeInfo = new MQDataRecordTreeInfo();
            treeInfo.setNumber(MQThreadLocalUtil.getTaskNumber());
            treeInfo.setName(MQThreadLocalUtil.getTaskNumber());
            treeInfo.setTaskId(MQThreadLocalUtil.getTaskId());
            treeInfo.setAction("\u521d\u59cb\u5316");
            RabbitPublishInfo publishInfo = RabbitPublishFactory.getLocalInstance(ctx).getRabbitPublishInfo("where id='" + publishId + "'");
            treeInfo.setPublishId(publishInfo);
            MQDataRecordTreeFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)treeInfo);
            MQThreadLocalUtil.setTreeId(publishId, treeInfo);
        }
        MQDataRecordInfo recordInfo = new MQDataRecordInfo();
        recordInfo.setPage(currentPage);
        recordInfo.setData(message);
        recordInfo.setTreeid(treeInfo);
        MQDataRecordFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)recordInfo);
    }

    public static void publish(Context ctx, List<String> ids, String message) throws Exception {
        logger.error((Object)"the EAS system mq publish message again...");
        List<ProductorParamEntity> proudctors = EASModelConvert.convertProductorParam(ctx, ids);
        MQProductor.easPublish(proudctors, message);
    }
}

