/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.tools.jsonrpc;

import com.kingdee.bos.rabbitmq.tools.json.JSONUtil;
import java.util.Collection;
import java.util.Map;

public class ParameterDescription {
    public String name;
    public String type;

    public ParameterDescription() {
    }

    public ParameterDescription(Map<String, Object> pm) {
        JSONUtil.tryFill(this, pm);
    }

    public ParameterDescription(int index, Class<?> c) {
        this.name = "param" + index;
        this.type = ParameterDescription.lookup(c);
    }

    public static String lookup(Class<?> c) {
        if (c == Void.class) {
            return "nil";
        }
        if (c == Boolean.class) {
            return "bit";
        }
        if (c == Integer.class) {
            return "num";
        }
        if (c == Double.class) {
            return "num";
        }
        if (c == String.class) {
            return "str";
        }
        if (c.isArray()) {
            return "arr";
        }
        if (Map.class.isAssignableFrom(c)) {
            return "obj";
        }
        if (Collection.class.isAssignableFrom(c)) {
            return "arr";
        }
        return "any";
    }
}

