/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.ConnectionObject;
import com.kingdee.eas.base.attachment.FtpConfigHelper;
import com.kingdee.eas.base.attachment.FtpConfigInfo;
import com.kingdee.eas.base.attachment.FtpException;
import com.kingdee.eas.base.attachment.FtpHandleFacadeFactory;
import com.kingdee.eas.base.attachment.IFtpHandleFacade;
import com.kingdee.eas.base.attachment.app.IAttachmentMove;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AttachmentMoveToFTP
implements IAttachmentMove {
    private static final Logger logger = Logger.getLogger((String)AttachmentMoveToFTP.class.getName());
    private FtpConfigInfo configInfo;
    private ConnectionObject connObject;
    private IFtpHandleFacade ftpHandleFacade;

    public AttachmentMoveToFTP(FtpConfigInfo configInfo) throws BOSException, EASBizException {
        if (configInfo == null) {
            throw new FtpException(FtpException.FTPNOTFOUND);
        }
        this.configInfo = configInfo;
    }

    public void setConnObject(FtpConfigInfo configInfo) throws BOSException, EASBizException {
        try {
            this.connObject = new ConnectionObject(configInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new FtpException(FtpException.FTPCONNECTEDFAIL);
        }
    }

    @Override
    public void delete(Context ctx, Map pathMap) throws BOSException, EASBizException {
        if (pathMap == null) {
            return;
        }
        Iterator it = pathMap.values().iterator();
        while (it.hasNext()) {
            this.getIFtpHandleFacade(ctx).deleteFile(this.connObject, (String)it.next());
        }
    }

    @Override
    public boolean move(Context ctx, AttachmentInfo attachmentInfo, String path) throws BOSException, EASBizException {
        return this.getIFtpHandleFacade(ctx).upload(this.connObject, attachmentInfo.getFile(), path);
    }

    @Override
    public String getPath(Context ctx, AttachmentInfo attachmentInfo) throws BOSException, EASBizException {
        return FtpConfigHelper.getRemotePath(ctx, this.configInfo.getRootPath(), attachmentInfo);
    }

    @Override
    public void delete(Context ctx, String path) throws BOSException, EASBizException {
        if (path == null) {
            return;
        }
        this.getIFtpHandleFacade(ctx).deleteFile(this.configInfo, path);
    }

    @Override
    public boolean updateAttachment(Context ctx, Map pathMap) throws BOSException, EASBizException {
        if (pathMap == null || pathMap.size() == 0) {
            return false;
        }
        String sql = "update t_bas_attachment set fremotepath = ?, fftpid = ?, ffile = null,fstoragetype =1 where fid = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Set keySet = pathMap.keySet();
        for (Object key : keySet) {
            Object[] params = new Object[]{pathMap.get(key), this.configInfo.getId().toString(), key};
            paramsList.add(params);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        return true;
    }

    private IFtpHandleFacade getIFtpHandleFacade(Context ctx) throws BOSException, EASBizException {
        if (this.ftpHandleFacade == null) {
            this.ftpHandleFacade = FtpHandleFacadeFactory.getLocalInstance(ctx);
        }
        return this.ftpHandleFacade;
    }
}

