/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentSizeFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentFtpFacade;
import com.kingdee.eas.base.attachment.IAttachmentSize;
import com.kingdee.eas.base.attachment.IBizobjectFacade;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentHelper;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfo;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfoCollection;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfoSelector;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.ftp.AttachmentDownloadClient;
import com.kingdee.eas.base.attachment.ftp.AttachmentUploadClient;
import com.kingdee.eas.base.attachment.util.AttachmentEncryptUtil;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.attachment.util.VariousAttachmentInfoMaker;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public abstract class AttachmentBaseManager {
    Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.attachment.common.AttachmentBaseManager");
    private Context context = null;

    protected abstract IAttachment getIA() throws BOSException;

    protected abstract IBoAttchAsso getIBAA() throws BOSException;

    protected abstract IBizobjectFacade getIBF() throws BOSException;

    protected abstract IAttachmentFtpFacade getIAFF() throws BOSException;

    public void deleteAttachemtsByBoID(String boID) throws BOSException, EASBizException {
        this.getIBAA().deleteAllAssociationsByBoID(boID);
    }

    public void deleteOneAssociation(String boID, String attchID) throws BOSException, EASBizException {
        this.getIBAA().deleteOneAssociation(boID, attchID);
    }

    public String[] getAttachmentIDsByBoID(String boID) throws BOSException {
        String[] ids = null;
        ids = this.getIBAA().getAttchIDsByBoID(boID);
        return ids;
    }

    public String[] getAttachmentIDsByBoBOSType(String boBOSType) throws BOSException {
        return this.getIBAA().getAttachIDsByBOSType(boBOSType);
    }

    public String[] getAttachmentIDsByBoBOSTypeAndBeginTime(String boBOSType, Timestamp beginTime) throws BOSException {
        return this.getIBAA().getAttachIDsByBOSTypeAndBeginTime(boBOSType, beginTime);
    }

    public String[] getAttachmentIDsByBoIDAndCode(String boID, String code) throws BOSException {
        return this.getIBAA().getAttchIDsByBoIDAndCode(boID, code);
    }

    public int getAttachmentCountByBoID(String boID) throws BOSException {
        return this.getIBAA().getAttchCountByBoID(boID);
    }

    public ComplexAttachmentInfo getComplexAttachmentInfo(String attchID, ComplexAttachmentInfoSelector cais) throws BOSException, EASBizException {
        return VariousAttachmentInfoMaker.makeComplexAttachmentInfo(this.getIA(), this.getIAFF(), attchID, cais);
    }

    public ComplexAttachmentInfo getComplexAttachmentInfo(String attchID) throws BOSException, EASBizException {
        return VariousAttachmentInfoMaker.makeComplexAttachmentInfo(this.getIA(), this.getIAFF(), attchID);
    }

    public void updateAttachmentMainName(String attchID, String boID, String mainname) throws BOSException, EASBizException {
        String type = StringUtil4File.getAttachmentType(this.getIA(), attchID);
        if (type.equals("url")) {
            StringUtil4File.checkURL(this.getIA(), boID, mainname);
        } else {
            StringUtil4File.checkFile(this.getIA(), boID, mainname);
        }
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add(new SelectorItemInfo("id"));
        AttachmentInfo ai = this.getIA().getAttachmentInfo((IObjectPK)new ObjectUuidPK(attchID), sic1);
        ai.setName(mainname);
        SelectorItemCollection sic2 = new SelectorItemCollection();
        sic2.add(new SelectorItemInfo("name"));
        this.getIA().updatePartial(ai, sic2);
    }

    public void updateAttachmentDescription(String attchID, String description) throws BOSException, EASBizException {
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add(new SelectorItemInfo("id"));
        AttachmentInfo ai = this.getIA().getAttachmentInfo((IObjectPK)new ObjectUuidPK(attchID), sic1);
        ai.setDescription(description);
        SelectorItemCollection sic2 = new SelectorItemCollection();
        sic2.add(new SelectorItemInfo("description"));
        this.getIA().updatePartial(ai, sic2);
    }

    public void updateAttachmentContent(String attchID, byte[] content) throws BOSException, EASBizException {
        StringUtil4File.checkFile(this.getIA(), content);
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add(new SelectorItemInfo("id"));
        sic1.add(new SelectorItemInfo("storageType"));
        AttachmentInfo ai = this.getIA().getAttachmentInfo((IObjectPK)new ObjectUuidPK(attchID), sic1);
        ai.setFile(content);
        ai.setSizeInByte(content.length);
        ai.setSize(StringUtil4File.getFileSizeRepresentation(content.length));
        SelectorItemCollection sic2 = new SelectorItemCollection();
        sic2.add(new SelectorItemInfo("file"));
        sic2.add(new SelectorItemInfo("sizeInByte"));
        sic2.add(new SelectorItemInfo("size"));
        if (content.length < 0x500000) {
            this.getIA().updatePartial(ai, sic2);
        } else if (content.length > 0x500000) {
            AttachmentUploadClient auc = new AttachmentUploadClient(this.getIAFF());
            String fileId = auc.uploadFile4Client(content);
            this.getIAFF().updateContent(ai.getId().toString(), fileId);
        }
    }

    public IObjectValue getBizobjectInfo(String boID) throws BOSException {
        return this.getIBF().getBizobjectInfo(boID);
    }

    public void addAssociations(String boID, String[] attchIDs) throws BOSException, EASBizException {
        this.getIBAA().addAssociations(boID, attchIDs);
    }

    public ComplexAttachmentInfoCollection getComplexAttachmentInfoCollectionByBoID(String boID) throws BOSException {
        String oql = "select * where boAttchAsso.boID='" + boID + "'";
        return VariousAttachmentInfoMaker.makeComplexAttachmentInfoCollection(this.getIA(), oql);
    }

    public ComplexAttachmentInfoCollection getComplexAttachmentInfoCollectionByBoID(String boID, ComplexAttachmentInfoSelector cais) throws BOSException {
        String oql = "select " + cais.getInnerSelectedFields() + " where boAttchAsso.boID='" + boID + "'";
        return VariousAttachmentInfoMaker.makeComplexAttachmentInfoCollection(this.getIA(), oql);
    }

    public ComplexAttachmentInfoCollection getComplexAttachmentInfoCollectionByBoBOSType(String bosType) throws BOSException {
        String oql = "select * where boAttchAsso.boID like '%" + bosType + "'";
        return VariousAttachmentInfoMaker.makeComplexAttachmentInfoCollection(this.getIA(), oql);
    }

    public ComplexAttachmentInfoCollection getComplexAttachmentInfoCollectionByBoBOSType(String bosType, ComplexAttachmentInfoSelector cais) throws BOSException {
        String oql = "select " + cais.getInnerSelectedFields() + " where boAttchAsso.boID like '%" + bosType + "'";
        return VariousAttachmentInfoMaker.makeComplexAttachmentInfoCollection(this.getIA(), oql);
    }

    public ComplexAttachmentInfoCollection getComplexAttachmentInfoCollectionByBoBOSTypeAndBeginTime(String bosType, Timestamp beginTime) throws BOSException {
        String oql = "select * where boAttchAsso.boID like '%" + bosType + "' and lastUpdateTime>{" + beginTime.toString() + "}";
        return VariousAttachmentInfoMaker.makeComplexAttachmentInfoCollection(this.getIA(), oql);
    }

    public ComplexAttachmentInfoCollection getComplexAttachmentInfoCollectionByBoBOSTypeAndBeginTime(String bosType, Timestamp beginTime, ComplexAttachmentInfoSelector cais) throws BOSException {
        String oql = "select " + cais.getInnerSelectedFields() + " where boAttchAsso.boID like '%" + bosType + "' and lastUpdateTime>{" + beginTime.toString() + "}";
        return VariousAttachmentInfoMaker.makeComplexAttachmentInfoCollection(this.getIA(), oql);
    }

    public String addNewAttachment(String boID, SimpleAttachmentInfo sai) throws BOSException, EASBizException {
        AttachmentInfo attachmentInfo = VariousAttachmentInfoMaker.makeAttachmentInfo(this.getIA(), boID, sai);
        return this.submitAttachment(attachmentInfo);
    }

    public String addNewAttachment(Context ctx, String boID, SimpleAttachmentInfo sai) throws BOSException, EASBizException {
        AttachmentInfo attachmentInfo = VariousAttachmentInfoMaker.makeAppAttachmentInfo(ctx, this.getIA(), boID, sai);
        return this.submitAttachment(attachmentInfo);
    }

    public String submitAttachment(AttachmentInfo attachmentInfo) throws BOSException, EASBizException {
        String attchID = "";
        byte[] fileInfo = attachmentInfo.getFile();
        String fileUrl = attachmentInfo.getRemotePath();
        attachmentInfo.setRemotePath(null);
        String logName = this.getLogInfo(attachmentInfo.getBoAttchAsso().get(0).getBoID()) + " " + attachmentInfo.getName();
        IObjectPK logPK = LogUtil.beginLog((Context)this.getContext(), (String)"addnew", (BOSObjectType)new AttachmentInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(attachmentInfo.getId()), (String)logName, (String)"bs_attachment_attachment_addnew");
        if (fileInfo != null && fileInfo.length > 0) {
            try {
                IAttachmentSize attachmentFactory = AttachmentSizeFactory.getRemoteInstance();
                boolean isEncrypt = attachmentFactory.isAttachmentEncrypt();
                if (isEncrypt) {
                    fileInfo = AttachmentEncryptUtil.encrypt(fileInfo);
                    attachmentInfo.setIsEncrypt(1);
                    attachmentInfo.setFile(fileInfo);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            AttachmentUploadClient fileUpload;
            if (fileInfo != null && fileInfo.length > 0x500000) {
                this.logger.info((Object)" begin mutl part file upload");
                attachmentInfo.setFile(null);
                attchID = this.getIA().addnew(attachmentInfo).toString();
                fileUpload = new AttachmentUploadClient(this.getIAFF());
                fileUpload.uploadFile(attchID, fileInfo);
            } else if (fileInfo != null && fileInfo.length <= 0x500000) {
                this.logger.info((Object)" begin one part file upload");
                attchID = this.getIA().addnew(attachmentInfo).toString();
            } else if (fileInfo == null && fileUrl != null) {
                this.logger.info((Object)"*****begin large file upload****");
                attachmentInfo.setFile(null);
                attchID = this.getIA().addnew(attachmentInfo).toString();
                fileUpload = new AttachmentUploadClient(this.getIAFF());
                fileUpload.uploadFile(attchID, fileUrl);
            }
        }
        catch (BOSException e) {
            this.getIA().delete((IObjectPK)new ObjectStringPK(attchID));
            this.logger.info((Object)"upload file fail:", (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            this.getIA().delete((IObjectPK)new ObjectStringPK(attchID));
            this.logger.info((Object)"upload file fail:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.getIA().delete((IObjectPK)new ObjectStringPK(attchID));
            this.logger.info((Object)"upload file fail:", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        LogUtil.afterLog((Context)this.getContext(), (IObjectPK)logPK);
        return attchID;
    }

    public String addNewAttachmentContainCtx(Context ctx, String boID, SimpleAttachmentInfo sai) throws BOSException, EASBizException {
        AttachmentInfo attachmentInfo = VariousAttachmentInfoMaker.makeAppAttachmentInfo(ctx, this.getIA(), boID, sai);
        return this.submitAttachment(attachmentInfo, ctx);
    }

    public String submitAttachment(AttachmentInfo attachmentInfo, Context ctx) throws BOSException, EASBizException {
        String attchID = "";
        byte[] fileInfo = attachmentInfo.getFile();
        String fileUrl = attachmentInfo.getRemotePath();
        attachmentInfo.setRemotePath(null);
        String logName = this.getLogInfo(attachmentInfo.getBoAttchAsso().get(0).getBoID()) + " " + attachmentInfo.getName();
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"addnew", (BOSObjectType)new AttachmentInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(attachmentInfo.getId()), (String)logName, (String)"bs_attachment_attachment_addnew");
        try {
            if (fileInfo != null && fileInfo.length > 0x500000) {
                this.logger.info((Object)" begin mutl part file upload");
                attachmentInfo.setFile(null);
                attchID = this.getIA().addnew(attachmentInfo).toString();
                AttachmentUploadClient fileUpload = new AttachmentUploadClient(this.getIAFF());
                fileUpload.setContext(ctx);
                fileUpload.uploadFile(ctx, attchID, fileInfo);
            } else if (fileInfo != null && fileInfo.length <= 0x500000) {
                this.logger.info((Object)" begin one part file upload");
                attchID = this.getIA().addnew(attachmentInfo).toString();
            } else if (fileInfo == null && fileUrl != null) {
                this.logger.info((Object)"*****begin large file upload****");
                attachmentInfo.setFile(null);
                attchID = this.getIA().addnew(attachmentInfo).toString();
                AttachmentUploadClient fileUpload = new AttachmentUploadClient(this.getIAFF());
                fileUpload.setContext(ctx);
                fileUpload.uploadFile(ctx, attchID, fileUrl);
            }
        }
        catch (BOSException e) {
            this.getIA().delete((IObjectPK)new ObjectStringPK(attchID));
            this.logger.error((Object)"upload file fail:", (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            this.getIA().delete((IObjectPK)new ObjectStringPK(attchID));
            this.logger.error((Object)"upload file fail:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.getIA().delete((IObjectPK)new ObjectStringPK(attchID));
            this.logger.error((Object)"upload file fail:", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return attchID;
    }

    public byte[] download(String attachmentId) throws BOSException, EASBizException {
        AttachmentDownloadClient fileDownLoad = new AttachmentDownloadClient(this.getIAFF());
        return fileDownLoad.downLoad2tyte(attachmentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAttachmentContent(String attchID, String fileUrl) throws BOSException, EASBizException {
        File file = new File(fileUrl);
        if (!file.exists()) {
            return;
        }
        StringUtil4File.checkFile(this.getIA(), file.length());
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add(new SelectorItemInfo("id"));
        sic1.add(new SelectorItemInfo("storageType"));
        AttachmentInfo ai = this.getIA().getAttachmentInfo((IObjectPK)new ObjectUuidPK(attchID), sic1);
        ai.setSizeInByte((int)file.length());
        ai.setSize(StringUtil4File.getFileSizeRepresentation(file.length()));
        SelectorItemCollection sic2 = new SelectorItemCollection();
        sic2.add(new SelectorItemInfo("file"));
        sic2.add(new SelectorItemInfo("sizeInByte"));
        sic2.add(new SelectorItemInfo("size"));
        if (file.length() < 0x500000L) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                byte[] content = new byte[(int)file.length()];
                ((InputStream)input).read(content);
                ai.setFile(content);
                this.getIA().updatePartial(ai, sic2);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
            finally {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        this.logger.error((Object)e);
                    }
                }
            }
        } else {
            AttachmentUploadClient auc = new AttachmentUploadClient(this.getIAFF());
            String serverFileId = null;
            serverFileId = StringUtils.equalsIgnoreCase((String)"3", (String)AttachmentHelper.getParam(null)) ? auc.uploadFile4ClientByObs(null, null, fileUrl) : auc.uploadFile4Client(null, null, fileUrl);
            this.getIAFF().updateContent(attchID, serverFileId);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    private String getLogInfo(String boId) {
        String logName = "";
        BOSUuid uuid = BOSUuid.read((String)boId);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(uuid.getType());
        IObjectValue data = null;
        try {
            DataBaseInfo info;
            if (ConfigMDUtil.isClient()) {
                data = DynamicObjectFactory.getRemoteInstance().getValue(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
            } else {
                Context ctx = ConfigMDUtil.getContext();
                data = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
            }
            if (data instanceof DataBaseInfo) {
                info = (DataBaseInfo)data;
                logName = entity.getAlias() + " " + info.getNumber();
            } else if (data instanceof CoreBillBaseInfo) {
                info = (CoreBillBaseInfo)data;
                logName = entity.getAlias() + " " + info.getNumber();
            } else {
                logName = entity.getAlias() + " " + boId;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return logName;
    }
}

