/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.security;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentSizeFactory;
import com.kingdee.eas.base.attachment.IAttachmentSize;
import com.kingdee.eas.base.attachment.security.AbstractObjectInfo;
import com.kingdee.eas.base.attachment.security.ISecurityChecker;
import com.kingdee.eas.base.attachment.security.PlainFileInfo;
import com.kingdee.eas.base.attachment.security.PlainObjectInfo;
import com.kingdee.eas.base.attachment.security.types.PatternInfoType;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;

public abstract class AbstractPatternInfo
extends AbstractObjectInfo
implements ISecurityChecker {
    Logger logger = Logger.getLogger(this.getClass());
    private String contentType;
    protected PlainFileInfo plainInfo;
    private boolean isEnableWhiteList;
    protected Map<String, String> patterns = new HashMap<String, String>();

    public AbstractPatternInfo(String name) {
        super(name);
    }

    public AbstractPatternInfo(PlainFileInfo plainInfo, String name) {
        this(name);
        this.plainInfo = plainInfo;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    protected boolean checkName() {
        String patternString;
        String _prefix;
        boolean success = this.plainInfo.getSuffix().equalsIgnoreCase(this.getSuffix());
        if (!success) {
            return false;
        }
        String plainPrefix = this.plainInfo.getPrefix();
        String regex = _prefix = this.getPrefix();
        if (_prefix.trim().startsWith("*") && _prefix.trim().endsWith("*") || _prefix.trim().equals("*")) {
            regex = ".*";
        } else if (_prefix.trim().startsWith("*")) {
            patternString = this._getStringBy('*');
            if (patternString.contains("*")) {
                patternString = patternString.replaceAll("\\*", ".*");
                regex = ".*" + patternString + "$";
            } else {
                regex = ".*" + this._getStringBy('*') + "$";
            }
        } else if (_prefix.trim().endsWith("*")) {
            patternString = this._getStringReverseBy('*');
            if (patternString.contains("*")) {
                patternString = patternString.replaceAll("\\*", ".*");
                regex = "^" + patternString + ".*";
            } else {
                regex = "^" + this._getStringReverseBy('*') + ".*";
            }
        }
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(plainPrefix);
        return success && matcher.matches();
    }

    protected abstract boolean checkContentAndExtention();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check() throws AttachmentException {
        this.requireNonNull(this.plainInfo);
        boolean checkSuccess = this.checkName();
        String compress = null;
        try {
            compress = ParamManager.getParamValue(null, null, (String)"AttachmentContentCheck");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        if (this.isEnableWhiteList && !checkSuccess) {
            throw new AttachmentException(AttachmentException.WHITELISTNOTALLOWEDFORNAME, new Object[]{this.plainInfo.getName()});
        }
        if (this.isEnableWhiteList && checkSuccess) {
            if (StringUtil.isEmpty((String)compress) || "true".equals(compress)) {
                checkSuccess = this.checkContentAndExtention();
            }
            if (checkSuccess) return;
            if (!"JPEG".equalsIgnoreCase(this.plainInfo.getSuffix()) && !"JPG".equalsIgnoreCase(this.plainInfo.getSuffix()) && !"PNG".equalsIgnoreCase(this.plainInfo.getSuffix()) && !"GIF".equalsIgnoreCase(this.plainInfo.getSuffix()) && !"BMP".equalsIgnoreCase(this.plainInfo.getSuffix())) throw new AttachmentException(AttachmentException.WHITELISTCONTENTEXTNOTMATCH, new Object[]{this.plainInfo.getName()});
            if (this.checkAgainWhiteList()) return;
            throw new AttachmentException(AttachmentException.WHITELISTCONTENTEXTNOTMATCH, new Object[]{this.plainInfo.getName()});
        }
        if (!this.isEnableWhiteList && checkSuccess) {
            throw new AttachmentException(AttachmentException.BLACKLISTNOTALLOWFORNAME, new Object[]{this.plainInfo.getName()});
        }
        if (StringUtil.isEmpty((String)compress) || "true".equals(compress)) {
            checkSuccess = this.checkContentAndExtention();
        }
        if (!("JPEG".equalsIgnoreCase(this.plainInfo.getSuffix()) || "JPG".equalsIgnoreCase(this.plainInfo.getSuffix()) || "PNG".equalsIgnoreCase(this.plainInfo.getSuffix()) || "GIF".equalsIgnoreCase(this.plainInfo.getSuffix()) || "BMP".equalsIgnoreCase(this.plainInfo.getSuffix()) ? this.checkAgainBlackList() : !checkSuccess)) return;
        throw new AttachmentException(AttachmentException.BLACKLISTCONTENTEXTMACH, new Object[]{this.plainInfo.getName()});
    }

    public boolean checkAgainWhiteList() {
        try {
            String[] patterns;
            IAttachmentSize attachmentFactory = AttachmentSizeFactory.getRemoteInstance();
            String writeList = attachmentFactory.getWhiteList();
            String contentType = this.contentType;
            for (String item : patterns = StringUtil4File.decodeStringBy(writeList, ";")) {
                if (contentType.indexOf(item.substring(item.lastIndexOf(".") + 1, item.length()).toLowerCase()) <= 0) continue;
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean checkAgainBlackList() {
        try {
            String[] patterns;
            IAttachmentSize attachmentFactory = AttachmentSizeFactory.getRemoteInstance();
            String blackList = attachmentFactory.getBlackList();
            String contentType = this.contentType;
            for (String item : patterns = StringUtil4File.decodeStringBy(blackList, ";")) {
                if (contentType.indexOf(item.substring(item.lastIndexOf(".") + 1, item.length()).toLowerCase()) <= 0) continue;
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlainObjectInfo analyze() {
        PlainObjectInfo result = new PlainObjectInfo(this.getName());
        InputStream in = null;
        try {
            this.logger.error((Object)("\u5f53\u524d\u6821\u9a8c\uff1a" + this.getName()));
            BodyContentHandler contentHandler = new BodyContentHandler(-1);
            Metadata metadata = new Metadata();
            if (!"zip".equals(this.plainInfo.getSuffix())) {
                in = this.plainInfo.getFileStream();
                AutoDetectParser parser = new AutoDetectParser();
                parser.parse(in, (ContentHandler)contentHandler, metadata);
            }
            result.setContentType(metadata.get("Content-Type"));
            result.setTitle(metadata.get("title"));
            result.setAuthor(metadata.get("Author"));
            this.logger.error((Object)("\u6821\u9a8cMime:" + result.getContentType()));
        }
        catch (Exception e) {
            this.logger.error((Object)"\u89e3\u6790\u6587\u4ef6\u7c7b\u578b\u51fa\u9519:", (Throwable)e);
            result.setContentType(PatternInfoType.UNKNOWN.getMimeType());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMagicCode(InputStream is) {
        byte[] b = new byte[3];
        try {
            is.read(b, 0, b.length);
        }
        catch (IOException e1) {
            this.logger.error((Object)e1);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)e);
                }
            }
        }
        StringBuilder magicCode = new StringBuilder();
        if (null == b || b.length <= 0) {
            return null;
        }
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                magicCode.append(0);
            }
            magicCode.append(hv);
        }
        this.logger.error((Object)("\u5f53\u524d\u6821\u9a8c \uff1a" + this.getName() + " \u9b54\u6570 :  " + magicCode.toString()));
        return magicCode.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlainObjectInfo analyze2() {
        InputStream in = this.plainInfo.getFileStream();
        PlainObjectInfo result = new PlainObjectInfo(this.getName());
        result.setMagicCode(this.getMagicCode(in));
        try {
            this.logger.error((Object)("\u5f53\u524d\u6821\u9a8c\uff1a" + this.getName()));
            BodyContentHandler contentHandler = new BodyContentHandler(-1);
            Metadata metadata = new Metadata();
            AutoDetectParser parser = new AutoDetectParser();
            parser.parse(in, (ContentHandler)contentHandler, metadata);
            result.setContentType(metadata.get("Content-Type"));
            result.setTitle(metadata.get("title"));
            result.setAuthor(metadata.get("Author"));
            this.logger.error((Object)("\u6821\u9a8cMime:" + result.getContentType()));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            result.setContentType(PatternInfoType.UNKNOWN.getMimeType());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public PlainFileInfo getPlainInfo() {
        return this.plainInfo;
    }

    public void setPlainInfo(PlainFileInfo plainInfo) {
        this.plainInfo = plainInfo;
    }

    public boolean isEnableWhiteList() {
        return this.isEnableWhiteList;
    }

    public void setEnableWhiteList(boolean isEnableWhiteList) {
        this.isEnableWhiteList = isEnableWhiteList;
    }

    private String _getStringBy(char sparator) {
        char[] chars = this.getPrefix().toCharArray();
        StringBuilder sb = new StringBuilder();
        char lastCh = sparator;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch == lastCh && ch == sparator || ch == lastCh) continue;
            sb.append(ch);
            lastCh = ch;
        }
        return sb.toString();
    }

    private String _getStringReverseBy(char sparator) {
        char[] chars = this.getPrefix().toCharArray();
        StringBuilder sb = new StringBuilder();
        char lastCh = sparator;
        for (int i = chars.length - 1; i >= 0; --i) {
            char ch = chars[i];
            if (ch == lastCh && ch == sparator || ch == lastCh) continue;
            sb.insert(0, ch);
            lastCh = ch;
        }
        return sb.toString();
    }
}

