/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.security;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentSizeFactory;
import com.kingdee.eas.base.attachment.IAttachmentSecurity;
import com.kingdee.eas.base.attachment.IAttachmentSize;
import com.kingdee.eas.base.attachment.security.AbstractPatternInfo;
import com.kingdee.eas.base.attachment.security.AttachmentSecurityHelper;
import com.kingdee.eas.base.attachment.security.PlainFileInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;

public class AttachmentSecurityImpl
implements IAttachmentSecurity {
    private String writeList;
    private String blackList;
    private boolean isEnableWriteList;
    private PlainFileInfo plainInfo;
    private static Map<String, Map<String, String>> cacheMap;
    private static Map<String, String> countAndTimeMap;
    private static int uploadCount;
    private static int uploadTime;
    private static int timeOut;
    Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.attachment.security.AttachmentSecurityImpl");

    @Override
    public void check(PlainFileInfo plainInfo) throws AttachmentException {
        this.checkZipOrXslSecurity(plainInfo);
        this.checkUploadCount();
        this.plainInfo = plainInfo;
        boolean anyWhiteListMached = false;
        boolean moreThanOneBlackListMached = false;
        if (this.isEnableWriteList) {
            List<AbstractPatternInfo> patterns = AttachmentSecurityHelper.getPatterns(this.plainInfo, this.writeList);
            Iterator<AbstractPatternInfo> iterator = patterns.iterator();
            if (iterator.hasNext()) {
                AbstractPatternInfo item = iterator.next();
                item.setEnableWhiteList(true);
                try {
                    item.check();
                    anyWhiteListMached = true;
                }
                catch (AttachmentException ex) {
                    this.logger.error((Object)"\u5f53\u524d\u9644\u4ef6\u6821\u9a8c\u7ed3\u679c\uff1a", (Throwable)((Object)ex));
                    throw ex;
                }
            }
            if (!anyWhiteListMached) {
                throw new AttachmentException(AttachmentException.WHITELISTNOTALLOWEDFORNAME, new Object[]{this.plainInfo.getName()});
            }
        } else {
            if (StringUtils.isEmpty((String)this.blackList)) {
                this.logger.error((Object)"\u7528\u6237\u542f\u7528\u9ed1\u540d\u5355\uff0c\u4f46\u662f\u9ed1\u540d\u5355\u4e3a\u7a7a\uff0c\u5141\u8bb8\u4e0a\u4f20\uff01");
                return;
            }
            List<AbstractPatternInfo> patterns = AttachmentSecurityHelper.getPatternsIncludingSelf(this.plainInfo, this.blackList);
            for (AbstractPatternInfo item : patterns) {
                item.setEnableWhiteList(false);
                try {
                    item.check();
                }
                catch (AttachmentException ex) {
                    moreThanOneBlackListMached = true;
                    this.logger.error((Object)"\u5f53\u524d\u9644\u4ef6\u6821\u9a8c\u7ed3\u679c\uff1a", (Throwable)((Object)ex));
                    throw ex;
                }
            }
            if (moreThanOneBlackListMached) {
                throw new AttachmentException(AttachmentException.BLACKLISTNOTALLOWFORNAME, new Object[]{this.plainInfo.getName()});
            }
        }
    }

    private void checkZipOrXslSecurity(PlainFileInfo plainInfo) throws AttachmentException {
        if (plainInfo != null) {
            String name = plainInfo.getName();
            String extendedFileName = null;
            if (!StringUtils.isEmpty((String)name) && name.contains(".")) {
                String[] nameList = name.split("\\.");
                extendedFileName = nameList[nameList.length - 1];
            }
            String compress = null;
            try {
                compress = ParamManager.getParamValue(null, null, (String)"AttachmentCheckExcelCSV");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            if ("true".equals(compress) && ("xlsx".equalsIgnoreCase(extendedFileName) || "xls".equalsIgnoreCase(extendedFileName))) {
                try {
                    this.checkExcelCSV(plainInfo.getName(), plainInfo.getFileStream());
                }
                catch (AttachmentException e) {
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ("pdf".equalsIgnoreCase(extendedFileName)) {
                this.checkPDFSecurity(plainInfo.getName(), plainInfo.getFileStream());
            }
            boolean isZIPBomb = true;
            try {
                isZIPBomb = AttachmentSecurityImpl.checkZipBomb(extendedFileName, plainInfo.getFileStream(), 30);
            }
            catch (IOException e) {
                e.printStackTrace();
                isZIPBomb = true;
            }
            if (!isZIPBomb) {
                throw new AttachmentException(AttachmentException.ZIPFILESIZETOLARGE);
            }
        }
    }

    public static boolean checkZipBomb(String fileType, InputStream ins, int maxDepth) throws IOException {
        if ("zip".equalsIgnoreCase(fileType)) {
            long size = 0L;
            int currentDepth = 0;
            ZipEntry zipEntry = null;
            BufferedInputStream in = new BufferedInputStream(ins);
            ZipInputStream zin = new ZipInputStream((InputStream)in, Charset.forName("GBK"));
            Stack<ZipEntry> entryStack = new Stack<ZipEntry>();
            while ((zipEntry = zin.getNextEntry()) != null) {
                if (!zipEntry.isDirectory()) {
                    size += zipEntry.getSize();
                } else {
                    if (currentDepth >= maxDepth) {
                        return false;
                    }
                    ++currentDepth;
                    entryStack.push(zipEntry);
                }
                while (!entryStack.isEmpty() && !zipEntry.getName().startsWith(((ZipEntry)entryStack.peek()).getName())) {
                    entryStack.pop();
                    --currentDepth;
                }
            }
            if (size > 524288000L) {
                return false;
            }
        }
        return true;
    }

    private void checkPDFSecurity(String fileName, InputStream fileStream) throws AttachmentException {
        PDDocument document = null;
        try {
            document = PDDocument.load((InputStream)fileStream);
            int count = 0;
            if (document != null) {
                count = document.getNumberOfPages();
                for (int i = 0; i < count; ++i) {
                    if (document.getPage(i) == null || document.getPage(i).getActions() == null || document.getPage(i).getActions().getCOSObject() == null) continue;
                    for (COSName cosName : document.getPage(i).getActions().getCOSObject().keySet()) {
                        String str;
                        if (document.getPage(i).getActions().getCOSObject().getCOSDictionary(cosName) == null || document.getPage(i).getActions().getCOSObject().getCOSDictionary(cosName).getItem(COSName.JS) == null || !AttachmentSecurityImpl.checkPathParamXSS(str = document.getPage(i).getActions().getCOSObject().getCOSDictionary(cosName).getItem(COSName.JS).toString())) continue;
                        throw new AttachmentException(AttachmentException.ATTACHMENTNOTALLOWED, new Object[]{fileName});
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (AttachmentException e1) {
            throw e1;
        }
    }

    public static boolean checkPathParamXSS(String param) {
        String[] dangerCharacters;
        if (StringUtils.isEmpty((String)param)) {
            return false;
        }
        for (String s : dangerCharacters = new String[]{"<", ">", "\\|", "\\./", "\\.\\./", "javascript", "document", "eval", "onblur", "onclick", "script", "alert", "iframe", "confirm"}) {
            if (!param.contains(s)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkUploadCount() throws AttachmentException {
        Context ctx = ConfigMDUtil.getContext();
        String userId = ctx.getCaller().toString();
        if (cacheMap == null) {
            cacheMap = new HashMap<String, Map<String, String>>();
        }
        if (countAndTimeMap == null) {
            countAndTimeMap = new HashMap<String, String>();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowTime = sdf.format(new Date());
        String compress = null;
        try {
            compress = ParamManager.getParamValue(null, null, (String)"AttachmentLimitCount");
            if (!StringUtils.isEmpty((String)compress)) {
                uploadCount = Integer.parseInt(compress);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        if (cacheMap.get(userId) == null) {
            countAndTimeMap.put("count", String.valueOf(1));
            countAndTimeMap.put("firstTime", nowTime);
            cacheMap.put(userId, countAndTimeMap);
            return;
        }
        int count = Integer.parseInt(countAndTimeMap.get("count"));
        if (count != uploadCount) {
            countAndTimeMap.put("count", String.valueOf(++count));
            countAndTimeMap.put("lastTime", nowTime);
            cacheMap.put(userId, countAndTimeMap);
            return;
        }
        String firstTime = countAndTimeMap.get("firstTime");
        String lastTime = countAndTimeMap.get("lastTime");
        if (!this.checkTimeOut(nowTime, firstTime, uploadTime) && !this.checkTimeOut(nowTime, lastTime, timeOut)) {
            this.logger.error((Object)"\u5341\u5206\u949f\u5185\uff0c\u540c\u4e00\u7528\u6237\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u8d85\u8fc7100\u4e2a");
            throw new AttachmentException(AttachmentException.ATTACHMENTCOUNT, new Object[]{"\u5341", "100"});
        }
        cacheMap = new HashMap<String, Map<String, String>>();
        countAndTimeMap = new HashMap<String, String>();
        countAndTimeMap.put("count", String.valueOf(1));
        countAndTimeMap.put("firstTime", nowTime);
        cacheMap.put(userId, countAndTimeMap);
    }

    private boolean checkTimeOut(String nowTime, String tempTime, int compareTime) {
        boolean isTimeOut = false;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date start = sdf.parse(tempTime);
            Date end = sdf.parse(nowTime);
            long cha = end.getTime() - start.getTime();
            if (cha > (long)compareTime) {
                isTimeOut = true;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return isTimeOut;
    }

    public AttachmentSecurityImpl() throws BOSException, AttachmentException {
        IAttachmentSize attachmentFactory = AttachmentSizeFactory.getRemoteInstance();
        this.writeList = attachmentFactory.getWhiteList();
        this.blackList = attachmentFactory.getBlackList();
        this.isEnableWriteList = attachmentFactory.IsEnableWhiteList();
        AttachmentSecurityHelper.registerSupportFiles();
    }

    private void saveException(Stack<Exception> exceptions) {
        if (exceptions != null) {
            while (!exceptions.isEmpty()) {
                Exception e = exceptions.pop();
                this.logger.error((Object)"\u5f53\u524d\u9644\u4ef6\u6821\u9a8c\u7ed3\u679c\uff1a", (Throwable)e);
            }
        }
    }

    public String getWriteList() {
        return this.writeList;
    }

    public String getBlackList() {
        return this.blackList;
    }

    public boolean isEnableWriteList() {
        return this.isEnableWriteList;
    }

    public void setWriteList(String writeList) {
        this.writeList = writeList;
    }

    public void setBlackList(String blackList) {
        this.blackList = blackList;
    }

    public void setEnableWriteList(boolean isEnableWriteList) {
        this.isEnableWriteList = isEnableWriteList;
    }

    public void setPlainInfo(PlainFileInfo plainInfo) {
        this.plainInfo = plainInfo;
    }

    public void checkExcelCSV(String fileName, InputStream in) throws AttachmentException {
        ExcelListener excelListener = new ExcelListener();
        ((ExcelReaderBuilder)EasyExcel.read((InputStream)in, (ReadListener)excelListener).headRowNumber(Integer.valueOf(0))).doReadAll();
        if (ExcelListener.checkStatus) {
            throw new AttachmentException(AttachmentException.ATTACHMENTNOTALLOWED, new Object[]{fileName});
        }
    }

    static {
        uploadCount = 100;
        uploadTime = 600000;
        timeOut = 300000;
    }

    static class ExcelListener
    extends AnalysisEventListener<Map<Integer, ReadCellData<?>>> {
        private int count = 0;
        private static boolean checkStatus = false;
        private static String CSV = ".*(cmd|HYPERLIN|\\+1\\[1\\]|1\\+\\[1\\]|\\[1\\]!z).*";
        private Pattern pattern = Pattern.compile(CSV);

        ExcelListener() {
        }

        public void invoke(Map<Integer, ReadCellData<?>> rowData, AnalysisContext context) {
            checkStatus = false;
            if (context != null && context.readRowHolder() != null) {
                Map cellMap = context.readRowHolder().getCellMap();
                for (Integer i : cellMap.keySet()) {
                    ReadCellData temp = (ReadCellData)cellMap.get(i);
                    if (checkStatus || temp == null) continue;
                    String formulaValue = "";
                    formulaValue = temp.getFormulaData() != null ? temp.getFormulaData().getFormulaValue() : temp.getStringValue();
                    if (!this.isVaildCSV(formulaValue)) continue;
                    checkStatus = true;
                    System.out.println("\u5f53\u524d\u8fd9\u4e2a\u5355\u5143\u683c\u5185\u5bb9\u5b58\u5728CSV\u6f0f\u6d1e\u98ce\u9669\uff1a" + formulaValue);
                }
            }
            ++this.count;
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }

        private boolean isVaildCSV(String cellString) {
            if (StringUtils.isEmpty((String)cellString)) {
                return false;
            }
            Matcher matcher = this.pattern.matcher(cellString);
            return matcher.find();
        }
    }
}

