/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.attachment.AllUsersAttachmentViewFactory;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentHandleFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentPermissionCollection;
import com.kingdee.eas.base.attachment.AttachmentPermissionFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachmentPermission;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.util.AttachmentEnum;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class AttachmentSelectUtils {
    private static Logger logger = Logger.getLogger(AttachmentSelectUtils.class);
    private static AttachmentSelectUtils asu = null;

    private AttachmentSelectUtils() {
    }

    public static AttachmentSelectUtils init() {
        if (asu == null) {
            asu = new AttachmentSelectUtils();
        }
        return asu;
    }

    public FilterInfo getFilterInfo(Context ctx) {
        FilterInfo fInfo = new FilterInfo();
        try {
            String orgID;
            String perID = null;
            String userID = null;
            if (ctx == null) {
                userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                perID = AttachmentHandleFacadeFactory.getRemoteInstance().getATPermission(userID, orgID);
            } else {
                userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                orgID = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
                perID = AttachmentHandleFacadeFactory.getLocalInstance(ctx).getATPermission(userID, orgID);
            }
            FilterItemCollection ficAll = fInfo.getFilterItems();
            ficAll.add(new FilterItemInfo("permission", (Object)perID, CompareType.INCLUDE));
            ficAll.add(new FilterItemInfo("permission", null, CompareType.IS));
            ficAll.add(new FilterItemInfo("creator.id", (Object)userID, CompareType.EQUALS));
            fInfo.setMaskString("#0 or #1 or #2");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return fInfo;
    }

    public FilterInfo getFilterInfoForType(Context ctx) {
        FilterInfo fInfo = new FilterInfo();
        try {
            String orgID;
            String perID = null;
            String userID = null;
            if (ctx == null) {
                userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                perID = AttachmentHandleFacadeFactory.getRemoteInstance().getATPermission(userID, orgID);
            } else {
                userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                orgID = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
                perID = AttachmentHandleFacadeFactory.getLocalInstance(ctx).getATPermission(userID, orgID);
            }
            FilterItemCollection ficAll = fInfo.getFilterItems();
            ficAll.add(new FilterItemInfo("permission", (Object)perID, CompareType.INCLUDE));
            ficAll.add(new FilterItemInfo("permission", null, CompareType.IS));
            ficAll.add(new FilterItemInfo("creator.id", (Object)userID, CompareType.EQUALS));
            fInfo.setMaskString("#0 or #2");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return fInfo;
    }

    public FilterInfo getFilterInfo4AllUsersATView(Context ctx) {
        String[] usersIds = null;
        try {
            usersIds = ctx == null ? AllUsersAttachmentViewFactory.getRemoteInstance().allUsersAttachViewForUsersIds() : AllUsersAttachmentViewFactory.getLocalInstance(ctx).allUsersAttachViewForUsersIds();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (usersIds.length == 0) {
            FilterInfo fInfo = new FilterInfo();
            try {
                String orgID;
                String perID = null;
                String userID = null;
                if (ctx == null) {
                    userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                    orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                    perID = AttachmentHandleFacadeFactory.getRemoteInstance().getATPermission(userID, orgID);
                } else {
                    userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                    orgID = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
                    perID = AttachmentHandleFacadeFactory.getLocalInstance(ctx).getATPermission(userID, orgID);
                }
                FilterItemCollection ficAll = fInfo.getFilterItems();
                ficAll.add(new FilterItemInfo("permission", (Object)perID, CompareType.INCLUDE));
                ficAll.add(new FilterItemInfo("permission", null, CompareType.IS));
                ficAll.add(new FilterItemInfo("creator.id", (Object)userID, CompareType.EQUALS));
                fInfo.setMaskString("#0 or #2");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return fInfo;
        }
        boolean isCanViewAllUsersAT = false;
        String perID = null;
        String userID = null;
        userID = ctx == null ? SysContext.getSysContext().getCurrentUserInfo().getId().toString() : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        for (String userId : usersIds) {
            if (!userID.equals(userId)) continue;
            isCanViewAllUsersAT = true;
        }
        FilterInfo fInfo = new FilterInfo();
        if (isCanViewAllUsersAT) {
            try {
                String orgID;
                if (ctx == null) {
                    orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                    perID = AttachmentHandleFacadeFactory.getRemoteInstance().getATPermission(userID, orgID);
                } else {
                    orgID = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
                    perID = AttachmentHandleFacadeFactory.getLocalInstance(ctx).getATPermission(userID, orgID);
                }
                FilterItemCollection ficAll = fInfo.getFilterItems();
                ficAll.add(new FilterItemInfo("permission", (Object)perID, CompareType.INCLUDE));
                ficAll.add(new FilterItemInfo("permission", null, CompareType.IS));
                ficAll.add(new FilterItemInfo("creator.id", null, CompareType.ISNOT));
                fInfo.setMaskString("#0 or #2");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return fInfo;
        }
        try {
            String orgID;
            if (ctx == null) {
                orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                perID = AttachmentHandleFacadeFactory.getRemoteInstance().getATPermission(userID, orgID);
            } else {
                orgID = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
                perID = AttachmentHandleFacadeFactory.getLocalInstance(ctx).getATPermission(userID, orgID);
            }
            FilterItemCollection ficAll = fInfo.getFilterItems();
            ficAll.add(new FilterItemInfo("permission", (Object)perID, CompareType.INCLUDE));
            ficAll.add(new FilterItemInfo("permission", null, CompareType.IS));
            ficAll.add(new FilterItemInfo("creator.id", (Object)userID, CompareType.EQUALS));
            fInfo.setMaskString("#0 or #2");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return fInfo;
    }

    public AttachmentPermissionCollection getItem(Object ob) throws Exception {
        return this.getItem(null, ob, null);
    }

    public AttachmentPermissionCollection getItem(Context context, Object ob) throws Exception {
        return this.getItem(context, ob, null);
    }

    public AttachmentPermissionCollection getItem(Object ob, String boAttachId) throws Exception {
        return this.getItem(null, ob, boAttachId);
    }

    public AttachmentPermissionCollection getItem(Context context, Object ob, String boAttachId) throws Exception {
        AttachmentInfo ai = null;
        if (ob instanceof AttachmentInfo) {
            ai = (AttachmentInfo)ob;
        } else if (ob instanceof AttachmentCollection) {
            ai = ((AttachmentCollection)((Object)ob)).get(0);
        }
        BoAttchAssoInfo baInfo = null;
        IBoAttchAsso iboaa = null;
        IAttachmentPermission iap = null;
        String cuid = "";
        if (context == null) {
            iboaa = BoAttchAssoFactory.getRemoteInstance();
            iap = AttachmentPermissionFactory.getRemoteInstance();
            cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        } else {
            iboaa = BoAttchAssoFactory.getLocalInstance(context);
            iap = AttachmentPermissionFactory.getLocalInstance(context);
            cuid = ContextUtil.getCurrentCtrlUnit((Context)context).getId().toString();
        }
        try {
            if (!StringUtils.isEmpty((String)boAttachId)) {
                baInfo = iboaa.getBoAttchAssoInfo((IObjectPK)new ObjectStringPK(boAttachId));
            } else if (ai != null && !StringUtils.isEmpty((String)ai.getId().toString())) {
                baInfo = iboaa.getBoAttchAssoInfo("select * where attachment = '" + ai.getId().toString() + "' and assoType = '" + AttachmentEnum.ADD_NEW_ATTACHMENT_VALUE + "'");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        AttachmentPermissionCollection attachmentcol = null;
        if (context == null && baInfo != null) {
            attachmentcol = iap.getAttachmentPermissionCollection("select * where simpleName = '" + baInfo.getAssoBusObjType() + "' and cu.id = '" + SysContext.getSysContext().getCurrentCtrlUnit().getId().toString() + "'");
        } else if (baInfo != null) {
            attachmentcol = iap.getAttachmentPermissionCollection("select * where simpleName = '" + baInfo.getAssoBusObjType() + "' and cu.id = '" + ContextUtil.getCurrentCtrlUnit((Context)context).getId().toString() + "'");
        }
        if (baInfo != null) {
            attachmentcol = this.addUpCuType(context, attachmentcol, cuid, baInfo.getAssoBusObjType());
        }
        return attachmentcol;
    }

    private AttachmentPermissionCollection addUpCuType(Context context, AttachmentPermissionCollection attachmentcol, String cuid, String bostype) throws BOSException, EASBizException {
        ICtrlUnit icu = null;
        IAttachmentPermission iap = null;
        if (context == null) {
            icu = CtrlUnitFactory.getRemoteInstance();
            iap = AttachmentPermissionFactory.getRemoteInstance();
        } else {
            icu = CtrlUnitFactory.getRemoteInstance();
            iap = AttachmentPermissionFactory.getLocalInstance(context);
        }
        CtrlUnitInfo cu = icu.getCtrlUnitInfo((IObjectPK)new ObjectStringPK(cuid));
        CtrlUnitInfo parentCu = null;
        if (cu != null) {
            parentCu = cu.getParent();
        }
        if (parentCu == null || parentCu.getId() == null || parentCu.getId() == cu.getId()) {
            return attachmentcol;
        }
        AttachmentPermissionCollection parattachmentcol = null;
        parattachmentcol = iap.getAttachmentPermissionCollection("select * where simpleName = '" + bostype + "' and cu.id = '" + parentCu.getId().toString() + "' and isShare = '1'");
        if (parattachmentcol != null && parattachmentcol.size() > 0) {
            attachmentcol.addCollection(parattachmentcol);
        }
        attachmentcol = this.addUpCuType(context, attachmentcol, parentCu.getId().toString(), bostype);
        return attachmentcol;
    }
}

