/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentSizeFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentSize;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;

public class StringUtil4File {
    public static final long FILE_BYTES_LIMIT_SINGLE = 0x3200000L;
    public static final long FILE_BYTES_LIMIT_ALL = 524288000L;

    public static int roundDown(double v) {
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, 0, 1).intValue();
    }

    public static String getFileSizeRepresentation(long size) {
        int twodigit;
        int point;
        long lengthInB = size;
        String lengthInStr = lengthInB + "";
        String postfix = Resrcs.getString("Byte");
        if (lengthInB >= 1024L) {
            lengthInStr = (lengthInB /= 1024L) + "";
            postfix = " KB";
            if (lengthInB >= 1024L) {
                lengthInStr = lengthInB / 1024L + "";
                postfix = " MB";
            }
        }
        if ((point = lengthInStr.indexOf(46)) != -1 && (twodigit = point + 3) <= lengthInStr.length() - 1) {
            lengthInStr = lengthInStr.substring(0, twodigit);
        }
        return lengthInStr + postfix;
    }

    public static String getFileSizeRepresentation(long size, Context ctx) {
        int twodigit;
        int point;
        long lengthInB = size;
        String lengthInStr = lengthInB + "";
        String postfix = Resrcs.getString("Byte", ctx.getLocale());
        if (lengthInB >= 1024L) {
            lengthInStr = (lengthInB /= 1024L) + "";
            postfix = " KB";
            if (lengthInB >= 1024L) {
                lengthInStr = lengthInB / 1024L + "";
                postfix = " MB";
            }
        }
        if ((point = lengthInStr.indexOf(46)) != -1 && (twodigit = point + 3) <= lengthInStr.length() - 1) {
            lengthInStr = lengthInStr.substring(0, twodigit);
        }
        return lengthInStr + postfix;
    }

    public static String getMainFileName(String fullname) {
        int lp = fullname.lastIndexOf(".");
        if (lp == -1) {
            return fullname;
        }
        return fullname.substring(0, lp);
    }

    public static String getExtendedFileName(String fullname) {
        int lp = fullname.lastIndexOf(".");
        if (lp == -1) {
            return "";
        }
        return fullname.substring(lp + 1);
    }

    public static String getExtFileName(IAttachment ia, String attchID) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("simpleName"));
        return ia.getValue((IObjectPK)new ObjectUuidPK(attchID), sic).get("simpleName").toString();
    }

    public static String getFileTypeDescription(String extname) {
        String typedesc = Resrcs.getTypeString(extname);
        if (typedesc == null || typedesc == "" || typedesc.equals("Missing Resource")) {
            typedesc = MessageFormat.format(Resrcs.getString("UnknownType"), "." + extname);
        }
        return typedesc;
    }

    public static String getFileTypeDescription(String extname, Context ctx) {
        String typedesc = Resrcs.getTypeString(extname, ctx.getLocale());
        if (typedesc == null || typedesc == "" || typedesc.equals("Missing Resource")) {
            typedesc = MessageFormat.format(Resrcs.getString("UnknownType", ctx.getLocale()), "." + extname);
        }
        return typedesc;
    }

    public static void checkInvalidCharsInFileName(String filename) throws AttachmentException {
        String[] invalidChars = new String[]{"/", "\\", "*", "\"", "?", ":", "<", ">", "|", "!"};
        boolean isValid = true;
        StringBuffer errmsgOfInvalidChars = new StringBuffer("");
        for (String aInvalidChar : invalidChars) {
            if (filename.indexOf(aInvalidChar) == -1) continue;
            isValid = false;
            errmsgOfInvalidChars.append(" " + aInvalidChar);
        }
        if (!isValid) {
            errmsgOfInvalidChars.append(" ");
            throw new AttachmentException(AttachmentException.FILENAMEHASINVALIDCHARS, new String[]{filename, errmsgOfInvalidChars.toString()});
        }
    }

    public static String makeFileNameFromURL(String url) {
        StringBuffer sb = new StringBuffer();
        sb.append("\\.");
        sb.append("\\s");
        sb.append("\\/");
        sb.append("\\\\");
        sb.append("\\*");
        sb.append("\"");
        sb.append("'");
        sb.append("\\?");
        sb.append(":");
        sb.append("\\<");
        sb.append("\\>");
        sb.append("\\|");
        sb.append("\\!");
        sb.append("@");
        sb.append("#");
        sb.append("\\$");
        sb.append("%");
        sb.append("\\^");
        sb.append("&");
        sb.append(",");
        sb.append("`");
        String ptn = "[" + sb.toString() + "]";
        return url.replaceAll(ptn, "_");
    }

    public static void checkFile(IAttachment ia, String boID, SimpleAttachmentInfo sai, byte[] content) throws BOSException, AttachmentException, EASBizException {
        String mainname = sai.getMainName();
        if (mainname == null || mainname.equals("")) {
            throw new AttachmentException(AttachmentException.FILENAMEISEMPTY);
        }
        StringUtil4File.checkInvalidCharsInFileName(mainname);
        IAttachmentSize attachmentFactory = StringUtil4File.getAttachmentInstance(null);
        double attSize = attachmentFactory.getFileSize();
        sai.checkFileSize(attSize);
        if (ia.isFileNameExisted(boID, mainname)) {
            throw new AttachmentException(AttachmentException.FILENAMEEXISTED, new String[]{mainname});
        }
    }

    public static void checkFile(Context ctx, IAttachment ia, String boID, SimpleAttachmentInfo sai, byte[] content) throws BOSException, AttachmentException, EASBizException {
        String mainname = sai.getMainName();
        String extname = sai.getExtName();
        if (mainname == null || mainname.equals("")) {
            throw new AttachmentException(AttachmentException.FILENAMEISEMPTY);
        }
        StringUtil4File.checkInvalidCharsInFileName(mainname);
        IAttachmentSize attachmentFactory = StringUtil4File.getAttachmentInstance(ctx);
        double attSize = attachmentFactory.getFileSize();
        String fileTypes = attachmentFactory.getFileType();
        if (fileTypes != null) {
            String[] ftype = fileTypes.split(";");
            for (int i = 0; i < ftype.length; ++i) {
                if (ftype[i] == null || !extname.equalsIgnoreCase(ftype[i])) continue;
                throw new AttachmentException(AttachmentException.FILETYPENOTALLOWED, new String[]{String.valueOf(ftype[i])});
            }
        }
        sai.checkFileSize(attSize);
        if (ia.isFileNameExisted(boID, mainname)) {
            throw new AttachmentException(AttachmentException.FILENAMEEXISTED, new String[]{mainname});
        }
    }

    public static void checkFile(IAttachment ia, String boID, String mainname) throws BOSException, AttachmentException {
        if (mainname == null || mainname.equals("")) {
            throw new AttachmentException(AttachmentException.FILENAMEISEMPTY);
        }
        StringUtil4File.checkInvalidCharsInFileName(mainname);
        if (ia.isFileNameExisted(boID, mainname)) {
            throw new AttachmentException(AttachmentException.FILENAMEEXISTED, new String[]{mainname});
        }
    }

    public static void checkFile(IAttachment ia, byte[] content) throws BOSException, EASBizException {
        IAttachmentSize attachmentFactory = StringUtil4File.getAttachmentInstance(null);
        double attSize = attachmentFactory.getFileSize();
        double maxFileSize = attSize * 1024.0 * 1024.0;
        if ((double)content.length > maxFileSize) {
            throw new AttachmentException(AttachmentException.FILESIZENOTALLOWED, new String[]{String.valueOf(attSize)});
        }
        if (content.length == 0) {
            throw new AttachmentException(AttachmentException.FILECONTENTNOTGIVEN);
        }
    }

    public static void checkFile(IAttachment ia, double fileLength) throws BOSException, EASBizException {
        IAttachmentSize attachmentFactory = StringUtil4File.getAttachmentInstance(null);
        double attSize = attachmentFactory.getFileSize();
        double maxFileSize = attSize * 1024.0 * 1024.0;
        if (fileLength > maxFileSize) {
            throw new AttachmentException(AttachmentException.FILESIZENOTALLOWED, new String[]{String.valueOf(attSize)});
        }
        if (fileLength == 0.0) {
            throw new AttachmentException(AttachmentException.FILECONTENTNOTGIVEN);
        }
    }

    public static void checkURL(IAttachment ia, String boID, String mainname) throws BOSException, AttachmentException {
        if (mainname == null || mainname.equals("")) {
            throw new AttachmentException(AttachmentException.FILENAMEISEMPTY);
        }
        StringUtil4File.checkInvalidCharsInFileName(mainname);
        if (ia.isFileNameExisted(boID, mainname)) {
            throw new AttachmentException(AttachmentException.FILENAMEEXISTED, new String[]{mainname});
        }
    }

    public static String getAttachmentType(IAttachment ia, String attchID) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("simpleName"));
        return ia.getAttachmentInfo((IObjectPK)new ObjectUuidPK(attchID), sic).getSimpleName();
    }

    public static IAttachmentSize getAttachmentInstance(Context ctx) throws BOSException {
        IAttachmentSize attachmentFactory = null;
        attachmentFactory = ctx == null ? AttachmentSizeFactory.getRemoteInstance() : AttachmentSizeFactory.getLocalInstance(ctx);
        return attachmentFactory;
    }

    public static boolean checkExtendName(String extendName, String[] forbiddenName) {
        for (int i = 0; i < forbiddenName.length; ++i) {
            if (forbiddenName[i] == null || !extendName.equalsIgnoreCase(forbiddenName[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean checkExtendNameForWeb(String extendName, String[] forbiddenName) {
        for (int i = 0; i < forbiddenName.length; ++i) {
            if (forbiddenName[i] == null || !extendName.contains(forbiddenName[i])) continue;
            return false;
        }
        return true;
    }

    public static String[] decodeStringBy(String pattern, String sparator) {
        if (StringUtils.isEmpty((String)pattern)) {
            return new String[0];
        }
        String[] result = pattern.split(sparator);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }
}

