/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.billdigest.util.format;

import com.kingdee.bos.billdigest.util.format.Expr;
import com.kingdee.bos.billdigest.util.format.ForEach;
import com.kingdee.bos.billdigest.util.format.If;
import com.kingdee.bos.billdigest.util.format.PlainText;
import com.kingdee.bos.billdigest.util.format.Property;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Format
implements Serializable {
    public static final String BOS_CONTEXT = "ctx";
    public static final String BILL_OBJECT = "bo";
    public static final char LP = '{';
    public static final char RP = '}';
    public static final String PREFIX = "#{";
    public static final String SUFFIX = "}";
    public static final String FOR_EACH = "for-each:";
    public static final String RENAME = "->";
    public static final String IF = "if:";
    public static final String RUN = "run:";
    private static final long serialVersionUID = -7273825499718211282L;
    private String format;
    private List<Property> contents;

    public Format(String format) {
        if (format == null) {
            format = "";
        }
        this.format = format;
        this.contents = new LinkedList<Property>();
        this.parseFormat(format);
        this.contents = Collections.unmodifiableList(this.contents);
    }

    public String getFormat() {
        return this.format;
    }

    private void parseFormat(String format) {
        int i;
        int current = 0;
        while ((i = format.indexOf(PREFIX, current)) >= 0) {
            int j = this.findEndToken(format, i + PREFIX.length());
            if (j < 0) {
                throw new RuntimeException("\"" + format + "\"\u7684\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff01");
            }
            this.addPlainText(format, current, i);
            this.addPropertyRef(format, i, j);
            current = j + SUFFIX.length();
        }
        this.addPlainText(format, current, format.length());
    }

    private int findEndToken(String format, int start) {
        int j = -1;
        int count = 0;
        char lp = '{';
        char rp = '}';
        while (start < format.length()) {
            char c = format.charAt(start);
            if (rp == c) {
                if (count == 0) {
                    j = start;
                    break;
                }
                --count;
            } else if (lp == c) {
                ++count;
            }
            ++start;
        }
        return j;
    }

    private void addPropertyRef(String format, int i, int j) {
        int current = i + PREFIX.length();
        String name = format.substring(current, j);
        if (name.length() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u6307\u5b9a\u5f15\u7528\u7684\u5185\u5bb9\uff01");
        }
        if (name.startsWith(FOR_EACH)) {
            this.contents.add(new ForEach(name.substring(FOR_EACH.length())));
        } else if (name.startsWith(IF)) {
            this.contents.add(new If(name.substring(IF.length())));
        } else if (name.startsWith(RUN)) {
            this.contents.add(new If(name.substring(RUN.length())));
        } else {
            this.contents.add(new Expr(name));
        }
    }

    private void addPlainText(String format, int current, int i) {
        if (i > current) {
            String text = format.substring(current, i);
            PlainText p = new PlainText(text);
            this.contents.add(p);
        }
    }

    public String translate(Map<String, Object> ctx) {
        Object v = this.translateValue(ctx);
        if (v == null) {
            return "";
        }
        return v.toString();
    }

    public Object translateValue(Map<String, Object> ctx) {
        ctx.put("Format", util.Format.class);
        if (this.contents.size() == 1) {
            return this.contents.get(0).getFrom(ctx);
        }
        StringBuilder sb = new StringBuilder();
        for (Property p : this.contents) {
            Object value = p.getFrom(ctx);
            if (value == null) continue;
            sb.append(value);
        }
        return sb.toString();
    }

    public String toString() {
        return this.format;
    }

    public Collection<String> getReferences() {
        HashSet<String> refs = new HashSet<String>();
        this.addReferences(null, refs);
        return refs;
    }

    void addReferences(String prefix, Collection<String> refs) {
        for (Property p : this.contents) {
            p.addReference(prefix, refs);
        }
    }
}

