/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.app;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.job.util.JobUtils;
import java.io.Serializable;
import java.util.Date;
import org.apache.log4j.Logger;
import org.quartz.Calendar;
import org.quartz.impl.calendar.BaseCalendar;

public class WorkCalendar
extends BaseCalendar
implements Calendar,
Serializable {
    private static final long serialVersionUID = -4789114307313282241L;
    private static Logger logger = Logger.getLogger(WorkCalendar.class);
    private Context innerContext;
    private String innerOrgUnitId;

    public WorkCalendar(Context ctx, String orgUnitId) {
        if (orgUnitId == null || orgUnitId.trim().length() <= 0) {
            throw new IllegalArgumentException();
        }
        this.innerContext = ctx;
        this.innerOrgUnitId = orgUnitId;
    }

    public WorkCalendar(Calendar baseCalendar) {
        this.setBaseCalendar(baseCalendar);
    }

    public boolean isTimeIncluded(long timeStamp) {
        if (!super.isTimeIncluded(timeStamp)) {
            return false;
        }
        try {
            boolean isWorkDay = JobUtils.isWorkDay(this.innerContext, this.innerOrgUnitId, new Date(timeStamp), true);
            return isWorkDay;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public long getNextIncludedTime(long timeStamp) {
        long baseTime = super.getNextIncludedTime(timeStamp);
        if (baseTime > 0L && baseTime > timeStamp) {
            timeStamp = baseTime;
        }
        java.util.Calendar day = this.createJavaCalendar(timeStamp);
        while (!this.isTimeIncluded(day.getTime().getTime())) {
            day.add(11, 1);
        }
        return day.getTime().getTime();
    }
}

