/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataType;
import com.kingdee.bos.workflow.define.EventPolicyCollection;
import com.kingdee.bos.workflow.define.EventPolicyDef;
import com.kingdee.bos.workflow.define.ExternalType;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ProcessHeaderDef;
import com.kingdee.bos.workflow.metas.ActInstCollection;
import com.kingdee.bos.workflow.metas.ActInstFactory;
import com.kingdee.bos.workflow.metas.IActInst;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.job.IPackage;
import com.kingdee.eas.base.job.IProcessDef;
import com.kingdee.eas.base.job.PackageCollection;
import com.kingdee.eas.base.job.PackageFactory;
import com.kingdee.eas.base.job.ProcessDefCollection;
import com.kingdee.eas.base.job.ProcessDefFactory;
import com.kingdee.eas.base.job.util.FunctionObject;
import com.kingdee.eas.base.job.util.FunctionOperateObject;
import com.kingdee.eas.base.job.util.PackageObject;
import com.kingdee.eas.base.job.util.ProcessDefObject;
import com.kingdee.eas.base.job.util.ScheduleExpression;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.tree.TreePath;

public class JobProcessUtil {
    public static final String PACKAGE = "package";
    public static final String FUNCTION = "function";
    public static final String OPERATION = "operation";
    public static final String PROCESSDEF = "processdef";
    public static final String JOBPROCESSDEF = "jobprocessdef";
    public static final String READONLY = "readonly";

    public static DataType convertTypeReferenceToDataType(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        if (TypeReferenceString.INTEGER.equalsIgnoreCase(value) || TypeReferenceString.INT.equalsIgnoreCase(value) || TypeReferenceString.LONG.equalsIgnoreCase(value) || TypeReferenceString.SHORT.equalsIgnoreCase(value)) {
            return BasicType.INTEGER;
        }
        if (TypeReferenceString.BOOL.equalsIgnoreCase(value) || TypeReferenceString.BOOLEAN.equalsIgnoreCase(value)) {
            return BasicType.BOOLEAN;
        }
        if (TypeReferenceString.STRING.equalsIgnoreCase(value) || TypeReferenceString.CHAR.equalsIgnoreCase(value)) {
            return BasicType.STRING;
        }
        if (TypeReferenceString.FLOAT.equalsIgnoreCase(value) || TypeReferenceString.DOUBLE.equalsIgnoreCase(value)) {
            return BasicType.FLOAT;
        }
        if (TypeReferenceString.DATE.equalsIgnoreCase(value)) {
            return BasicType.DATETIME;
        }
        if (BasicType.BOID.getTypeName().equalsIgnoreCase(value) || TypeReferenceString.BOSUUID.equalsIgnoreCase(value)) {
            return BasicType.BOID;
        }
        if (BasicType.PK.getTypeName().equalsIgnoreCase(value)) {
            return BasicType.PK;
        }
        if (BasicType.OBJECTVALUE.getTypeName().equalsIgnoreCase(value)) {
            return BasicType.OBJECTVALUE;
        }
        if (ExternalType.ENUM.getTypeName().equalsIgnoreCase(value)) {
            return ExternalType.ENUM;
        }
        if (ExternalType.OBJECTCOLLECTION.getTypeName().equalsIgnoreCase(value)) {
            return ExternalType.OBJECTCOLLECTION;
        }
        return ExternalType.OBJECT;
    }

    public static ScheduleExpression parseSchedule(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value, " ");
        int count = st.countTokens();
        if (count >= 6) {
            String seconds = "";
            String minutes = "";
            String hours = "";
            String dayofmonth = "";
            String month = "";
            String dayofweek = "";
            String year = "";
            block9: for (int i = 0; i < count; ++i) {
                switch (i) {
                    case 0: {
                        seconds = st.nextToken();
                        continue block9;
                    }
                    case 1: {
                        minutes = st.nextToken();
                        continue block9;
                    }
                    case 2: {
                        hours = st.nextToken();
                        continue block9;
                    }
                    case 3: {
                        dayofmonth = st.nextToken();
                        continue block9;
                    }
                    case 4: {
                        month = st.nextToken();
                        continue block9;
                    }
                    case 5: {
                        dayofweek = st.nextToken();
                        continue block9;
                    }
                    case 6: {
                        year = st.nextToken();
                    }
                }
            }
            ScheduleExpression se = new ScheduleExpression();
            se.setSeconds(seconds);
            se.setMinutes(minutes);
            se.setHours(hours);
            se.setDayofmonth(dayofmonth);
            se.setMonth(month);
            se.setDayofweek(dayofweek);
            se.setYear(year);
            return se;
        }
        return null;
    }

    public static String getSelectedNodeType(KDTree destTree) {
        Object tempObject;
        if (destTree == null) {
            throw new IllegalArgumentException();
        }
        DefaultKingdeeTreeNode tempNode = JobProcessUtil.getSelectedNode(destTree);
        if (tempNode != null && (tempObject = tempNode.getUserObject()) != null) {
            if (tempObject instanceof PackageObject) {
                return PACKAGE;
            }
            if (tempObject instanceof FunctionObject) {
                return FUNCTION;
            }
            if (tempObject instanceof FunctionOperateObject) {
                return OPERATION;
            }
            if (tempObject instanceof ProcessDefObject) {
                return PROCESSDEF;
            }
        }
        return "";
    }

    public static Locale getCurrentLocale() {
        try {
            return SysContext.getSysContext().getLocale();
        }
        catch (Throwable e) {
            return new Locale("l2");
        }
    }

    public static IMetaDataLoader getMetaDataLoader() {
        return MetaDataLoaderFactory.getRemoteMetaDataLoader();
    }

    public static DefaultKingdeeTreeNode getSelectedNode(KDTree destTree) {
        Object tempObject;
        TreePath tempTP = destTree.getLeadSelectionPath();
        if (tempTP != null && (tempObject = tempTP.getLastPathComponent()) != null && tempObject instanceof DefaultKingdeeTreeNode) {
            DefaultKingdeeTreeNode destSelectedNode = (DefaultKingdeeTreeNode)tempObject;
            return destSelectedNode;
        }
        return null;
    }

    public static MetaDataPK getMetaDataPK(String absoluteName) {
        int lastIndexOfDot = absoluteName.lastIndexOf(".");
        String packageName = absoluteName.substring(0, lastIndexOfDot);
        String name = absoluteName.substring(lastIndexOfDot + 1);
        return new MetaDataPK(packageName, name);
    }

    public static EntityObjectInfo getEntity(String absoluteName) {
        MetaDataPK tempMPK = JobProcessUtil.getMetaDataPK(absoluteName);
        return JobProcessUtil.getMetaDataLoader().getEntity((IMetaDataPK)tempMPK);
    }

    public static PackageCollection getPackageCollection() {
        try {
            IPackage pckg = PackageFactory.getRemoteInstance();
            EntityViewInfo evi = new EntityViewInfo();
            PackageCollection pckgc = pckg.getCollection(evi);
            return pckgc;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static ProcessDefCollection getPDEFC(String type) {
        try {
            IProcessDef pdef = ProcessDefFactory.getRemoteInstance();
            StringBuffer buffer = new StringBuffer();
            if (type != null && type.length() > 0) {
                buffer.append("select packageName, name where packageName is not null and ");
                buffer.append(" (procDefType='" + type + "')");
            }
            String oql = buffer.toString();
            ProcessDefCollection pc = pdef.getCollection(oql);
            return pc;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static ActInstCollection getActInstCollection() {
        try {
            IActInst ai = ActInstFactory.getRemoteInstance();
            EntityViewInfo evi = new EntityViewInfo();
            ActInstCollection aic = ai.getCollection(evi);
            return aic;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static IEnactmentService getEnactmentService() throws WfException {
        try {
            return EnactmentServiceFactory.createRemoteEnactService();
        }
        catch (BOSException e) {
            throw new WfException("create RemoteEnactService error!", (Throwable)e);
        }
    }

    public static PersonInfo[] getResponsibles(String jobDefId, Context ctx) throws BOSException {
        IEnactmentService svc = ctx == null ? EnactmentServiceFactory.createRemoteEnactService() : EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessDefInfo info = svc.getProcessDefInfo(jobDefId);
        if (info == null) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"37_JobProcessUtil") + jobDefId + EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"38_JobProcessUtil"));
        }
        String hash = info.getMd5HashValue();
        ProcessDef def = svc.getProcessDefByDefineHashValue(hash);
        return JobProcessUtil.getResponsibles(def);
    }

    public static PersonInfo[] getResponsibles(ProcessDef def) {
        EventPolicyCollection rc;
        String responsibleName = null;
        String responsibleId = null;
        ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
        ProcessHeaderDef header = def.getProcessHeader();
        if (header != null && (rc = header.getEventPolicies()) != null && rc.size() > 0) {
            EventPolicyDef event = rc.get(0);
            ParticipantCollection participants = event.getParticipants();
            for (int i = 0; i < participants.size(); ++i) {
                ParticipantDef res = participants.get(i);
                responsibleName = res.getName();
                responsibleId = res.getParticipantValue();
                PersonInfo p = new PersonInfo();
                if (responsibleId != null) {
                    p.setId(BOSUuid.read((String)responsibleId));
                    p.setName(responsibleName);
                }
                persons.add(p);
            }
        }
        return persons.toArray(new PersonInfo[0]);
    }

    private static class TypeReferenceString {
        public static String INTEGER = "Integer";
        public static String CHAR = "Char";
        public static String FLOAT = "Float";
        public static String DATE = "Date";
        public static String BOOLEAN = "Boolean";
        public static String BYTE = "byte";
        public static String DOUBLE = "Double";
        public static String LONG = "Long";
        public static String SHORT = "Short";
        public static String BOOL = "boolean";
        public static String INT = "int";
        public static String STRING = "String";
        public static String BOSUUID = "BOSUuid";

        private TypeReferenceString() {
        }
    }
}

