/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.util;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.PublicationStatus;
import com.kingdee.eas.base.job.util.IReleaseObserver;
import com.kingdee.eas.base.job.util.JobResourceUtil;
import com.kingdee.eas.base.job.util.JobUtils;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ReleaseJobProgress {
    private ProcessDef process;
    private IReleaseObserver releaseInfo;

    public ReleaseJobProgress(ProcessDef value, IReleaseObserver info) {
        try {
            this.process = value;
            this.releaseInfo = info;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void beginRelease() {
        this.releaseInfo.addInfo("\n");
        this.releaseInfo.addInfo(JobResourceUtil.getReleaseStringResource("ReleaseingJobProcess") + this.process.getName());
        this.releaseInfo.addInfo("\n");
    }

    private void validateFail() {
        this.releaseInfo.addInfo(JobResourceUtil.getReleaseStringResource("ValidateFail"));
        this.releaseInfo.addInfo("\n");
        this.releaseInfo.addInfo(JobResourceUtil.getReleaseStringResource("ReleaseFail"));
    }

    private void validateSuccess() {
        this.releaseInfo.addInfo(JobResourceUtil.getReleaseStringResource("ValidateSuccess"));
        this.releaseInfo.addInfo("\n");
        this.releaseInfo.addInfo(JobResourceUtil.getReleaseStringResource("Job") + "\u201c" + this.process.getName() + "\u201d  " + JobResourceUtil.getReleaseStringResource("JobProcessInReleasing"));
        this.releaseInfo.addInfo("\n");
        this.release();
    }

    private void release() {
        try {
            JobUtils.getJobServiceFacade().release(this.process);
            this.releaseInfo.addInfo(JobResourceUtil.getReleaseStringResource("ReleaseSuccess"));
            this.process.getProcessHeader().setPublicationStatus(PublicationStatus.RELEASED);
            this.releaseInfo.addInfo("\n");
            this.releaseInfo.addInfo(JobResourceUtil.getReleaseStringResource("ReleaseComplete"));
        }
        catch (Exception e) {
            this.releaseInfo.addInfo(JobResourceUtil.getReleaseStringResource("ReleaseFail"));
            this.releaseInfo.addInfo("\n");
            this.releaseInfo.addInfo(e.getMessage() + "\n" + e.fillInStackTrace());
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private boolean validateProcessDef(ProcessDef currentProcessDef) {
        this.releaseInfo.addInfo(JobResourceUtil.getReleaseStringResource("JobProcessInValidateing"));
        this.releaseInfo.addInfo("\n");
        try {
            Date validTo;
            Date validFrom;
            Date lastMissedTime;
            if (this.process != null && (lastMissedTime = JobUtils.getLastMissedTime(validFrom = this.process.getProcessHeader().getValidFrom(), validTo = this.process.getProcessHeader().getValidTo(), this.process.getProcessHeader().getScheduale().getDefine())) != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String time = sdf.format(lastMissedTime);
                String msg = MessageFormat.format(JobResourceUtil.getReleaseStringResource("FireLastMissedJobMsg"), time);
                boolean isFireLastMissedJob = MsgBox.isYes((int)MsgBox.showConfirm2(null, (String)msg));
                msg = isFireLastMissedJob ? JobResourceUtil.getReleaseStringResource("ExecuteImmediately") : JobResourceUtil.getReleaseStringResource("CancelExecuteImmediately");
                ExtendedAttributeCollection extendedAttributes = this.process.getExtendedAttributes();
                ExtendedAttributeDef extendedAttributeDef = new ExtendedAttributeDef();
                extendedAttributeDef.setName("isFireLastMissedJob");
                extendedAttributeDef.setValue(Boolean.toString(isFireLastMissedJob));
                extendedAttributes.setObject("isFireLastMissedJob", (Object)extendedAttributeDef);
                this.releaseInfo.addInfo(msg);
                this.releaseInfo.addInfo("\n");
                IObjectPK logPK = LogUtil.beginLog(null, (String)"isFireLastMissedJob", (BOSObjectType)BOSObjectType.create((String)"F2807CCC"), (IObjectPK)new ObjectUuidPK(this.process.getID()), (String)(this.process.getName() + " " + JobResourceUtil.getReleaseStringResource("ReleaseWindowTitle") + msg + " " + isFireLastMissedJob));
                if (logPK != null) {
                    LogUtil.afterLog(null, (IObjectPK)logPK);
                }
            }
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public boolean releaseProcess() {
        this.beginRelease();
        boolean result = this.validateProcessDef(this.process);
        if (!result) {
            this.validateFail();
            return false;
        }
        this.validateSuccess();
        return true;
    }
}

