/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ControlPolicy;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.cloud.SynShrUserToCloudUtils;
import com.kingdee.eas.base.uiframe.EASCloudEnv;
import com.kingdee.eas.base.uiframe.utils.HttpUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class EasCloud {
    private static Logger logger = Logger.getLogger(EasCloud.class);
    public static String CLOUD_URL = "http://api.kingdee.com/";
    public static final String CLOUD_URL_HTTPS = "https://api.kingdee.com/";
    private static String BINDQUERY_URL = CLOUD_URL + "kderp/binding";
    private static String BINDINGPAGE_URL = CLOUD_URL + "kderp/binding/page";
    public static String CALLBACK_URL = "kderp/page/callback";
    private static String ACCESSTOKEN_URL = CLOUD_URL + "kderp/access_token";
    public static String CLOUDERPACCESSTOKEN_URL = CLOUD_URL + "clouderp/access_token";
    private static String ENCODE = "utf-8";
    public static String CLIENT_ID = "200213";
    public static String CLIENT_SECRET = "6fabfebe039a0c31b84f79e9069abecf";
    private static String ACTIVECODE_URL = CLOUD_URL + "clouderp/account/vcode";
    private static String VERIFYCODE_URL = CLOUD_URL + "clouderp/account/vcode/verifying";
    private static String LICENSE_URL = CLOUD_URL + "kdproduct/prod_instance/licence/download";
    private static String LICENE_BUILD_URL = CLOUD_URL + "kdproduct/prod_instance/license/build";
    private static String LICENSE_PROCESSS_URL = CLOUD_URL + "kdproduct/prod_instance/license/build_process";
    private static String KBC_LICENSE_URL = CLOUD_URL + "kdproduct/v1/prod_instance/licence/download";
    private static String KBC_LICENE_BUILD_URL = CLOUD_URL + "kdproduct/v1/prod_instance/license/build";
    private static String KBC_LICENSE_PROCESSS_URL = CLOUD_URL + "kdproduct/v1/prod_instance/license/build_process";
    public static String AUTH_USER_ACCESSTOKEN_URL = CLOUD_URL + "auth/user/access_token";
    private static String LICENSE_PRO_VERIFY_URL = CLOUD_URL + "kdproduct/prod_instance/group_member/verify";
    private static String GET_STRATEGY_URL = CLOUD_URL + "passport/enterprise/config";
    private static String AUTH_USER_AUTH_CODE = CLOUD_URL + "auth/user/auth_code";
    private static String CLOUDAUTHENTICATION_URL = CLOUD_URL + "kdproduct/user/auth";
    private static String FIND_OR_INIT_PASS = CLOUD_URL + "passport/account/phone";
    public static String OFFLINE_QRCODE_URL = CLOUD_URL + "clouderp/account/qrcode/offline";
    public static String CLOUD_ACTIVE_STATU = CLOUD_URL + "passport/user/active_status";
    public static String DESCRIPTION = "description";
    public static String DESCRIPTION_CN = "description_cn";
    private static String IERP_URL = "https://ierptest.kingdee.com/ierp/api";
    private static String getAppToken = "/getAppToken.do";
    private static String appId = "kbc_wjy";
    private static String appSecuret = "kbcwjy20210115";
    private static String success = "success";
    private static String login = "/login.do";
    private static String user = "15017919790";
    private static String KBC_URL = "https://ierptest.kingdee.com/ierp/kapi/app/sm/license";
    private static String GROUP_MEMBER_URL = CLOUD_URL + "kdproduct/prod_instance/group_member";

    public static void changeCloudEnv(boolean isTestEnv, boolean isRequireHttps) {
        if (isTestEnv) {
            CLOUD_URL = isRequireHttps ? "https://api.cloudsz.kingdee.com/" : "http://api.cloudsz.kingdee.com/";
            CLIENT_ID = "205701";
            CLIENT_SECRET = "07cdd368dd32f73176029ef38871e398";
        } else if (isRequireHttps) {
            CLOUD_URL = CLOUD_URL_HTTPS;
        }
        BINDQUERY_URL = CLOUD_URL + "kderp/binding";
        BINDINGPAGE_URL = CLOUD_URL + "kderp/binding/page";
        ACCESSTOKEN_URL = CLOUD_URL + "kderp/access_token";
        CLOUDERPACCESSTOKEN_URL = CLOUD_URL + "clouderp/access_token";
        ACTIVECODE_URL = CLOUD_URL + "clouderp/account/vcode";
        VERIFYCODE_URL = CLOUD_URL + "clouderp/account/vcode/verifying";
        LICENSE_URL = CLOUD_URL + "kdproduct/prod_instance/licence/download";
        LICENE_BUILD_URL = CLOUD_URL + "kdproduct/prod_instance/license/build";
        LICENSE_PROCESSS_URL = CLOUD_URL + "kdproduct/prod_instance/license/build_process";
        KBC_LICENSE_URL = CLOUD_URL + "kdproduct/v1/prod_instance/licence/download";
        KBC_LICENE_BUILD_URL = CLOUD_URL + "kdproduct/v1/prod_instance/license/build";
        KBC_LICENSE_PROCESSS_URL = CLOUD_URL + "kdproduct/v1/prod_instance/license/build_process";
        AUTH_USER_ACCESSTOKEN_URL = CLOUD_URL + "auth/user/access_token";
        LICENSE_PRO_VERIFY_URL = CLOUD_URL + "kdproduct/prod_instance/group_member/verify";
        GET_STRATEGY_URL = CLOUD_URL + "passport/enterprise/config";
        AUTH_USER_AUTH_CODE = CLOUD_URL + "auth/user/auth_code";
        CLOUDAUTHENTICATION_URL = CLOUD_URL + "kdproduct/user/auth";
        FIND_OR_INIT_PASS = CLOUD_URL + "passport/account/phone";
        OFFLINE_QRCODE_URL = CLOUD_URL + "clouderp/account/qrcode/offline";
        CLOUD_ACTIVE_STATU = CLOUD_URL + "passport/user/active_status";
        GROUP_MEMBER_URL = CLOUD_URL + "kdproduct/prod_instance/group_member";
    }

    public static void main(String[] args) {
        String prod_inst_code = "S03S001S0010000-201195-001";
        String url = LICENSE_URL + "?prod_inst_code=" + prod_inst_code + "&client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET;
        try {
            File file = File.createTempFile(System.currentTimeMillis() + "", ".zip");
            System.out.println("path=" + file.getPath());
            System.out.println("******download over***");
            EasCloud.getRegistorUsers("16496670101dcabcbd11a4bdbdcb35ce");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONObject getActiveCode(String uid, String prod_inst_code, String phone, String email) throws Exception {
        return EasCloud.getActiveCode(uid, prod_inst_code, phone, email, null);
    }

    public static JSONObject getActiveCode(String uid, String prod_inst_code, String phone, String email, String type) throws Exception {
        long timestamp = System.currentTimeMillis();
        StringBuffer sha1Param = new StringBuffer();
        sha1Param.append(CLIENT_ID);
        sha1Param.append(CLIENT_SECRET);
        sha1Param.append(uid);
        sha1Param.append(prod_inst_code);
        sha1Param.append(phone);
        sha1Param.append(email);
        sha1Param.append(timestamp);
        String signiture = EasCloud.sha1(sha1Param.toString());
        String pCode = StringUtils.isEmpty((String)prod_inst_code) ? "" : prod_inst_code;
        StringBuilder sb = new StringBuilder();
        sb.append("client_id=").append(CLIENT_ID).append("&uid=").append(URLEncoder.encode(uid == null ? "" : uid, "UTF-8")).append("&prod_inst_code=").append(URLEncoder.encode(pCode, "UTF-8")).append("&phone=").append(URLEncoder.encode(phone == null ? "" : phone, "UTF-8")).append("&email=").append(URLEncoder.encode(email == null ? "" : email, "UTF-8")).append("&signiture=").append(signiture).append("&timestamp=").append(timestamp);
        if (!StringUtils.isEmpty((String)type)) {
            sb.append("&type=").append(type);
        }
        return EasCloud.doGet(ACTIVECODE_URL, sb.toString(), new int[0]);
    }

    public static JSONObject verifyCode(String uid, String prod_inst_code, String phone, String email, String vcode) throws Exception {
        long timestamp = System.currentTimeMillis();
        StringBuffer sha1Param = new StringBuffer();
        sha1Param.append(CLIENT_ID);
        sha1Param.append(CLIENT_SECRET);
        sha1Param.append(uid);
        sha1Param.append(prod_inst_code);
        sha1Param.append(phone);
        sha1Param.append(email);
        sha1Param.append(vcode);
        sha1Param.append(timestamp);
        String signiture = EasCloud.sha1(sha1Param.toString());
        String pCode = StringUtils.isEmpty((String)prod_inst_code) ? "" : prod_inst_code;
        StringBuilder sb = new StringBuilder();
        sb.append("client_id=").append(CLIENT_ID).append("&uid=").append(URLEncoder.encode(uid == null ? "" : uid, "UTF-8")).append("&prod_inst_code=").append(URLEncoder.encode(pCode, "UTF-8")).append("&phone=").append(URLEncoder.encode(phone == null ? "" : phone, "UTF-8")).append("&email=").append(URLEncoder.encode(email == null ? "" : email, "UTF-8")).append("&vcode=").append(vcode).append("&signiture=").append(signiture).append("&timestamp=").append(timestamp);
        return EasCloud.doGet(VERIFYCODE_URL, sb.toString(), new int[0]);
    }

    public static JSONObject bindQuery(String userId, String userNumber, String product_code, String software_code) throws Exception {
        try {
            String param = EasCloud.string2Param(userId, userNumber, product_code, software_code);
            return EasCloud.doGet(BINDQUERY_URL, param, new int[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public static String bindingPage(String userId, String userNumber, String product_code, String software_code) throws Exception {
        String param = EasCloud.string2Param(userId, userNumber, product_code, software_code);
        return BINDINGPAGE_URL + "?" + param;
    }

    public static JSONObject getUserAccessToken(String userName, String password) throws Exception {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("username=").append(URLEncoder.encode(userName, ENCODE)).append("&password=").append(URLEncoder.encode(password, ENCODE)).append("&client_id=").append(CLIENT_ID).append("&client_secret=").append(CLIENT_SECRET);
            return EasCloud.doGet(AUTH_USER_ACCESSTOKEN_URL, sb.toString(), new int[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public static JSONObject getUserAuthCode(String accessToken) throws Exception {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("&access_token=").append(accessToken);
            return EasCloud.doGet(AUTH_USER_AUTH_CODE, sb.toString(), new int[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public static JSONObject getLicenseProVerify(String access_token, String prod_inst_code) throws Exception {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("access_token=").append(access_token).append("&prod_inst_code=").append(prod_inst_code);
            return EasCloud.doGet(LICENSE_PRO_VERIFY_URL, sb.toString(), new int[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public static JSONObject accessToken(String userId, String userNumber, String product_code, String software_code) throws Exception {
        try {
            String param = EasCloud.string2Param(userId, userNumber, product_code, software_code);
            return EasCloud.doGet(ACCESSTOKEN_URL, param, new int[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public static JSONObject cloudErpAccessToken(String uId, String prod_inst_code) throws Exception {
        try {
            String param = EasCloud.string3Param(uId, prod_inst_code);
            return EasCloud.doGet(CLOUDERPACCESSTOKEN_URL, param, new int[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
    }

    private static String string3Param(String uId, String prod_inst_code) throws Exception {
        long timestamp = new Date().getTime() / 1000L;
        StringBuffer sha1Param = new StringBuffer();
        sha1Param.append(CLIENT_ID);
        sha1Param.append(CLIENT_SECRET);
        sha1Param.append(uId);
        sha1Param.append(prod_inst_code);
        sha1Param.append(timestamp);
        String signiture = EasCloud.sha1(sha1Param.toString());
        StringBuffer paramSB = new StringBuffer();
        paramSB.append("client_id=" + CLIENT_ID);
        paramSB.append("&uid=" + URLEncoder.encode(uId, ENCODE));
        paramSB.append("&prod_inst_code=" + URLEncoder.encode(prod_inst_code, ENCODE));
        paramSB.append("&timestamp=" + timestamp);
        paramSB.append("&signiture=" + signiture);
        return paramSB.toString();
    }

    private static String string2Param(String userId, String userNumber, String product_code, String software_code) throws Exception {
        long timestamp = System.currentTimeMillis();
        StringBuffer sha1Param = new StringBuffer();
        sha1Param.append(CLIENT_ID);
        sha1Param.append(CLIENT_SECRET);
        sha1Param.append(userId);
        sha1Param.append(userNumber);
        if (product_code != null) {
            sha1Param.append(product_code);
        }
        sha1Param.append(software_code);
        sha1Param.append(timestamp);
        String signiture = EasCloud.sha1(sha1Param.toString());
        StringBuffer paramSB = new StringBuffer();
        paramSB.append("client_id=" + CLIENT_ID);
        paramSB.append("&euid=" + URLEncoder.encode(userId, ENCODE));
        paramSB.append("&ename=" + URLEncoder.encode(userNumber, ENCODE));
        if (product_code != null) {
            paramSB.append("&product_code=" + URLEncoder.encode(product_code, ENCODE));
        }
        paramSB.append("&software_code=" + URLEncoder.encode(software_code, ENCODE));
        paramSB.append("&timestamp=" + timestamp);
        paramSB.append("&signiture=" + signiture);
        return paramSB.toString();
    }

    public static void downloadLicense(String prod_inst_code, String filePath) throws Exception {
        String buildUrl = LICENE_BUILD_URL + "?prod_inst_code=" + prod_inst_code + "&client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET;
        String processUrl = LICENSE_PROCESSS_URL + "?prod_inst_code=" + prod_inst_code + "&client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET + "&job_id=";
        String url = LICENSE_URL + "?is_zip=1&prod_inst_code=" + prod_inst_code + "&client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET;
        EasCloud.prepareMostNewLicenseData(prod_inst_code, buildUrl, processUrl);
        EasCloud.downloadFile(url, filePath);
    }

    public static void downloadLicenseKBC(String prod_inst_code, String filePath) throws Exception {
        String buildUrl = KBC_LICENE_BUILD_URL + "?prod_inst_code=" + prod_inst_code + "&client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET;
        String processUrl = KBC_LICENSE_PROCESSS_URL + "?prod_inst_code=" + prod_inst_code + "&client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET + "&job_id=";
        String url = KBC_LICENSE_URL + "?is_zip=1&prod_inst_code=" + prod_inst_code + "&client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET;
        EasCloud.prepareMostNewLicenseData(prod_inst_code, buildUrl, processUrl);
        EasCloud.downloadFile(url, filePath);
    }

    public static boolean prepareMostNewLicenseData(String prod_inst_code, String buildUrl, String processUrl) throws BOSException {
        String job_id = "";
        String responseBody = "";
        int code = -1;
        boolean isSuccess = false;
        int max = 0;
        while (max++ < 30) {
            block19: {
                try {
                    responseBody = EasCloud.httpClient(buildUrl);
                    if (StringUtils.isEmpty((String)responseBody) || "null".equals(responseBody)) {
                        logger.error((Object)"return respose is null");
                    }
                    break block19;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                break;
            }
            code = EasCloud.getCode(responseBody);
            if (0 == code) {
                job_id = EasCloud.getJobId(responseBody);
                if (!StringUtils.isEmpty((String)job_id)) {
                    isSuccess = true;
                    logger.error((Object)(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>request bulid license \u6210\u529f\uff01\u4efb\u52a1id:" + job_id));
                    break;
                }
            } else {
                if (4006 == code) {
                    logger.error((Object)"Product instance not found");
                    break;
                }
                if (1 == code) {
                    logger.error((Object)"respose is null");
                    break;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
        }
        if (!isSuccess) {
            logger.error((Object)responseBody);
            throw new BOSException("\u6784\u5efa\u8bb8\u53ef\u4e91\u5e73\u53f0\u63a5\u53e3\u6210\u529f\u8fd4\u56de\u91cd\u8bd5\u8d85\u65f6,\u8fd4\u56de\u5185\u5bb9\uff1a" + responseBody);
        }
        processUrl = processUrl + job_id;
        isSuccess = false;
        max = 0;
        while (max++ < 60) {
            try {
                responseBody = EasCloud.httpClient(processUrl);
            }
            catch (Exception e) {
                logger.error((Object)e);
                break;
            }
            code = EasCloud.getCode(responseBody);
            if (0 == code && 2 == EasCloud.getStatus(responseBody)) {
                isSuccess = true;
                logger.error((Object)(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>bulid license \u5b8c\u6210\uff01\u4efb\u52a1id:" + job_id));
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
        }
        if (!isSuccess) {
            logger.error((Object)responseBody);
            throw new BOSException("\u8bb8\u53ef\u6784\u5efa\u72b6\u6001\u83b7\u53d6\u4e91\u5e73\u53f0\u63a5\u53e3\u6210\u529f\u8fd4\u56de\u91cd\u8bd5\u8d85\u65f6,\u8fd4\u56de\u5185\u5bb9\uff1a" + responseBody);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadLicense(String code, String instanceId, String type, String prodouctId, String filePath) throws Exception {
        String licenseData = EasCloud.getLicenseData(code, instanceId, type, prodouctId);
        try (ZipOutputStream zipOutputStream = null;){
            zipOutputStream = new ZipOutputStream(new FileOutputStream(filePath));
            zipOutputStream.putNextEntry(new ZipEntry("license.lic"));
            zipOutputStream.write(licenseData.getBytes("UTF-8"));
            zipOutputStream.closeEntry();
        }
    }

    private static int getCode(String resultStr) {
        Map resultMap = SynShrUserToCloudUtils.paraseExecResult((String)resultStr);
        return Integer.parseInt(String.valueOf(resultMap == null ? Integer.valueOf(1) : (resultMap.get("code") != null ? resultMap.get("code") : resultMap.get("errcode"))));
    }

    private static String getJobId(String resultStr) {
        Map resultMap = SynShrUserToCloudUtils.paraseExecResult((String)resultStr);
        Map resultMap1 = null;
        if (resultMap.get("data") != null) {
            resultMap1 = SynShrUserToCloudUtils.paraseExecResult((String)resultMap.get("data").toString());
        }
        String result = "";
        if (resultMap1 != null && resultMap1.get("job_id") != null) {
            result = String.valueOf(resultMap1.get("job_id"));
        }
        return result;
    }

    private static int getStatus(String resultStr) {
        Map resultMap = SynShrUserToCloudUtils.paraseExecResult((String)resultStr);
        Map resultMap1 = null;
        if (resultMap != null && resultMap.get("data") != null) {
            resultMap1 = SynShrUserToCloudUtils.paraseExecResult((String)resultMap.get("data").toString());
        }
        String s = String.valueOf(resultMap1 == null ? Integer.valueOf(0) : (resultMap1.get("status") != null ? resultMap1.get("status") : Integer.valueOf(0)));
        return s != null ? Integer.parseInt(s) : 0;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String httpClient(String url) throws IOException {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
        GetMethod method = new GetMethod(url);
        method.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        String responseBody = null;
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)method);
            responseBody = method.getResponseBodyAsString();
        }
        catch (HttpException e) {
            try {
                logger.error((Object)("http exception>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>" + (Object)((Object)e)));
                throw e;
                catch (IOException e2) {
                    logger.error((Object)("IOException >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>" + e2));
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                logger.error((Object)MessageFormat.format(" doExecuteHttpGet state success url is {0},response content is{1}  ", url, responseBody));
                method.releaseConnection();
                throw throwable;
            }
        }
        logger.error((Object)MessageFormat.format(" doExecuteHttpGet state success url is {0},response content is{1}  ", url, responseBody));
        method.releaseConnection();
        return responseBody;
    }

    private static void downloadFile(String url, String filePath) throws Exception {
        HttpURLConnection conn = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            URL realUrl = new URL(url);
            conn = (HttpURLConnection)realUrl.openConnection();
            if (conn == null) {
                return;
            }
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(3600000);
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("Accept-Charset", ENCODE);
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.connect();
            try {
                in = conn.getInputStream();
            }
            catch (IOException e1) {
                logger.error((Object)("conn.getInputStream()>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>" + e1));
            }
            if (in == null) {
                return;
            }
            if (conn.getContentType().indexOf("text") > -1) {
                throw new Exception("download fail");
            }
            out = new FileOutputStream(filePath);
            byte[] b = new byte[8096];
            int i = 0;
            while ((i = in.read(b)) != -1) {
                out.write(b, 0, i);
                out.flush();
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u4e0b\u8f7dlicense\u5931\u8d25connector>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>30000" + e));
            throw e;
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (Exception ex) {
                    logger.error((Object)"conn disconnect error!");
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
        }
    }

    private static JSONObject doGet(String url, String param, int ... timeout) throws Exception {
        StringBuffer result = new StringBuffer();
        BufferedReader in = null;
        HttpURLConnection conn = null;
        try {
            String line;
            String urlName = url + "?" + param;
            URL realUrl = new URL(urlName);
            conn = (HttpURLConnection)realUrl.openConnection();
            if (timeout.length > 0) {
                conn.setConnectTimeout(timeout[0] * 1000);
            } else {
                conn.setConnectTimeout(30000);
            }
            if (timeout.length > 1) {
                conn.setConnectTimeout(timeout[1] * 1000);
            } else {
                conn.setReadTimeout(60000);
            }
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("Accept-Charset", ENCODE);
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.connect();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), ENCODE));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return JSONObject.parseObject((String)new String(result.toString().getBytes(ENCODE), ENCODE));
    }

    public static String sha1(String data) throws Exception {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(data.getBytes(ENCODE));
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public static JSONObject getComnnicationStrategy(String prod_inst_code) throws Exception {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("client_id=").append(CLIENT_ID).append("&client_secret=").append(CLIENT_SECRET).append("&prod_inst_code=").append(prod_inst_code);
            return EasCloud.doGet(GET_STRATEGY_URL, sb.toString(), new int[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public static String getUserLicenseInfoByCloud(Context ctx, String userPk) throws Exception {
        FilterOutputStream ds = null;
        InputStream in = null;
        BufferedReader reader = null;
        try {
            String description;
            UserInfo info;
            if (userPk == null || Administrator.isDefaultUser((BOSUuid)BOSUuid.read((String)userPk))) {
                String string = null;
                return string;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            ILicenseSrvAgent agent = null;
            ICloudRegistSrv cloudRegistSrv = null;
            if (ctx == null) {
                agent = LicenseSrvAgentFactory.getRemoteInstance();
                cloudRegistSrv = CloudRegistSrvAgentFactory.getRemoteInstance();
            } else {
                agent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
                cloudRegistSrv = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx);
            }
            if (cloudRegistSrv.isInternalUseType()) {
                String string = null;
                return string;
            }
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            if (!ControlPolicy.isBySubscriptionRegOnline((Context)ctx)) {
                String e = null;
                return e;
            }
            String uid = null;
            if (ctx == null) {
                uid = SysContext.getSysContext().getCurrentUserInfo().getUid();
            } else {
                info = UserFactory.getLocalInstance((Context)ctx).getUserInfo("select uid where id='" + userPk + "'");
                uid = info.getUid();
            }
            if (uid == null) {
                info = null;
                return info;
            }
            String accessToken = null;
            JSONObject o = EasCloud.cloudErpAccessToken(uid, baseInfo.getProductInstanceID());
            if (o.getInteger("errcode") == 0) {
                JSONObject data = JSONObject.parseObject((String)o.getString("data"));
                accessToken = data.getString("access_token");
            } else {
                if (3031 == o.getInteger("errcode")) {
                    throw new UserException(UserException.USER_BEEN_FORBIDDEN);
                }
                description = o.getString("description");
                logger.error((Object)("Failed to get AccessToken. " + description));
            }
            if (accessToken == null) {
                description = null;
                return description;
            }
            params.put("access_token", accessToken);
            params.put("prod_inst_code", baseInfo.getProductInstanceID());
            params.put("nonce", String.valueOf(System.currentTimeMillis()));
            params.put("sn", baseInfo.getSerialNum());
            params.put("sw_code", baseInfo.getMechineCode());
            params.put("version", "1");
            URL sendUrl = new URL(CLOUDAUTHENTICATION_URL);
            HttpURLConnection conn = (HttpURLConnection)sendUrl.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setConnectTimeout(1500);
            conn.setReadTimeout(1500);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("Charsert", "UTF-8");
            conn.setRequestProperty("content-type", "application/x-www-form-urlencoded");
            conn.setInstanceFollowRedirects(false);
            conn.connect();
            ds = new DataOutputStream(conn.getOutputStream());
            String content = "";
            for (Map.Entry entry : params.entrySet()) {
                content = content + (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), ENCODE) + "&";
            }
            content = content + "1=1";
            ((DataOutputStream)ds).writeBytes(content);
            ((DataOutputStream)ds).flush();
            ds.close();
            in = conn.getInputStream();
            StringBuffer sb = new StringBuffer();
            reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            conn.disconnect();
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static JSONObject modifyCloudPass(String phone, String email, String vcode, String pass) throws IOException {
        OutputStream ds = null;
        InputStream in = null;
        BufferedReader reader = null;
        try {
            StringBuilder params = new StringBuilder();
            params.append("phone=").append(URLEncoder.encode(phone == null ? "" : phone, "UTF-8")).append("&email=").append(URLEncoder.encode(email == null ? "" : email, "UTF-8")).append("&vcode=").append(vcode).append("&password=").append(URLEncoder.encode(pass == null ? "" : pass, "UTF-8"));
            URL sendUrl = new URL(FIND_OR_INIT_PASS + "?client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET);
            HttpURLConnection conn = (HttpURLConnection)sendUrl.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.setRequestMethod("PUT");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            ds = conn.getOutputStream();
            ds.write(params.toString().getBytes("utf-8"));
            ds.flush();
            conn.connect();
            if (conn.getResponseCode() == 200) {
                in = conn.getInputStream();
                StringBuffer sb = new StringBuffer();
                reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                conn.disconnect();
                JSONObject jSONObject = JSONObject.parseObject((String)sb.toString());
                return jSONObject;
            }
            try {
                in = conn.getErrorStream();
                StringBuffer sb = new StringBuffer();
                reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                conn.disconnect();
                throw new IOException(sb.toString());
            }
            catch (SocketTimeoutException e) {
                logger.error((Object)e);
                throw new IOException("time out");
            }
            catch (IOException e) {
                logger.error((Object)e);
                throw e;
            }
        }
        finally {
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static JSONObject getUserCloudActiveStatu(Context ctx, String userNumber) throws Exception {
        UserInfo userInfo = null;
        LicenseBaseInfo licenseInfo = null;
        if (ctx != null) {
            licenseInfo = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getLicenseBaseInfo();
            userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfoByNumber(userNumber);
        } else {
            userInfo = UserFactory.getRemoteInstance().getUserInfoByNumber(userNumber);
            licenseInfo = LicenseSrvAgentFactory.getRemoteInstance().getLicenseBaseInfo();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("client_id=").append(CLIENT_ID).append("&client_secret=").append(CLIENT_SECRET).append("&uid=").append(userInfo.getUid()).append("&erp_account=").append(userNumber).append("&prod_inst_code=").append(licenseInfo.getProductInstanceID()).append("&email=").append(StringUtils.isEmpty((String)userInfo.getCell()) ? userInfo.getEmail() : "").append("&phone=").append(userInfo.getCell());
        return EasCloud.doGet(CLOUD_ACTIVE_STATU, sb.toString(), 2, 2);
    }

    public static String getErrorMsg(JSONObject rs) {
        String descKey = null;
        if ("l1".equalsIgnoreCase(SysContext.getSysContext().getLocale().toString())) {
            descKey = "description";
            if (rs.getString(descKey) == null) {
                descKey = "description_cn";
            }
        } else {
            descKey = "description_cn";
        }
        return rs.getString(descKey);
    }

    public static String getAppToken() throws Exception {
        String url = IERP_URL + getAppToken;
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("appId", appId);
        body.put("appSecuret", appSecuret);
        String rtJson = HttpUtils.postJson(url, new Gson().toJson(body));
        Map rtMap = (Map)new Gson().fromJson(rtJson, Map.class);
        String state = (String)rtMap.get("state");
        if (success.equals(state)) {
            Map data = (Map)rtMap.get("data");
            boolean success = (Boolean)data.get("success");
            if (success) {
                String app_token = (String)data.get("app_token");
                return app_token;
            }
            throw new BOSException("\u63a5\u53e3\u6267\u884c\u5931\u8d25\uff01\u8fd4\u56de\u5185\u5bb9\uff1a" + rtJson);
        }
        throw new BOSException("\u63a5\u53e3\u8fd4\u56de\u5931\u8d25\uff01\u8fd4\u56de\u5185\u5bb9\uff1a" + rtJson);
    }

    public static String getaccessToken() throws Exception {
        String url = IERP_URL + login;
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("user", user);
        String appToken = EasCloud.getAppToken();
        body.put("apptoken", appToken);
        String rtJson = HttpUtils.postJson(url, new Gson().toJson(body));
        Map rtMap = (Map)new Gson().fromJson(rtJson, Map.class);
        String state = (String)rtMap.get("state");
        if (success.equals(state)) {
            Map data = (Map)rtMap.get("data");
            boolean success = (Boolean)data.get("success");
            if (success) {
                String app_token = (String)data.get("access_token");
                return app_token;
            }
            throw new BOSException("\u63a5\u53e3\u6267\u884c\u5931\u8d25\uff01\u8fd4\u56de\u5185\u5bb9\uff1a" + rtJson);
        }
        throw new BOSException("\u63a5\u53e3\u8fd4\u56de\u5931\u8d25\uff01\u8fd4\u56de\u5185\u5bb9\uff1a" + rtJson);
    }

    public static String getLicenseData(String code, String instanceId, String type, String prodouctId) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("appId", appId);
        headers.put("accessToken", EasCloud.getaccessToken());
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("code", code);
        body.put("type", type);
        body.put("prodouctId", prodouctId);
        String rtJson = HttpUtils.postJson(KBC_URL, new Gson().toJson(body), headers);
        Map rtMap = (Map)new GsonBuilder().disableHtmlEscaping().create().fromJson(rtJson, Map.class);
        boolean success = (Boolean)rtMap.get("success");
        if (success) {
            Map data = (Map)rtMap.get("data");
            data.put("licSrcType", "1");
            return new GsonBuilder().disableHtmlEscaping().create().toJson((Object)data);
        }
        throw new BOSException("\u63a5\u53e3\u8fd4\u56de\u5931\u8d25\uff01\u8fd4\u56de\u5185\u5bb9\uff1a" + rtJson);
    }

    private static String getMember(String resultStr) {
        Map resultMap = SynShrUserToCloudUtils.paraseExecResult((String)resultStr);
        Map data = (Map)resultMap.get("data");
        Object member = data.get("member");
        if (member != null) {
            return member.toString();
        }
        return "";
    }

    public static String getRegistorUsers(String prod_inst_code) throws Exception {
        String buildUrl = KBC_LICENE_BUILD_URL + "?prod_inst_code=" + prod_inst_code + "&client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET;
        String processUrl = KBC_LICENSE_PROCESSS_URL + "?prod_inst_code=" + prod_inst_code + "&client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET + "&job_id=";
        EasCloud.prepareMostNewLicenseData(prod_inst_code, buildUrl, processUrl);
        String registorUsersUrl = GROUP_MEMBER_URL + "?prod_inst_code=" + prod_inst_code + "&client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET;
        String responseBody = EasCloud.httpClient(registorUsersUrl);
        if (0 == EasCloud.getCode(responseBody)) {
            return EasCloud.getMember(responseBody);
        }
        logger.error((Object)("\u83b7\u53d6\u6ce8\u518c\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0curl:" + registorUsersUrl + ",rs:" + responseBody));
        return null;
    }

    static {
        try {
            EASCloudEnv easCloudEnv = EASCloudEnv.getInstance(true);
            EasCloud.changeCloudEnv(easCloudEnv.isUseTest(), easCloudEnv.isRequireHttps());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static class ResultDataJsonBeanDeserializer
    implements JsonDeserializer<String> {
        public String deserialize(JsonElement paramJsonElement, Type paramType, JsonDeserializationContext paramJsonDeserializationContext) throws JsonParseException {
            JsonObject root = paramJsonElement.getAsJsonObject();
            String data = root.get("data").toString();
            return data;
        }
    }
}

