/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.app.AbstractCloudHubFacadeControllerBean;
import com.kingdee.eas.base.uiframe.utils.EncryptUtils;
import com.kingdee.eas.base.uiframe.utils.XTServiceConfig;
import com.kingdee.eas.base.uiframe.utils.XunTongHelper;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.XtCommunicateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.log4j.Logger;

public class CloudHubFacadeControllerBean
extends AbstractCloudHubFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.uiframe.app.CloudHubFacadeControllerBean");
    private static final String resClassname = "com.kingdee.eas.base.uiframe.CloudHubResource";

    @Override
    protected List _getCurrentCloudHubURI(Context ctx) throws BOSException, EASBizException {
        String eid = "";
        Key key = null;
        ArrayList<Object> messageList = new ArrayList<Object>();
        try {
            UserInfo user;
            String dataCenterId = ctx.getAIS();
            eid = this.getEid(dataCenterId, ctx);
            if (StringUtils.isEmpty((String)eid)) {
                eid = "480820";
            }
            if ((user = ContextUtil.getCurrentUserInfo((Context)ctx)) == null) {
                messageList.add(false);
                messageList.add(EASCommonResource.getString((String)resClassname, (String)"getCurrentUserFail", (Locale)ctx.getLocale()));
                return messageList;
            }
            String openId = XunTongHelper.getOpenIdByUserId(ctx, user.getId().toString());
            HashMap<String, String> infoMap = new HashMap<String, String>();
            infoMap.put("dataCenterId", dataCenterId);
            infoMap.put("eid", eid);
            infoMap.put("openId", openId);
            logger.error((Object)((Object)infoMap).toString());
            if (!StringUtils.isEmpty((String)eid) && !StringUtils.isEmpty((String)openId)) {
                if (key == null) {
                    try {
                        key = this.getKeyFromXtSync(eid, ctx);
                        if (key == null) {
                            byte[] keyByte = EncryptUtils.getBytesFromFile(System.getProperty("eas.properties.dir") + "/" + eid + ".key");
                            key = EncryptUtils.restorePrivateKey(keyByte);
                        }
                    }
                    catch (FileNotFoundException e) {
                        logger.error((Object)e);
                        key = null;
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                        key = null;
                    }
                    catch (InvalidKeySpecException e) {
                        logger.error((Object)e);
                        key = null;
                    }
                }
                String data = eid + "|" + openId + "|" + new Date().getTime();
                logger.error((Object)("data to sign:" + data));
                if (key == null) {
                    messageList.add(false);
                    messageList.add(EASCommonResource.getString((String)resClassname, (String)"canNotFindKey", (Locale)ctx.getLocale()));
                    return messageList;
                }
                String token = EncryptUtils.encryptWithEncodeBase64UTF8(data, key);
                String url = XunTongHelper.getXunTongUrlFromEas(eid, openId, token);
                logger.error((Object)("url==========:" + url));
                messageList.add(true);
                messageList.add(new URI(url));
                return messageList;
            }
            if (StringUtils.isEmpty((String)eid)) {
                messageList.add(false);
                messageList.add(EASCommonResource.getString((String)resClassname, (String)"errorEID", (Locale)ctx.getLocale()));
                return messageList;
            }
            messageList.add(false);
            messageList.add(EASCommonResource.getString((String)resClassname, (String)"currentUserHasNotXtUser", (Locale)ctx.getLocale()));
            return messageList;
        }
        catch (InvalidKeyException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (BadPaddingException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (URISyntaxException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private Key getKeyFromXtSync(String eid, Context ctx) {
        try {
            return XtCommunicateUtil.getInstance((Context)ctx).getKeyByEid(eid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getEid(String dataCenterId, Context ctx) {
        String eid = EasXtSyncUtil.getInstance((Context)ctx).getEid();
        if (this.isEmpty(eid)) {
            eid = XTServiceConfig.getInstance().getEidByDbCode(dataCenterId);
        }
        return eid;
    }

    private boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }
}

