/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.EASCloudEnum;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.myeas.ComMenuFunctionCollection;
import com.kingdee.eas.base.myeas.ComMenuFunctionFactory;
import com.kingdee.eas.base.myeas.ComMenuFunctionInfo;
import com.kingdee.eas.base.myeas.IComMenuFunction;
import com.kingdee.eas.base.myeas.PageTypeEnum;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.service.FunctionPermissionService;
import com.kingdee.eas.base.uiframe.LicenseType;
import com.kingdee.eas.base.uiframe.MenuCacheFactory;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.app.AbstractMyComFunctionFacadeControllerBean;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MyComFunctionFacadeControllerBean
extends AbstractMyComFunctionFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.uiframe.app.MyComFunctionFacadeControllerBean");

    @Override
    protected IObjectCollection _getComFunction(Context ctx, String parentId) throws BOSException, EASBizException {
        Object[] params = new Object[]{parentId};
        String sql = this.getQuerySql(ctx, "A.FPARENTID = ?");
        return this.getComFunctionByQuerySql(ctx, sql, params);
    }

    private String getQuerySql(Context ctx, String where) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT A.FID AS FID, A.FMENUFUNCTIONID AS FMENUFUNCTIONID,A.FPARENTID AS FPARENTID,");
        sql.append(" A.FNAME_L1 COMFNAME_L1,A.FNAME_L2 COMFNAME_L2,A.FNAME_L3 COMFNAME_L3, ");
        sql.append(" B.FNAME_L1 MENUFNAME_L1,B.FNAME_L2 MENUFNAME_L2,B.FNAME_L3 MENUFNAME_L3, ");
        sql.append(" A.FISLEAF AS FISLEAF, ");
        sql.append(" A.FNUMBER AS FNUMBER,A.FLONGNUMBER AS FLONGNUMBER, A.FLEVEL AS FLEVEL, ");
        sql.append(" A.FDIR AS FDIR, A.FORDER AS FORDER, B.FOPENMETHOD AS FOPENMETHOD, ");
        sql.append(" B.FUICLASSNAME AS FUICLASSNAME, ");
        sql.append("B.FENABLED AS FENABLED, B.FUICLASSPARAM AS FUICLASSPARAM ");
        sql.append(",B.FUIOPRT as FUIOPRT");
        sql.append(",B.FImagePath as FImagePath");
        sql.append(" FROM T_BAS_COMFUNCTION A  LEFT JOIN T_PM_MAINMENUITEM B ");
        sql.append(" ON A.FMENUFUNCTIONID = B.FID where  A.FPageType = 'EXTERNAL_LINK_G' and " + where + " and (exists (select 1 from ");
        sql.append("(");
        String permissionSql = new FunctionPermissionService(ctx).getFunctionPermissionsByMenu();
        sql.append(permissionSql.replaceAll("distinct", ""));
        sql.append(") userperm where userperm.fpermitemid=B.FFUNCTION )");
        sql.append(" OR B.FFUNCTION is null or B.FFUNCTION='')");
        sql.append(" and (A.FMENUFUNCTIONID = B.FID OR A.FDIR=1) ");
        try {
            EASCloudEnum easCloudEnum = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getRemoteEASCloudVersion();
            LicenseType licenseTypeVisiable = null;
            LicenseType licenseTypeMop = null;
            if (easCloudEnum != null) {
                if (EASCloudEnum.CLOUD_PUBLIC.toString().equalsIgnoreCase(easCloudEnum.toString()) || EASCloudEnum.CLOUD_PUBLIC_SIMPLE.toString().equalsIgnoreCase(easCloudEnum.toString())) {
                    licenseTypeVisiable = LicenseType.PublicCloudVisible;
                    licenseTypeMop = LicenseType.PublicCloudMonopolize;
                } else if (EASCloudEnum.CLOUD_PRIVATE.toString().equalsIgnoreCase(easCloudEnum.toString())) {
                    licenseTypeVisiable = LicenseType.PrivateCloudVisible;
                    licenseTypeMop = LicenseType.PrivateCloudMonopolize;
                } else if (EASCloudEnum.CLOUD_HYBRID.toString().equalsIgnoreCase(easCloudEnum.toString()) || EASCloudEnum.CLOUD_HYBRID_SIMPLE.toString().equalsIgnoreCase(easCloudEnum.toString())) {
                    licenseTypeVisiable = LicenseType.HyBridCloudVisible;
                    licenseTypeMop = LicenseType.HyBridCloudMonopolize;
                }
                sql.append(" and (B.FLicenseType =").append(0);
                if (licenseTypeMop != null) {
                    sql.append(" or B.FLicenseType =").append(licenseTypeMop.getValue());
                }
                if (licenseTypeVisiable != null) {
                    sql.append(" or B.FLicenseType >=").append(licenseTypeVisiable.getValue());
                }
                sql.append(" or B.FLicenseType is null ").append(")");
            }
        }
        catch (LicenseException e) {
            throw new BOSException((Throwable)e);
        }
        sql.append(" ORDER BY A.FLEVEL,A.FORDER");
        return sql.toString();
    }

    private IObjectCollection getComFunctionByQuerySql(Context ctx, String sql, Object[] params) throws BOSException {
        String local = ctx.getLocale().toString().toUpperCase();
        Locale l1 = new Locale("L1");
        Locale l2 = new Locale("L2");
        Locale l3 = new Locale("L3");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        logger.info((Object)("--" + sql.toString() + "--"));
        ComMenuFunctionCollection objColl = new ComMenuFunctionCollection();
        try {
            while (rowSet.next()) {
                ComMenuFunctionInfo nodeData = new ComMenuFunctionInfo();
                MainMenuItemInfo menuItem = new MainMenuItemInfo();
                menuItem.setId(BOSUuid.read((String)rowSet.getString("FMENUFUNCTIONID")));
                menuItem.setUiClassName(rowSet.getString("FUICLASSNAME"));
                menuItem.setOpenMethod(OpenMethod.getEnum(rowSet.getInt("FOPENMETHOD")));
                menuItem.setUiClassParam(rowSet.getString("FUICLASSPARAM"));
                menuItem.setUiOprt(rowSet.getString("FUIOPRT"));
                menuItem.setName(rowSet.getString("MENUFNAME_L1"), l1);
                menuItem.setName(rowSet.getString("MENUFNAME_L2"), l2);
                menuItem.setName(rowSet.getString("MENUFNAME_L3"), l3);
                menuItem.setImagePath(rowSet.getString("FImagePath"));
                menuItem.setEnabled(rowSet.getBoolean("FENABLED"));
                int order = rowSet.getInt("FORDER");
                nodeData.setId(BOSUuid.read((String)rowSet.getString("FID")));
                nodeData.setIsLeaf(rowSet.getInt("FISLEAF") != 0);
                nodeData.setDir(rowSet.getBoolean("FDIR"));
                nodeData.setLevel(rowSet.getInt("FLEVEL"));
                nodeData.setLongNumber(rowSet.getString("FLONGNUMBER"));
                if (StringUtils.isEmpty((String)rowSet.getString("FPARENTID"))) {
                    nodeData.setParent(null);
                } else {
                    ComMenuFunctionInfo parent = new ComMenuFunctionInfo();
                    parent.setId(BOSUuid.read((String)rowSet.getString("FPARENTID")));
                    nodeData.setParent(parent);
                }
                nodeData.setNumber(rowSet.getString("FNUMBER"));
                if (!nodeData.isDir()) {
                    nodeData.setName(menuItem.getName(l1), l1);
                    nodeData.setName(menuItem.getName(l2), l2);
                    nodeData.setName(menuItem.getName(l3), l3);
                } else {
                    nodeData.setName(rowSet.getString("COMFNAME_L1"), l1);
                    nodeData.setName(rowSet.getString("COMFNAME_L2"), l2);
                    nodeData.setName(rowSet.getString("COMFNAME_L3"), l3);
                }
                nodeData.setOrder(order < 0 ? 0 : order);
                nodeData.setMenuFunction(menuItem);
                objColl.addObject((IObjectValue)nodeData);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ComMenuFunctionCollection test = this.filterExtReport(ctx, objColl);
        return test;
    }

    @Override
    protected IObjectCollection _getFirstComFunction(Context ctx) throws BOSException, EASBizException {
        return this.getComFunction(ctx, this.getFunctionRoot(ctx).getId().toString());
    }

    @Override
    protected int _getChildMaxOrder(Context ctx, String parentId) throws BOSException, EASBizException {
        Object[] params = new Object[]{parentId};
        String querySql = "SELECT MAX(FORDER)  FROM  T_BAS_COMFUNCTION WHERE FPARENTID =?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])params);
        try {
            if (rs.next()) {
                return rs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            return 0;
        }
        return 0;
    }

    @Override
    protected void _storeNewFunctionOrder(Context ctx, IObjectCollection comFunctionColl) throws BOSException, EASBizException {
        if (comFunctionColl == null || comFunctionColl.size() == 0) {
            return;
        }
        String updateSql = "update t_bas_comFunction set Forder = ? where FId = ?";
        ComMenuFunctionCollection coll = (ComMenuFunctionCollection)comFunctionColl;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (int i = 0; i < coll.size(); ++i) {
            ComMenuFunctionInfo tmp = coll.get(i);
            Object[] o = new Object[]{tmp.getOrder(), tmp.getId().toString()};
            list.add(o);
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSql, list);
        MenuCacheFactory.getLocalInstance(ctx).updateComMenuCacheByUserId(StringUtils.cnulls((Object)ctx.getCaller()));
    }

    @Override
    protected int _getChildCount(Context ctx, String parentId) throws BOSException, EASBizException {
        Object[] params = new Object[]{parentId};
        String querySql = "SELECT COUNT(*)  FROM  T_BAS_COMFUNCTION WHERE FPARENTID =?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])params);
        try {
            if (rs.next()) {
                return rs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            return 0;
        }
        return 0;
    }

    @Override
    protected void _deleteFunction(Context ctx, String filterInfo) throws BOSException, EASBizException {
        String sql = "delete from t_bas_ComFunction where " + filterInfo;
        DbUtil.execute((Context)ctx, (String)sql);
        MenuCacheFactory.getLocalInstance(ctx).updateComMenuCacheByUserId(StringUtils.cnulls((Object)ctx.getCaller()));
    }

    private ComMenuFunctionCollection filterExtReport(Context ctx, ComMenuFunctionCollection objColl) {
        List reptlist = null;
        for (int i = 1; i < objColl.size(); ++i) {
            ComMenuFunctionInfo comMenu = (ComMenuFunctionInfo)objColl.getObject(i);
            String uiclassname1 = "com.kingdee.eas.rpts.ctrlreport.client.ExtReportRunUI";
            String uiclassname2 = "com.kingdee.eas.rpts.ctrlreport.client.ReportRunTimeUI";
            boolean isextreport = false;
            if (comMenu.getMenuFunction().getUiClassName() != null && comMenu.getMenuFunction().getUiClassName().length() > 0 && (comMenu.getMenuFunction().getUiClassName().equals(uiclassname1) || comMenu.getMenuFunction().getUiClassName().equals(uiclassname2))) {
                isextreport = true;
            }
            if (!isextreport) continue;
            if (reptlist == null) {
                reptlist = UIFrameUtils.getPermissionReportMenuids(ctx);
            }
            if (!reptlist.isEmpty() && !reptlist.contains(comMenu.getMenuFunction().getId()) && reptlist.contains(comMenu.getMenuFunction().getId().toString())) continue;
        }
        return objColl;
    }

    @Override
    protected IObjectValue _getFunctionRoot(Context ctx) throws BOSException, EASBizException {
        String currUserID = ctx.getCaller().toString();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("parent is null"));
        fi.getFilterItems().add(new FilterItemInfo("user", (Object)currUserID));
        fi.getFilterItems().add(new FilterItemInfo("pagetype", (Object)"EXTERNAL_LINK_G"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("level");
        sic.add("longNumber");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(fi);
        view.setSelector(sic);
        ComMenuFunctionInfo root = ComMenuFunctionFactory.getLocalInstance((Context)ctx).getComMenuFunctionCollection(view).get(0);
        if (root == null) {
            ComMenuFunctionInfo rootData = new ComMenuFunctionInfo();
            MainMenuItemInfo virtualMenu = new MainMenuItemInfo();
            virtualMenu.setId(BOSUuid.create((BOSObjectType)virtualMenu.getBOSType()));
            rootData.setMenuFunction(virtualMenu);
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(currUserID));
            rootData.setUser(userInfo);
            rootData.setNumber("root" + userInfo.getNumber());
            rootData.setLongNumber(rootData.getNumber());
            rootData.setName("virtual root");
            rootData.setDir(true);
            rootData.setIsLeaf(false);
            rootData.setLevel(1);
            rootData.setOrder(0);
            rootData.setParent(null);
            rootData.setPageType(PageTypeEnum.EXTERNAL_LINK_G);
            rootData.setFavextinfo(null);
            IComMenuFunction iComMenuFunction = ComMenuFunctionFactory.getLocalInstance((Context)ctx);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("user", (Object)currUserID));
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)rootData.getNumber()));
            iComMenuFunction.addnew(rootData);
            return rootData;
        }
        return root;
    }

    @Override
    protected Map _getAllComFunction(Context ctx) throws BOSException, EASBizException {
        ComMenuFunctionInfo root = this.getFunctionRoot(ctx);
        IObjectCollection objectColl = this.getAllComFunctionByQuerySql(ctx, root.getLongNumber());
        if (objectColl instanceof ComMenuFunctionCollection) {
            HashMap<String, ComMenuFunctionCollection> comFunctionMap = new HashMap<String, ComMenuFunctionCollection>();
            ComMenuFunctionCollection functionColl = (ComMenuFunctionCollection)objectColl;
            if (functionColl != null && functionColl.size() > 0) {
                ComMenuFunctionInfo tmpInfo;
                int i;
                ComMenuFunctionCollection level1Coll = new ComMenuFunctionCollection();
                ComMenuFunctionCollection level2Coll = new ComMenuFunctionCollection();
                for (i = 0; i < functionColl.size(); ++i) {
                    tmpInfo = functionColl.get(i);
                    if (tmpInfo.getLevel() == 2) {
                        level1Coll.add(tmpInfo);
                        continue;
                    }
                    if (tmpInfo.getLevel() != 3) continue;
                    level2Coll.add(tmpInfo);
                }
                comFunctionMap.put(root.getId().toString(), level1Coll);
                for (i = 0; i < level2Coll.size(); ++i) {
                    tmpInfo = level2Coll.get(i);
                    if (tmpInfo.getParent() == null) continue;
                    if (comFunctionMap.containsKey(tmpInfo.getParent().getId().toString())) {
                        ((ComMenuFunctionCollection)comFunctionMap.get(tmpInfo.getParent().getId().toString())).add(tmpInfo);
                        continue;
                    }
                    ComMenuFunctionCollection tmpColl = new ComMenuFunctionCollection();
                    tmpColl.add(tmpInfo);
                    comFunctionMap.put(tmpInfo.getParent().getId().toString(), tmpColl);
                }
            }
            return comFunctionMap;
        }
        return new HashMap();
    }

    private IObjectCollection getAllComFunctionByQuerySql(Context ctx, String longNumber) throws EASBizException, BOSException {
        Object[] params = new Object[]{longNumber, longNumber + "!%"};
        String sql = this.getQuerySql(ctx, "(A.FLONGNUMBER = ?  or  A.FLONGNUMBER like ?)");
        return this.getComFunctionByQuerySql(ctx, sql, params);
    }

    @Override
    protected byte[] _getPersonPhoto(Context ctx, String userId) throws BOSException, EASBizException {
        boolean isStartSHR = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).isStartSHR();
        String sql = null;
        sql = isStartSHR ? "select fimagedata from t_hr_personphoto where fpersonid = (select fpersonid from t_pm_user where fid ='" + userId + "')" : "select FContent from T_JP_PubFile where FFileType = 'USER_LOGO' and FCreator = '" + ctx.getUserName() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        Blob blob = null;
        try {
            if (rs.next()) {
                blob = isStartSHR ? rs.getBlob("fimagedata") : rs.getBlob("FContent");
            }
            if (blob != null && blob.length() > 0L) {
                byte[] photo = blob.getBytes(new Long(1L), Integer.parseInt(String.valueOf(blob.length())));
                return photo;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return null;
    }
}

