/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.utils;

import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.BizTypeEnum;
import com.kingdee.eas.base.uiframe.IndustryEnum;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.SysMenuItemInfo;
import com.kingdee.eas.base.uiframe.utils.CustMenuAutoUpdateForDB;
import com.kingdee.eas.base.uiframe.utils.DbTransactionUtil;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CustMenuAutoUpdateForJDBC {
    Logger logger = Logger.getLogger((String)CustMenuAutoUpdateForJDBC.class.toString());
    private static final Locale[] locales = new Locale[]{new Locale("L1"), new Locale("L2"), new Locale("L3")};
    private String jnlpPath = null;

    private String getIndustrySql(String industryType) {
        String[] industryArray = industryType.split(";");
        StringBuffer bf = new StringBuffer();
        if (industryArray != null && industryArray.length >= 1) {
            for (int i = 0; i < industryArray.length; ++i) {
                if (i > 0) {
                    bf.append(" or ");
                }
                if (industryArray[i].equals("0")) {
                    bf.append("(FIndustry = 0 )");
                    continue;
                }
                bf.append("((");
                bf.append(" FIndustry=");
                bf.append(industryArray[i]);
                bf.append(")");
                bf.append("or");
                bf.append("(FIndustry=0 and ( FNoSuit not like '%");
                bf.append(industryArray[i]);
                bf.append("%'");
                bf.append(" or FNoSuit is null )))");
            }
        }
        return bf.toString();
    }

    private String getIndustryByParamSql(String industryType, String p) {
        String[] industryArray = industryType.split(";");
        StringBuffer bf = new StringBuffer();
        if (industryArray != null && industryArray.length >= 1) {
            for (int i = 0; i < industryArray.length; ++i) {
                if (i > 0) {
                    bf.append(" or ");
                }
                if (industryArray[i].equals("0")) {
                    bf.append("(");
                    bf.append(p);
                    bf.append(".FIndustry = 0 )");
                    continue;
                }
                bf.append("(( ");
                bf.append(p);
                bf.append(".FIndustry=");
                bf.append(industryArray[i]);
                bf.append(")");
                bf.append("or");
                bf.append("(");
                bf.append(p);
                bf.append(".FIndustry=0 and ( ");
                bf.append(p);
                bf.append(".FNoSuit not like '%");
                bf.append(industryArray[i]);
                bf.append("%'");
                bf.append(" or ");
                bf.append(p);
                bf.append(".FNoSuit is null )))");
            }
        }
        return bf.toString();
    }

    public void importAllSysMenu(Connection conn, int dbType) throws Exception {
        boolean status = false;
        try {
            conn.setAutoCommit(true);
            this.logger.info((Object)"Now import All SysMenu without industry starting...");
            String delSql = "delete from T_PM_MainMenuItem";
            conn.createStatement().execute(delSql);
            String insertSql = "insert T_PM_MainMenuItem(FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FName_L1,FName_L2,FName_L3,FNumber,FDescription_L1,FDescription_L2,FDescription_L3,FSimpleName,FIsLeaf,FLevel,FLongNumber,FDisplayName_L1,FDisplayName_L2,FDisplayName_L3,FOrder,FImagePath,FVisible,FEnabled,FUiClassName,FUiClassParam,FUiOprt,FOpenMethod,FShortcutCode,FIsReport,FParent,FFunction,FIndustry,FNoSuit,FSysMenuID,FMenutype,FLicenseType)";
            insertSql = insertSql + " select FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FName_L1,FName_L2,FName_L3,FNumber,FDescription_L1,FDescription_L2,FDescription_L3,FSimpleName,FIsLeaf,FLevel,FLongNumber,FDisplayName_L1,FDisplayName_L2,FDisplayName_L3,FOrder,FImagePath,FVisible,FEnabled,FUiClassName,FUiClassParam,FUiOprt,FOpenMethod,FShortcutCode,FIsReport,FParent,FFunction,FIndustry,FNoSuit,FID,FMenutype,FLicenseType from T_BAS_SysMenuItem";
            conn.createStatement().execute(insertSql);
            status = true;
            this.updateComMenuCach(conn);
            this.updateMenuCache(conn);
            this.updateNoMenuStatus(conn);
        }
        catch (SQLException e) {
            this.logger.error((Object)"auto update error: ", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"auto update error: ", (Throwable)e);
            }
        }
    }

    public void importAllSysMenu(Connection conn, int dbType, String industryType) throws Exception {
        boolean status = false;
        try {
            conn.setAutoCommit(true);
            this.logger.info((Object)("Now import All SysMenu with industry " + industryType + " starting..."));
            String delSql = "delete from T_PM_MainMenuItem";
            conn.createStatement().execute(delSql);
            String insertSql = "insert T_PM_MainMenuItem(FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FName_L1,FName_L2,FName_L3,FNumber,FDescription_L1,FDescription_L2,FDescription_L3,FSimpleName,FIsLeaf,FLevel,FLongNumber,FDisplayName_L1,FDisplayName_L2,FDisplayName_L3,FOrder,FImagePath,FVisible,FEnabled,FUiClassName,FUiClassParam,FUiOprt,FOpenMethod,FShortcutCode,FIsReport,FParent,FFunction,FIndustry,FNoSuit,FSysMenuID,FMenutype,FLicenseType)";
            insertSql = insertSql + " select FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FName_L1,FName_L2,FName_L3,FNumber,FDescription_L1,FDescription_L2,FDescription_L3,FSimpleName,FIsLeaf,FLevel,FLongNumber,FDisplayName_L1,FDisplayName_L2,FDisplayName_L3,FOrder,FImagePath,FVisible,FEnabled,FUiClassName,FUiClassParam,FUiOprt,FOpenMethod,FShortcutCode,FIsReport,FParent,FFunction,FIndustry,FNoSuit,FID,FMenutype,FLicenseType from T_BAS_SysMenuItem where" + this.getIndustrySql(industryType);
            conn.createStatement().execute(insertSql);
            status = true;
            this.updateComMenuCach(conn);
            this.updateMenuCache(conn);
            this.updateMenuStatus(conn, industryType);
        }
        catch (SQLException e) {
            this.logger.error((Object)"auto update error: ", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"auto update error: ", (Throwable)e);
            }
        }
    }

    public boolean importSysMenu(Connection conn, int dbType) throws Exception {
        boolean status = false;
        try {
            List menuList;
            conn.setAutoCommit(true);
            this.logger.debug((Object)"auto update customer menu statring...");
            String updateSql = "update T_PM_MainMenuItem set (FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FName_L1,FName_L2,FName_L3,FNumber,FDescription_L1,FDescription_L2,FDescription_L3,FSimpleName,FIsLeaf,FLevel,FLongNumber,FDisplayName_L1,FDisplayName_L2,FDisplayName_L3,FOrder,FImagePath,FVisible,FEnabled,FUiClassName,FUiClassParam,FUiOprt,FOpenMethod,FShortcutCode,FIsReport,FParent,FFunction,FIndustry,FNoSuit,FMenutype) = (select t.FCreatorID,t.FCreateTime,t.FLastUpdateUserID,t.FLastUpdateTime,t.FControlUnitID,t.FName_L1,t.FName_L2,t.FName_L3,t.FNumber,t.FDescription_L1,t.FDescription_L2,t.FDescription_L3,t.FSimpleName,t.FIsLeaf,t.FLevel,t.FLongNumber,t.FDisplayName_L1,t.FDisplayName_L2,t.FDisplayName_L3,t.FOrder,t.FImagePath,t.FVisible,t.FEnabled,t.FUiClassName,t.FUiClassParam,t.FUiOprt,t.FOpenMethod,t.FShortcutCode,t.FIsReport,t.FParent,t.FFunction,t.FIndustry,t.FNoSuit,t.FMenutype from T_BAS_SysMenuItem t where FSysMenuID = t.FID)";
            conn.createStatement().execute(updateSql);
            String selectSql = "select FID,FLongNumber from T_PM_MainMenuItem where FID not in(select t.FID from T_PM_MainMenuItem t,T_BAS_SysMenuItem t1 where t.FSysMenuID = t1.FID) and FSysMenuID is not NULL order by FLongNumber,FOrder";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            ArrayList<String> idList = null;
            ArrayList<String> lNumList = null;
            if (null != rs) {
                idList = new ArrayList<String>();
                lNumList = new ArrayList<String>();
                while (rs.next()) {
                    idList.add(rs.getString("FID"));
                    lNumList.add(rs.getString("FLongNumber"));
                }
            }
            Statement preStmt = null;
            if (null != idList && idList.size() > 0) {
                String getSubCntSql = "select count(1) as subCnt from T_PM_MainMenuItem where FLongNUmber like ?";
                String updateRelationSql = "update T_PM_MainMenuItem set FSysMenuID = NULL where FID = ?";
                String getParentIDSql = "select FParent from T_PM_MainMenuItem where FID = ?";
                String getNodeNumSql = "select count(FID) as nodeCnt from T_PM_MainMenuItem where FParent = ?";
                String delNodeSql = "delete from T_PM_MainMenuItem where FID = ?";
                String updateParentSql = "update T_PM_MainMenuItem set FIsLeaf = 1 where FID = ?";
                preStmt = conn.prepareStatement(getSubCntSql);
                PreparedStatement tempPreStmt = null;
                ResultSet tempRs = null;
                int subCnt = 0;
                int j = idList.size();
                for (int i = 0; i < j; ++i) {
                    preStmt.setString(1, (String)lNumList.get(i) + "!%");
                    rs = preStmt.executeQuery();
                    if (null != rs && rs.next()) {
                        subCnt = rs.getInt("subCnt");
                    }
                    if (subCnt > 0) {
                        tempPreStmt = conn.prepareStatement(updateRelationSql);
                        tempPreStmt.setString(1, (String)idList.get(i));
                        tempPreStmt.execute();
                        continue;
                    }
                    tempPreStmt = conn.prepareStatement(getParentIDSql);
                    tempPreStmt.setString(1, (String)idList.get(i));
                    tempRs = tempPreStmt.executeQuery();
                    String parentID = null;
                    if (null != tempRs && tempRs.next()) {
                        parentID = tempRs.getString("FParent");
                    }
                    int size = 0;
                    tempPreStmt = conn.prepareStatement(getNodeNumSql);
                    tempPreStmt.setString(1, parentID);
                    tempRs = tempPreStmt.executeQuery();
                    if (null != tempRs && tempRs.next()) {
                        size = tempRs.getInt("nodeCnt");
                    }
                    tempPreStmt = conn.prepareStatement(delNodeSql);
                    tempPreStmt.setString(1, (String)idList.get(i));
                    tempPreStmt.execute();
                    if (size > 1 || StringUtils.isEmpty((String)parentID) || parentID.trim().length() <= 0) continue;
                    tempPreStmt = conn.prepareStatement(updateParentSql);
                    tempPreStmt.setString(1, parentID);
                    tempPreStmt.execute();
                }
            }
            String newMenuSelectSql = "select * from T_BAS_SysMenuItem where FID not in(select t.FID from T_BAS_SysMenuItem t,T_PM_MainMenuItem t1 where t.FID = t1.FSysMenuID) and fid not in (select fid from T_PM_MainMenuItem ) order by FLongNumber,FOrder";
            rs = conn.createStatement().executeQuery(newMenuSelectSql);
            if (null != rs && (menuList = this.getAllUnImportedMenu(rs)).size() > 0) {
                String number = null;
                String shortcutCode = null;
                SysMenuItemInfo sysMenuInfo = null;
                MainMenuItemInfo parentMenu = null;
                MainMenuItemInfo newMenu = null;
                int j = menuList.size();
                for (int i = 0; i < j; ++i) {
                    sysMenuInfo = (SysMenuItemInfo)menuList.get(i);
                    number = sysMenuInfo.getNumber();
                    shortcutCode = sysMenuInfo.getShortcutCode();
                    if (this.isNumberRepeated(conn, number)) {
                        this.logger.debug((Object)(UIFrameUtils.getRes("res_74") + "[" + sysMenuInfo.getDisplayName() + "]" + UIFrameUtils.getRes("res_75")));
                        continue;
                    }
                    if (this.isShortcutCodeRepeated(conn, shortcutCode)) {
                        this.logger.debug((Object)(UIFrameUtils.getRes("res_74") + "[" + sysMenuInfo.getDisplayName() + "]" + UIFrameUtils.getRes("res_76")));
                        continue;
                    }
                    String parentId = null;
                    if (sysMenuInfo.getParent() != null) {
                        parentId = sysMenuInfo.getParent().getId().toString();
                        parentMenu = this.findImportedParent(conn, parentId);
                        newMenu = this.sysInfo2CustInfo(sysMenuInfo, parentMenu);
                        this.addNewMenu(conn, newMenu);
                        continue;
                    }
                    newMenu = this.sysInfo2CustInfo(sysMenuInfo, null);
                    this.addNewMenu(conn, newMenu);
                }
            }
            if (preStmt != null) {
                preStmt.close();
            }
            status = true;
            this.updateComMenuCach(conn);
            this.updateMenuCache(conn);
            this.updateNoMenuStatus(conn);
            boolean bl = status;
            return bl;
        }
        catch (Exception ex) {
            this.logger.error((Object)"auto update error: ", (Throwable)ex);
            throw new Exception(ex);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"auto update error: ", (Throwable)e);
            }
        }
    }

    private String getDeleteIndustrySql(String industryType) {
        StringBuffer bf = new StringBuffer();
        bf.append(" or ( FID not in(select FID from T_PM_MainMenuItem where " + this.getIndustrySql(industryType) + "))");
        return bf.toString();
    }

    public boolean importSysMenu(Connection conn, int dbType, String industryType) throws Exception {
        boolean status = false;
        try {
            List menuList;
            conn.setAutoCommit(true);
            this.logger.debug((Object)"auto update customer menu statring...");
            String updateSql = "update T_PM_MainMenuItem set (FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FName_L1,FName_L2,FName_L3,FNumber,FDescription_L1,FDescription_L2,FDescription_L3,FSimpleName,FIsLeaf,FLevel,FLongNumber,FDisplayName_L1,FDisplayName_L2,FDisplayName_L3,FOrder,FImagePath,FVisible,FEnabled,FUiClassName,FUiClassParam,FUiOprt,FOpenMethod,FShortcutCode,FIsReport,FParent,FFunction,FIndustry,FNoSuit,FMenutype) = (select t.FCreatorID,t.FCreateTime,t.FLastUpdateUserID,t.FLastUpdateTime,t.FControlUnitID,t.FName_L1,t.FName_L2,t.FName_L3,t.FNumber,t.FDescription_L1,t.FDescription_L2,t.FDescription_L3,t.FSimpleName,t.FIsLeaf,t.FLevel,t.FLongNumber,t.FDisplayName_L1,t.FDisplayName_L2,t.FDisplayName_L3,t.FOrder,t.FImagePath,t.FVisible,t.FEnabled,t.FUiClassName,t.FUiClassParam,t.FUiOprt,t.FOpenMethod,t.FShortcutCode,t.FIsReport,t.FParent,t.FFunction,t.FIndustry,t.FNoSuit,t.FMenutype from T_BAS_SysMenuItem t where FSysMenuID = t.FID)";
            conn.createStatement().execute(updateSql);
            String selectSql = "select FID,FLongNumber from T_PM_MainMenuItem where (FID not in(select t.FID from T_PM_MainMenuItem t,T_BAS_SysMenuItem t1 where t.FSysMenuID = t1.FID) and FSysMenuID is not NULL ) " + this.getDeleteIndustrySql(industryType) + " order by FLongNumber,FOrder";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            ArrayList<String> idList = null;
            ArrayList<String> lNumList = null;
            if (null != rs) {
                idList = new ArrayList<String>();
                lNumList = new ArrayList<String>();
                while (rs.next()) {
                    idList.add(rs.getString("FID"));
                    lNumList.add(rs.getString("FLongNumber"));
                }
            }
            PreparedStatement preStmt = null;
            if (null != idList && idList.size() > 0) {
                String getSubCntSql = "select count(1) as subCnt from T_PM_MainMenuItem where FLongNUmber like ?";
                String updateRelationSql = "update T_PM_MainMenuItem set FSysMenuID = NULL where FID = ?";
                String getParentIDSql = "select FParent from T_PM_MainMenuItem where FID = ?";
                String getNodeNumSql = "select count(FID) as nodeCnt from T_PM_MainMenuItem where FParent = ?";
                String delNodeSql = "delete from T_PM_MainMenuItem where FID = ?";
                String updateParentSql = "update T_PM_MainMenuItem set FIsLeaf = 1 where FID = ?";
                preStmt = conn.prepareStatement(getSubCntSql);
                PreparedStatement tempPreStmt = null;
                ResultSet tempRs = null;
                int subCnt = 0;
                int j = idList.size();
                for (int i = 0; i < j; ++i) {
                    preStmt.setString(1, (String)lNumList.get(i) + "!%");
                    rs = preStmt.executeQuery();
                    if (null != rs && rs.next()) {
                        subCnt = rs.getInt("subCnt");
                    }
                    if (subCnt > 0) {
                        tempPreStmt = conn.prepareStatement(updateRelationSql);
                        tempPreStmt.setString(1, (String)idList.get(i));
                        tempPreStmt.execute();
                        continue;
                    }
                    tempPreStmt = conn.prepareStatement(getParentIDSql);
                    tempPreStmt.setString(1, (String)idList.get(i));
                    tempRs = tempPreStmt.executeQuery();
                    String parentID = null;
                    if (null != tempRs && tempRs.next()) {
                        parentID = tempRs.getString("FParent");
                    }
                    int size = 0;
                    tempPreStmt = conn.prepareStatement(getNodeNumSql);
                    tempPreStmt.setString(1, parentID);
                    tempRs = tempPreStmt.executeQuery();
                    if (null != tempRs && tempRs.next()) {
                        size = tempRs.getInt("nodeCnt");
                    }
                    tempPreStmt = conn.prepareStatement(delNodeSql);
                    tempPreStmt.setString(1, (String)idList.get(i));
                    tempPreStmt.execute();
                    if (size > 1 || null == parentID || parentID.trim().length() <= 0) continue;
                    tempPreStmt = conn.prepareStatement(updateParentSql);
                    tempPreStmt.setString(1, parentID);
                    tempPreStmt.execute();
                }
            }
            String newMenuSelectSql = "select * from T_BAS_SysMenuItem where FID not in(select t.FID from T_BAS_SysMenuItem t,T_PM_MainMenuItem t1 where t.FID = t1.FSysMenuID) and (" + this.getIndustrySql(industryType) + ") and fid not in (select fid from T_PM_MainMenuItem ) order by FLongNumber,FOrder";
            rs = conn.createStatement().executeQuery(newMenuSelectSql);
            if (null != rs && (menuList = this.getAllUnImportedMenu(rs)).size() > 0) {
                String number = null;
                String shortcutCode = null;
                SysMenuItemInfo sysMenuInfo = null;
                MainMenuItemInfo parentMenu = null;
                MainMenuItemInfo newMenu = null;
                int j = menuList.size();
                for (int i = 0; i < j; ++i) {
                    sysMenuInfo = (SysMenuItemInfo)menuList.get(i);
                    number = sysMenuInfo.getNumber();
                    shortcutCode = sysMenuInfo.getShortcutCode();
                    if (this.isNumberRepeated(conn, number)) {
                        this.logger.debug((Object)(UIFrameUtils.getRes("res_74") + "[" + sysMenuInfo.getDisplayName() + "]" + UIFrameUtils.getRes("res_75")));
                        continue;
                    }
                    if (this.isShortcutCodeRepeated(conn, shortcutCode)) {
                        this.logger.debug((Object)(UIFrameUtils.getRes("res_74") + "[" + sysMenuInfo.getDisplayName() + "]" + UIFrameUtils.getRes("res_76")));
                        continue;
                    }
                    String parentId = null;
                    if (sysMenuInfo.getParent() != null) {
                        parentId = sysMenuInfo.getParent().getId().toString();
                        parentMenu = this.findImportedParent(conn, parentId);
                        newMenu = this.sysInfo2CustInfo(sysMenuInfo, parentMenu);
                        this.addNewMenu(conn, newMenu);
                        continue;
                    }
                    newMenu = this.sysInfo2CustInfo(sysMenuInfo, null);
                    this.addNewMenu(conn, newMenu);
                }
            }
            if (preStmt != null) {
                preStmt.close();
            }
            status = true;
            this.updateComMenuCach(conn);
            this.updateMenuCache(conn);
            this.updateMenuStatus(conn, industryType);
            boolean bl = status;
            return bl;
        }
        catch (Exception ex) {
            this.logger.error((Object)"auto update error: ", (Throwable)ex);
            throw new Exception(ex);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"auto update error: ", (Throwable)e);
            }
        }
    }

    private HashMap getAllFieldName() {
        String[] fieldNameColl = new String[]{"FCreatorID", "FCreateTime", "FLastUpdateUserID", "FLastUpdateTime", "FControlUnitID", "FName_L1", "FName_L2", "FName_L3", "FNumber", "FDescription_L1", "FDescription_L2", "FDescription_L3", "FSimpleName", "FIsLeaf", "FLevel", "FLongNumber", "FDisplayName_L1", "FDisplayName_L2", "FDisplayName_L3", "FOrder", "FImagePath", "FVisible", "FEnabled", "FUiClassName", "FUiClassParam", "FUiOprt", "FOpenMethod", "FShortcutCode", "FIsReport", "FParent", "FFunction", "FIndustry", "FNoSuit"};
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < fieldNameColl.length; ++i) {
            map.put(fieldNameColl[i], fieldNameColl[i]);
        }
        return map;
    }

    private String[] getUpdateFieldNameStr(HashMap map) {
        String[] field = new String[2];
        StringBuffer pmField = new StringBuffer();
        StringBuffer syField = new StringBuffer();
        if (map != null && map.size() >= 1) {
            for (String fieldName : map.keySet()) {
                pmField.append(fieldName);
                pmField.append(",");
                syField.append("t.");
                syField.append(fieldName);
                syField.append(",");
            }
        }
        field[0] = pmField.substring(0, pmField.length() - 1);
        field[1] = syField.substring(0, syField.length() - 1);
        return field;
    }

    private void updateMenuStatus(Connection conn, String industryType) {
        String updateMenuSql = "update T_BAS_MenuUpdate set FIndustryStatus='" + industryType + "',FIsUpdate=1 where FID='menuUpdate'";
        try {
            conn.createStatement().execute(updateMenuSql);
        }
        catch (Exception e) {
            this.logger.error((Object)("update menu status error:" + e.getMessage()), (Throwable)e);
        }
    }

    private void updateNoMenuStatus(Connection conn) {
        String updateMenuSql = "update T_BAS_MenuUpdate set FIsUpdate=1, FIndustryStatus='all' where FID='menuUpdate'";
        try {
            conn.createStatement().execute(updateMenuSql);
        }
        catch (Exception e) {
            this.logger.error((Object)("update menu status error:" + e.getMessage()), (Throwable)e);
        }
    }

    public boolean autoUpdateCustMenu(Connection conn, int dbType) throws Exception {
        boolean status = false;
        try {
            conn.setAutoCommit(true);
            this.logger.info((Object)"auto update customer menu without industry statring...");
            String dbTypeStr = DbType.getName((int)dbType);
            if (dbTypeStr != null) {
                CustMenuAutoUpdateForDB.dbType.set(dbTypeStr);
            }
            CustMenuAutoUpdateForDB.autoUpdate(conn, null);
            boolean bl = status = true;
            return bl;
        }
        catch (Exception ex) {
            this.logger.error((Object)"auto update error: ", (Throwable)ex);
            throw new Exception(ex);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"auto update error: ", (Throwable)e);
            }
        }
    }

    public boolean autoUpdateCustMenu(Connection conn, int dbType, String industryType) throws Exception {
        boolean status = false;
        try {
            conn.setAutoCommit(true);
            this.logger.info((Object)("auto update customer menu with industry " + industryType + " statring..."));
            String dbTypeStr = DbType.getName((int)dbType);
            if (dbTypeStr != null) {
                CustMenuAutoUpdateForDB.dbType.set(dbTypeStr);
            }
            CustMenuAutoUpdateForDB.autoUpdate(conn, industryType);
            boolean bl = status = true;
            return bl;
        }
        catch (Exception ex) {
            this.logger.error((Object)"auto update error: ", (Throwable)ex);
            throw new Exception(ex);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"auto update error: ", (Throwable)e);
            }
        }
    }

    private boolean isNumberRepeated(Connection conn, String number) throws Exception {
        int cnt;
        boolean repeatedTag = false;
        String selectSql = "select count(1) as cnt from T_PM_MainMenuItem where FNumber = ?";
        PreparedStatement preStmt = conn.prepareStatement(selectSql);
        preStmt.setString(1, number);
        ResultSet rs = preStmt.executeQuery();
        if (null != rs && rs.next() && (cnt = rs.getInt("cnt")) > 0) {
            repeatedTag = true;
        }
        preStmt.close();
        return repeatedTag;
    }

    private boolean isShortcutCodeRepeated(Connection conn, String shortCutCode) throws Exception {
        boolean repeatedTag = false;
        if (null != shortCutCode && 0 > shortCutCode.length()) {
            int cnt;
            String selectSql = "select count(1) as cnt from T_PM_MainMenuItem where FShortcutCode = ?";
            PreparedStatement preStmt = conn.prepareStatement(selectSql);
            preStmt.setString(1, shortCutCode);
            ResultSet rs = preStmt.executeQuery();
            if (null != rs && rs.next() && (cnt = rs.getInt("cnt")) > 0) {
                repeatedTag = true;
            }
            preStmt.close();
        }
        return repeatedTag;
    }

    private List getAllUnImportedMenu(ResultSet rowSet) throws SQLException {
        PermItemInfo pemission = null;
        SysMenuItemInfo menuItemInfo = null;
        ArrayList<SysMenuItemInfo> menuList = new ArrayList<SysMenuItemInfo>();
        SysMenuItemInfo parentItemInfo = null;
        int pos = 0;
        while (rowSet.next()) {
            menuItemInfo = new SysMenuItemInfo();
            menuItemInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
            CustMenuAutoUpdateForJDBC.setMultiLangValue(menuItemInfo, rowSet);
            menuItemInfo.setNumber(rowSet.getString("FNumber"));
            menuItemInfo.setLongNumber(rowSet.getString("FLongNumber"));
            if (rowSet.getString("FParent") != null) {
                parentItemInfo = new SysMenuItemInfo();
                parentItemInfo.setId(BOSUuid.read((String)rowSet.getString("FParent")));
                menuItemInfo.setParent(parentItemInfo);
            } else {
                menuItemInfo.setParent(null);
            }
            menuItemInfo.setLevel(rowSet.getInt("FLevel"));
            menuItemInfo.setIsLeaf(rowSet.getInt("FIsLeaf") != 0);
            menuItemInfo.setOrder(rowSet.getString("FOrder"));
            menuItemInfo.setImagePath(rowSet.getString("FImagePath"));
            menuItemInfo.setEnabled(rowSet.getInt("FEnabled") != 0);
            menuItemInfo.setVisible(rowSet.getInt("FVisible") != 0);
            menuItemInfo.setIsReport(rowSet.getInt("FIsReport") != 0);
            menuItemInfo.setUiClassName(rowSet.getString("FUiClassName"));
            menuItemInfo.setUiClassParam(rowSet.getString("FUiClassParam"));
            menuItemInfo.setUiOprt(rowSet.getString("FUiOprt"));
            menuItemInfo.setOpenMethod(OpenMethod.getEnum(rowSet.getInt("FOpenMethod")));
            menuItemInfo.setShortcutCode(rowSet.getString("FShortcutCode"));
            if (rowSet.getString("FFunction") != null && rowSet.getString("FFunction").trim().length() > 0) {
                pemission = new PermItemInfo();
                pemission.setId(BOSUuid.read((String)rowSet.getString("FFunction")));
                menuItemInfo.setFunction(pemission);
            }
            menuItemInfo.setIndustry(IndustryEnum.getEnum(rowSet.getInt("FIndustry")));
            menuItemInfo.setNoSuit(rowSet.getString("FNoSuit"));
            String mtype = rowSet.getString("FMenutype");
            if (null == mtype || "".equals(mtype)) {
                menuItemInfo.setMenutype(BizTypeEnum.guimenu);
            } else {
                menuItemInfo.setMenutype(BizTypeEnum.getEnum(mtype));
            }
            CtrlUnitInfo cuInfo = new CtrlUnitInfo();
            cuInfo.setId(BOSUuid.read((String)rowSet.getString("FCONTROLUNITID")));
            menuItemInfo.setCU(cuInfo);
            menuItemInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)rowSet.getString("FCREATORID")));
            menuItemInfo.setCreator(user);
            menuItemInfo.setLastUpdateUser(user);
            menuList.add(pos, menuItemInfo);
            ++pos;
        }
        return menuList;
    }

    private MainMenuItemInfo findImportedParent(Connection conn, String parentID) throws Exception {
        MainMenuItemInfo parentMenu = new MainMenuItemInfo();
        String selectSql = "select * from T_PM_MainMenuItem where FSysMenuID = ?";
        PreparedStatement preStmt = conn.prepareStatement(selectSql);
        preStmt.setString(1, parentID);
        ResultSet rowSet = preStmt.executeQuery();
        if (null != rowSet && rowSet.next()) {
            parentMenu.setId(BOSUuid.read((String)rowSet.getString("FID")));
            for (int i = 0; i < locales.length; ++i) {
                Locale locale = locales[i];
                String name = rowSet.getString("FName_" + locale.toString());
                parentMenu.setName(name, locale);
                String description = parentMenu.getString("FDescription_" + locale.toString());
                parentMenu.setDescription(description, locale);
            }
            parentMenu.setNumber(rowSet.getString("FNumber"));
            parentMenu.setLongNumber(rowSet.getString("FLongNumber"));
            parentMenu.setParent(null);
            parentMenu.setLevel(rowSet.getInt("FLevel"));
            parentMenu.setIsLeaf(rowSet.getInt("FIsLeaf") != 0);
            parentMenu.setOrder(rowSet.getString("FOrder"));
            parentMenu.setImagePath(rowSet.getString("FImagePath"));
            parentMenu.setEnabled(rowSet.getInt("FEnabled") != 0);
            parentMenu.setVisible(rowSet.getInt("FVisible") != 0);
            parentMenu.setIsReport(rowSet.getInt("FIsReport") != 0);
            parentMenu.setUiClassName(rowSet.getString("FUiClassName"));
            parentMenu.setUiClassParam(rowSet.getString("FUiClassParam"));
            parentMenu.setUiOprt(rowSet.getString("FUiOprt"));
            parentMenu.setOpenMethod(OpenMethod.getEnum(rowSet.getInt("FOpenMethod")));
            parentMenu.setShortcutCode(rowSet.getString("FShortcutCode"));
            parentMenu.setIndustry(IndustryEnum.getEnum(rowSet.getInt("FIndustry")));
            parentMenu.setNoSuit(rowSet.getString("FNoSuit"));
            String mtype = rowSet.getString("FMenutype");
            if (null == mtype || "".equals(mtype)) {
                parentMenu.setMenutype(BizTypeEnum.guimenu);
            } else {
                parentMenu.setMenutype(BizTypeEnum.getEnum(mtype));
            }
            if (rowSet.getString("FFunction") != null && rowSet.getString("FFunction").trim().length() > 0) {
                PermItemInfo pemission = new PermItemInfo();
                pemission.setId(BOSUuid.read((String)rowSet.getString("FFunction")));
                parentMenu.setFunction(pemission);
            }
        }
        preStmt.close();
        return parentMenu;
    }

    private MainMenuItemInfo sysInfo2CustInfo(SysMenuItemInfo sysMenuInfo, MainMenuItemInfo parentCMMenu) {
        MainMenuItemInfo custItemInfo = new MainMenuItemInfo();
        custItemInfo.setId(sysMenuInfo.getId());
        String displayName = null;
        int j = locales.length;
        for (int i = 0; i < j; ++i) {
            custItemInfo.setName(sysMenuInfo.getName(locales[i]), locales[i]);
            custItemInfo.setDescription(sysMenuInfo.getDescription(locales[i]), locales[i]);
            displayName = null != parentCMMenu && parentCMMenu.getDisplayName(locales[i]) != null && !parentCMMenu.getDisplayName(locales[i]).equalsIgnoreCase("null") ? parentCMMenu.getDisplayName(locales[i]) + "_" + sysMenuInfo.getName(locales[i]) : sysMenuInfo.getName(locales[i]);
            custItemInfo.setDisplayName(displayName, locales[i]);
        }
        custItemInfo.setNumber(sysMenuInfo.getNumber());
        String theLongNum = null;
        theLongNum = null == parentCMMenu || null == parentCMMenu.getLongNumber() || parentCMMenu.getLongNumber().trim().length() == 0 ? sysMenuInfo.getNumber() : parentCMMenu.getLongNumber() + "!" + sysMenuInfo.getNumber();
        custItemInfo.setLongNumber(theLongNum);
        custItemInfo.setOrder(sysMenuInfo.getOrder());
        custItemInfo.setImagePath(sysMenuInfo.getImagePath());
        custItemInfo.setEnabled(sysMenuInfo.isEnabled());
        custItemInfo.setVisible(sysMenuInfo.isVisible());
        custItemInfo.setIsReport(sysMenuInfo.isIsReport());
        custItemInfo.setUiClassName(sysMenuInfo.getUiClassName());
        custItemInfo.setUiClassParam(sysMenuInfo.getUiClassParam());
        custItemInfo.setUiOprt(sysMenuInfo.getUiOprt());
        custItemInfo.setOpenMethod(sysMenuInfo.getOpenMethod());
        custItemInfo.setShortcutCode(sysMenuInfo.getShortcutCode());
        custItemInfo.setFunction(sysMenuInfo.getFunction());
        custItemInfo.setIsLeaf(sysMenuInfo.isIsLeaf());
        custItemInfo.setIndustry(sysMenuInfo.getIndustry());
        custItemInfo.setNoSuit(sysMenuInfo.getNoSuit());
        custItemInfo.setMenutype(sysMenuInfo.getMenutype());
        if (null != parentCMMenu) {
            custItemInfo.setLevel(parentCMMenu.getLevel() + 1);
        } else {
            custItemInfo.setLevel(1);
        }
        if (null != parentCMMenu && null != parentCMMenu.getId() && parentCMMenu.getId().toString().trim().length() > 0) {
            custItemInfo.setParent(parentCMMenu);
        } else {
            custItemInfo.setParent(null);
        }
        custItemInfo.setSysMenu(sysMenuInfo);
        custItemInfo.setCU(sysMenuInfo.getCU());
        custItemInfo.setCreator(sysMenuInfo.getCreator());
        custItemInfo.setLastUpdateUser(sysMenuInfo.getLastUpdateUser());
        return custItemInfo;
    }

    protected void updateMenuCache(Connection conn) throws SQLException {
        try {
            DbTransactionUtil.tryTruncateTableNo(null, "T_BAS_MenuCache");
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            String cleanMenuSql = "delete from T_BAS_MenuCache";
            conn.createStatement().execute(cleanMenuSql);
        }
    }

    protected void updateComMenuCach(Connection conn) throws SQLException {
        try {
            DbTransactionUtil.tryTruncateTableNo(null, "t_bas_comfuncmenucache");
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            String cleanSql = "delete from t_bas_comfuncmenucache";
            conn.createStatement().execute(cleanSql);
        }
    }

    public void setJnlpPath(String jnlpPath) {
        this.jnlpPath = jnlpPath;
    }

    private void addNewMenu(Connection conn, MainMenuItemInfo newMenu) throws Exception {
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("insert into T_PM_MainMenuItem (").append("FID,");
        sqlBuff.append("FName_L1,FName_L2,FName_L3,");
        sqlBuff.append("FDisplayName_L1,FDisplayName_L2,FDisplayName_L3,");
        sqlBuff.append("FNumber,FLongNumber,FOrder,");
        sqlBuff.append("FImagePath,FVisible,FEnabled,");
        sqlBuff.append("FUiClassName,FUiClassParam,FUiOprt,");
        sqlBuff.append("FOpenMethod,FShortcutCode,FIsReport,");
        sqlBuff.append("FParent,FFunction,FSysMenuID,FCONTROLUNITID,FCREATORID,FLASTUPDATEUSERID,FLevel,FIsLeaf,FMenutype)");
        sqlBuff.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String insertSql = sqlBuff.toString();
        PreparedStatement preStmt = conn.prepareStatement(insertSql);
        preStmt.setString(1, newMenu.getId().toString());
        preStmt.setString(2, newMenu.getName(locales[0]));
        preStmt.setString(3, newMenu.getName(locales[1]));
        preStmt.setString(4, newMenu.getName(locales[2]));
        preStmt.setString(5, newMenu.getDisplayName(locales[0]));
        preStmt.setString(6, newMenu.getDisplayName(locales[1]));
        preStmt.setString(7, newMenu.getDisplayName(locales[2]));
        preStmt.setString(8, newMenu.getNumber());
        preStmt.setString(9, newMenu.getLongNumber());
        preStmt.setString(10, newMenu.getOrder());
        preStmt.setString(11, newMenu.getImagePath());
        preStmt.setBoolean(12, newMenu.isVisible());
        preStmt.setBoolean(13, newMenu.isEnabled());
        preStmt.setString(14, newMenu.getUiClassName());
        preStmt.setString(15, newMenu.getUiClassParam());
        preStmt.setString(16, newMenu.getUiOprt());
        preStmt.setInt(17, newMenu.getOpenMethod().getValue());
        preStmt.setString(18, newMenu.getShortcutCode());
        preStmt.setBoolean(19, newMenu.isIsReport());
        String parentId = null;
        if (newMenu.getParent() != null) {
            parentId = newMenu.getParent().getId().toString();
        }
        preStmt.setString(20, parentId);
        preStmt.setString(21, newMenu.getFunction() == null ? null : newMenu.getFunction().getId().toString());
        preStmt.setString(22, newMenu.getSysMenu().getId().toString());
        preStmt.setString(23, newMenu.getCU().getId().toString());
        preStmt.setString(24, newMenu.getCreator().getId().toString());
        preStmt.setString(25, newMenu.getLastUpdateUser().getId().toString());
        preStmt.setInt(26, newMenu.getLevel());
        preStmt.setBoolean(27, newMenu.isIsLeaf());
        if (newMenu.getMenutype() == null) {
            preStmt.setString(28, "10");
        } else {
            preStmt.setString(28, newMenu.getMenutype().getValue());
        }
        preStmt.execute();
        preStmt.close();
    }

    private static void setMultiLangValue(SysMenuItemInfo menuItem, ResultSet rowset) throws SQLException {
        int j = locales.length;
        for (int i = 0; i < j; ++i) {
            String name = rowset.getString("FName_" + locales[i].getLanguage());
            menuItem.setName(name, locales[i]);
            String description = rowset.getString("FDescription_" + locales[i].getLanguage());
            menuItem.setDescription(description, locales[i]);
            String displayName = rowset.getString("FDisplayName_" + locales[i].getLanguage());
            menuItem.setDisplayName(displayName, locales[i]);
            if (!locales[i].equals(SysContext.getSysContext().getLocale())) continue;
            menuItem.setName(name);
            menuItem.setDescription(description);
            menuItem.setDisplayName(displayName);
        }
    }
}

