/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.utils;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.SysMenuItemInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.util.StringUtils;

public class MenuEditUtils {
    public static TreeBaseInfo getMenuInfoFromTreeByID(DefaultKingdeeTreeNode tree, String menuID) {
        TreeBaseInfo menuInfo = null;
        if (null != tree && tree.getChildCount() > 0) {
            DefaultKingdeeTreeNode subNode = null;
            int j = tree.getChildCount();
            for (int i = 0; i < j; ++i) {
                subNode = (DefaultKingdeeTreeNode)tree.getChildAt(i);
                if (((TreeBaseInfo)subNode.getUserObject()).getId().toString().trim().equals(menuID.trim())) {
                    menuInfo = (TreeBaseInfo)subNode.getUserObject();
                    break;
                }
                menuInfo = MenuEditUtils.getMenuInfoFromTreeByID(subNode, menuID);
                if (null != menuInfo) break;
            }
        }
        return menuInfo;
    }

    public static DefaultKingdeeTreeNode locateNodeByMenuId(String menuId, DefaultKingdeeTreeNode root) {
        DefaultKingdeeTreeNode theNode = null;
        DefaultKingdeeTreeNode tempNode = null;
        int subNodeCnt = root.getChildCount();
        if (subNodeCnt > 0) {
            for (int i = 0; i < subNodeCnt; ++i) {
                if (((TreeBaseInfo)((DefaultKingdeeTreeNode)root.getChildAt(i)).getUserObject()).getId().toString().trim().equals(menuId.trim())) {
                    theNode = (DefaultKingdeeTreeNode)root.getChildAt(i);
                    break;
                }
                tempNode = MenuEditUtils.locateNodeByMenuId(menuId, (DefaultKingdeeTreeNode)root.getChildAt(i));
                if (null == tempNode) continue;
                theNode = tempNode;
                break;
            }
        }
        return theNode;
    }

    public static boolean isRepeatedNumber(TreeBaseInfo menuInfo, DefaultKingdeeTreeNode root) {
        boolean repeatedTag = false;
        if (root.getChildCount() > 0) {
            TreeBaseInfo tempInfo = null;
            int j = root.getChildCount();
            for (int i = 0; i < j; ++i) {
                tempInfo = (TreeBaseInfo)((DefaultKingdeeTreeNode)root.getChildAt(i)).getUserObject();
                if (!menuInfo.getId().toString().trim().equals(tempInfo.getId().toString().trim()) && tempInfo.getNumber().trim().equals(menuInfo.getNumber().trim())) {
                    repeatedTag = true;
                    break;
                }
                repeatedTag = MenuEditUtils.isRepeatedNumber(menuInfo, (DefaultKingdeeTreeNode)root.getChildAt(i));
                if (repeatedTag) break;
            }
        }
        return repeatedTag;
    }

    public static boolean isRepeatedShortcutCode(TreeBaseInfo menuInfo, DefaultKingdeeTreeNode root) {
        boolean repeatedTag = false;
        if (root.getChildCount() > 0) {
            TreeBaseInfo tempInfo = null;
            int j = root.getChildCount();
            for (int i = 0; i < j; ++i) {
                tempInfo = (TreeBaseInfo)((DefaultKingdeeTreeNode)root.getChildAt(i)).getUserObject();
                if (!menuInfo.getId().toString().trim().equals(tempInfo.getId().toString().trim()) && MenuEditUtils.isShortcutCodeEqual(menuInfo, tempInfo)) {
                    repeatedTag = true;
                    break;
                }
                repeatedTag = MenuEditUtils.isRepeatedShortcutCode(menuInfo, (DefaultKingdeeTreeNode)root.getChildAt(i));
                if (repeatedTag) break;
            }
        }
        return repeatedTag;
    }

    public static boolean isEmptyString(String theString) {
        boolean emptyTag = true;
        if (null != theString && theString.trim().length() > 0) {
            emptyTag = false;
        }
        return emptyTag;
    }

    public static boolean isAvailNumber(String number) {
        boolean availTag = true;
        int j = number.length();
        for (int i = 0; i < j; ++i) {
            if (MenuEditUtils.isLetterOrDigit(number.charAt(i))) continue;
            availTag = false;
            break;
        }
        return availTag;
    }

    public static boolean isStringLenExceeded(String theString, int maxLen) {
        boolean exceededTag = false;
        if (null != theString && theString.length() > maxLen) {
            exceededTag = true;
        }
        return exceededTag;
    }

    private static boolean isShortcutCodeEqual(TreeBaseInfo menuInfo, TreeBaseInfo toMenuInfo) {
        boolean equalTag = false;
        String menuShortCode = null;
        String toMenuShortCode = null;
        if (toMenuInfo instanceof SysMenuItemInfo) {
            menuShortCode = ((SysMenuItemInfo)menuInfo).getShortcutCode();
            toMenuShortCode = ((SysMenuItemInfo)toMenuInfo).getShortcutCode();
        } else if (toMenuInfo instanceof MainMenuItemInfo) {
            menuShortCode = ((MainMenuItemInfo)menuInfo).getShortcutCode();
            toMenuShortCode = ((MainMenuItemInfo)toMenuInfo).getShortcutCode();
        }
        if (!StringUtils.isEmpty((String)menuShortCode) && !StringUtils.isEmpty((String)toMenuShortCode)) {
            equalTag = menuShortCode.trim().equals(toMenuShortCode.trim());
        }
        return equalTag;
    }

    public static boolean isLetterOrDigit(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9';
    }
}

