/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.SMSValidataUserManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.globlelogin.GlobleLoginConfigClientFactory;
import com.kingdee.util.StringUtils;
import java.util.Properties;

public class SMSValidataCodeUtilGUI {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEnableSMSValidateCode(Context ctx, int count) {
        if ("Kingdee".equals(ctx.get((Object)"UserAuthPattern"))) {
            return false;
        }
        if (ctx == null) return false;
        if (ctx.get((Object)"UserInfo") == null) {
            return false;
        }
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        LoginAuthorWayEnum loginAuthorWay = userInfo.getLoginAuthorWay();
        if (LoginAuthorWayEnum.NORMAL_DYNAMIC.equals((Object)loginAuthorWay)) {
            return false;
        }
        String userNumber = userInfo.getNumber();
        if (!SMSValidataCodeUtilGUI.isNeedShowByUserNumber(ctx, userNumber)) {
            return false;
        }
        boolean isEnableValidateCode = false;
        int errorCount = -1;
        Properties properties = null;
        try {
            properties = GlobleLoginConfigClientFactory.getRemoteInstance().getBizConfig();
            if (properties == null) return false;
            String authType = properties.getProperty("authType");
            if (StringUtils.isEmpty((String)authType)) return false;
            if ("2".equals(authType)) {
                isEnableValidateCode = true;
                String errNum = properties.getProperty("errNum");
                if (!StringUtils.isEmpty((String)errNum)) {
                    errorCount = Integer.parseInt(errNum);
                }
            }
            if (!isEnableValidateCode) return false;
            if (errorCount < 0) {
                return true;
            }
            if (count - errorCount < 0) return false;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return isEnableValidateCode;
        }
    }

    private static boolean isNeedShowByUserNumber(Context ctx, String userNumber) {
        try {
            FilterInfo filter0 = new FilterInfo();
            filter0.getFilterItems().add(new FilterItemInfo("user.number", (Object)userNumber));
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("user.loginNumber", (Object)userNumber));
            filter0.mergeFilter(filter1, "or");
            if (SMSValidataUserManagerFactory.getRemoteInstance().exists(filter0)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

