/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.wssc.app.AbstractExtendOrgFacadeControllerBean;
import com.kingdee.eas.base.wssc.app.org.OrgFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExtendOrgFacadeControllerBean
extends AbstractExtendOrgFacadeControllerBean {
    private static final long serialVersionUID = 2785553374500867067L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.app.ExtendOrgFacadeControllerBean");
    private final String ROOTID = "00000000-0000-0000-0000-000000000000CCE7AED4";

    @Override
    protected String _getFullOrgUnitByParent(Context ctx, String parentId, String orgTreeId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgTreeId)) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (StringUtils.isEmpty((String)parentId)) {
                FullOrgUnitInfo rootInfo = this.getRootFullOrgUnit(ctx);
                result.put("root", this.fullOrgUnit2Map(rootInfo));
                parentId = rootInfo.getId().toString();
            }
            FullOrgUnitCollection fullOrgColl = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(this.buildViewInfo(parentId, orgTreeId));
            ArrayList<Map<String, Object>> orgList = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < fullOrgColl.size(); ++i) {
                orgList.add(this.fullOrgUnit2Map(fullOrgColl.get(i)));
            }
            result.put("children", orgList);
            return JSONUtils.convertObjectToJson((Context)ctx, result);
        }
        return this._getOrgTypeTree(ctx, parentId, orgTreeId);
    }

    @Override
    protected String _getAdminOrgUnitByParent(Context ctx, String parentId, String orgTreeId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)parentId)) {
            AdminOrgUnitInfo rootInfo = this.getRootAdminOrgUnit(ctx);
            result.put("root", this.adminOrgUnit2Map(rootInfo));
            parentId = rootInfo.getId().toString();
        }
        AdminOrgUnitCollection adminOrgUnitColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(this.buildViewInfo(parentId, orgTreeId));
        ArrayList<Map<String, Object>> orgList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < adminOrgUnitColl.size(); ++i) {
            orgList.add(this.adminOrgUnit2Map(adminOrgUnitColl.get(i)));
        }
        result.put("children", orgList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    private FullOrgUnitInfo getRootFullOrgUnit(Context ctx) throws BOSException, EASBizException {
        return FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"), this.getSimpleSic());
    }

    private AdminOrgUnitInfo getRootAdminOrgUnit(Context ctx) throws BOSException, EASBizException {
        return AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"), this.getSimpleSic());
    }

    @Override
    protected String _getAllFullOrgUnitByParent(Context ctx, String parentId, String orgTreeId) throws BOSException, EASBizException {
        return this._getFullOrgUnitByParent(ctx, parentId, 0, orgTreeId);
    }

    protected String _getFullOrgUnitByParent(Context ctx, String parentId, int level, String orgTreeId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FullOrgUnitInfo parentInfo = null;
        parentInfo = StringUtils.isEmpty((String)parentId) ? this.getRootFullOrgUnit(ctx) : FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(parentId), this.getSimpleSic());
        result.put("root", this.fullOrgUnit2Map(parentInfo));
        FullOrgUnitCollection fullOrgColl = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(this.buildViewInfo((OrgUnitInfo)parentInfo, level, orgTreeId));
        ArrayList<Map<String, Object>> orgList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < fullOrgColl.size(); ++i) {
            orgList.add(this.fullOrgUnit2Map(fullOrgColl.get(i)));
        }
        result.put("children", orgList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    @Override
    protected String _getOrgUnitByNumber(Context ctx, String number) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)false));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic = this.getSimpleSic();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(sic);
        FullOrgUnitCollection coll = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(view);
        if (coll.size() == 0) {
            return null;
        }
        Map<String, Object> map = this.fullOrgUnit2Map(coll.get(0));
        return JSONUtils.convertObjectToJson((Context)ctx, map);
    }

    @Override
    protected String _getOrgIds(Context ctx, List orgIds) throws BOSException, EASBizException {
        HashSet temp = new HashSet(orgIds);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", temp, CompareType.INCLUDE));
        SelectorItemCollection sic = this.getSimpleSic();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(sic);
        FullOrgUnitCollection fullOrgColl = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(view);
        ArrayList<Map<String, Object>> orgList = new ArrayList<Map<String, Object>>();
        ArrayList<String> fullOrgIds = new ArrayList<String>();
        for (int i = 0; i < fullOrgColl.size(); ++i) {
            orgList.add(this.fullOrgUnit2Map(fullOrgColl.get(i)));
            fullOrgIds.add(fullOrgColl.get(i).getId().toString());
        }
        ArrayList<String> delOrgIds = new ArrayList<String>();
        if (temp.size() > fullOrgIds.size()) {
            for (String orgId : temp) {
                if (fullOrgIds.contains(orgId)) continue;
                delOrgIds.add(orgId);
            }
        }
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>();
        map.put("existList", orgList);
        map.put("delOrgIds", delOrgIds);
        return JSONUtils.convertObjectToJson((Context)ctx, map);
    }

    private SelectorItemCollection getSimpleSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("isLeaf");
        sic.add("longNumber");
        sic.add("parent.id");
        sic.add("level");
        sic.add("displayName");
        sic.add("parent.number");
        return sic;
    }

    private Map<String, Object> fullOrgUnit2Map(FullOrgUnitInfo orgInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", orgInfo.getId().toString());
        map.put("number", orgInfo.getNumber().toString());
        map.put("name", orgInfo.getName());
        map.put("name_l1", orgInfo.getName(LocaleUtils.locale_L1));
        map.put("name_l2", orgInfo.getName(LocaleUtils.locale_L2));
        map.put("name_l3", orgInfo.getName(LocaleUtils.locale_L3));
        map.put("isLeaf", orgInfo.isIsLeaf());
        map.put("longNumber", orgInfo.getLongNumber().toString());
        if (orgInfo.getParent() == null || orgInfo.getParent().getId() == null) {
            map.put("parent", null);
        } else {
            map.put("parent", orgInfo.getParent().getId().toString());
        }
        if (orgInfo.getParent() == null || orgInfo.getParent().getNumber() == null) {
            map.put("parentNumber", null);
        } else {
            map.put("parentNumber", orgInfo.getParent().getNumber().toString());
        }
        map.put("level", orgInfo.getLevel());
        map.put("displayName", orgInfo.getDisplayName());
        map.put("displayName_l1", orgInfo.getDisplayName(LocaleUtils.locale_L1));
        map.put("displayName_l2", orgInfo.getDisplayName(LocaleUtils.locale_L2));
        map.put("displayName_l3", orgInfo.getDisplayName(LocaleUtils.locale_L3));
        return map;
    }

    private Map<String, Object> adminOrgUnit2Map(AdminOrgUnitInfo orgInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", orgInfo.getId().toString());
        map.put("number", orgInfo.getNumber().toString());
        map.put("name", orgInfo.getName());
        map.put("name_l1", orgInfo.getName(LocaleUtils.locale_L1));
        map.put("name_l2", orgInfo.getName(LocaleUtils.locale_L2));
        map.put("name_l3", orgInfo.getName(LocaleUtils.locale_L3));
        map.put("isLeaf", orgInfo.isIsLeaf());
        if (orgInfo.getParent() == null || orgInfo.getParent().getId() == null) {
            map.put("parent", null);
        } else {
            map.put("parent", orgInfo.getParent().getId().toString());
        }
        if (orgInfo.getParent() == null || orgInfo.getParent().getNumber() == null) {
            map.put("parentNumber", null);
        } else {
            map.put("parentNumber", orgInfo.getParent().getNumber().toString());
        }
        map.put("level", orgInfo.getLevel());
        map.put("displayName", orgInfo.getDisplayName());
        map.put("displayName_l1", orgInfo.getDisplayName(LocaleUtils.locale_L1));
        map.put("displayName_l2", orgInfo.getDisplayName(LocaleUtils.locale_L2));
        map.put("displayName_l3", orgInfo.getDisplayName(LocaleUtils.locale_L3));
        map.put("longNumber", orgInfo.getLongNumber().toString());
        return map;
    }

    private Map<String, Object> orgStructure2Map(OrgStructureInfo osInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String longNumber = osInfo.getLongNumber();
        String longName = osInfo.getDisplayName();
        String number = longNumber.substring(longNumber.lastIndexOf("!") + 1);
        String name = longName.substring(longName.lastIndexOf("_") + 1);
        map.put("id", osInfo.getId().toString());
        map.put("number", number);
        map.put("name", name);
        map.put("longNumber", longNumber);
        if (osInfo.getParent() == null || osInfo.getParent().getId() == null) {
            map.put("parent", null);
        } else {
            map.put("parent", osInfo.getParent().getId().toString());
        }
        map.put("level", osInfo.getLevel());
        map.put("displayName", longName);
        return map;
    }

    private EntityViewInfo buildViewInfo(String parentId, String orgTreeId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)parentId));
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)false));
        filter = this.getOrgTreeIdFilter(filter, orgTreeId);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("longNumber"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(this.getSimpleSic());
        viewInfo.setFilter(filter);
        viewInfo.setSorter(sorterColl);
        return viewInfo;
    }

    private EntityViewInfo buildViewInfo(OrgUnitInfo parentInfo, int level, String orgTreeId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(parentInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)false));
        if (level != 0) {
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)parentInfo.getLevel(), CompareType.GREATER));
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)(parentInfo.getLevel() + level), CompareType.LESS_EQUALS));
        }
        filter = this.getOrgTreeIdFilter(filter, orgTreeId);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("longNumber"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(this.getSimpleSic());
        viewInfo.setFilter(filter);
        viewInfo.setSorter(sorterColl);
        return viewInfo;
    }

    private FilterInfo getOrgTreeIdFilter(FilterInfo filter, String orgTreeId) {
        if (StringUtils.isEmpty((String)orgTreeId)) {
            return filter;
        }
        if (orgTreeId.equals("00000000-0000-0000-0000-0000000000024F2827FD")) {
            filter.getFilterItems().add(new FilterItemInfo("isCompanyOrgUnit", (Object)true));
        } else if (orgTreeId.equals("00000000-0000-0000-0000-0000000000054F2827FD")) {
            filter.getFilterItems().add(new FilterItemInfo("isCostOrgUnit", (Object)true));
        } else if (orgTreeId.equals("00000000-0000-0000-0000-0000000000104F2827FD")) {
            filter.getFilterItems().add(new FilterItemInfo("isHROrgUnit", (Object)true));
        } else if (orgTreeId.equals("00000000-0000-0000-0000-0000000000044F2827FD")) {
            filter.getFilterItems().add(new FilterItemInfo("isProfitOrgUnit", (Object)true));
        } else if (orgTreeId.equals("00000000-0000-0000-0000-0000000000084F2827FD")) {
            filter.getFilterItems().add(new FilterItemInfo("isPurchaseOrgUnit", (Object)true));
        } else if (orgTreeId.equals("00000000-0000-0000-0000-0000000000124F2827FD")) {
            filter.getFilterItems().add(new FilterItemInfo("isQualityOrgUnit", (Object)true));
        } else if (orgTreeId.equals("00000000-0000-0000-0000-0000000000064F2827FD")) {
            filter.getFilterItems().add(new FilterItemInfo("isSaleOrgUnit", (Object)true));
        } else if (orgTreeId.equals("00000000-0000-0000-0000-0000000000074F2827FD")) {
            filter.getFilterItems().add(new FilterItemInfo("isStorageOrgUnit", (Object)true));
        } else if (orgTreeId.equals("00000000-0000-0000-0000-0000000000114F2827FD")) {
            filter.getFilterItems().add(new FilterItemInfo("isTransportOrgUnit", (Object)true));
        } else if (orgTreeId.equals("11111111-1111-1111-1111-1111111111114F2827FD")) {
            filter.getFilterItems().add(new FilterItemInfo("isUnion", (Object)true));
        } else if (orgTreeId.equals("00000000-0000-0000-0000-0000000000034F2827FD")) {
            filter.getFilterItems().add(new FilterItemInfo("isAdminOrgUnit", (Object)true));
        } else if (orgTreeId.equals("00000000-0000-0000-0000-0000000000014F2827FD") || orgTreeId.equals("00000000-0000-0000-0000-0000000001014F2827FD") || orgTreeId.equals("00000000-0000-0000-0000-0000000001004F2827FD") || orgTreeId.equals("00000000-0000-0000-0000-0000000001024F2827FD")) {
            // empty if block
        }
        return filter;
    }

    @Override
    protected String _getOrgTypeTree(Context ctx, String parentId, String orgTreeId) throws BOSException, EASBizException {
        String table = OrgFactory.getInstance(orgTreeId).getTable();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)parentId)) {
            OrgStructureInfo rootInfo = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo("where level = '1' and tree.id = '" + orgTreeId + "' and unit.id not in(select fid FROM " + table + " WHERE " + this.getFIsSealUp(orgTreeId) + " = 1)");
            result.put("root", this.orgStructure2Map(rootInfo));
            parentId = rootInfo.getId().toString();
        }
        OrgStructureCollection oscoll = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection("where tree.id = '" + orgTreeId + "' and parent.id = '" + parentId + "' and unit.id not in(select fid FROM " + table + " WHERE " + this.getFIsSealUp(orgTreeId) + " = 1) order by longNumber asc");
        ArrayList<Map<String, Object>> orgList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < oscoll.size(); ++i) {
            orgList.add(this.orgStructure2Map(oscoll.get(i)));
        }
        result.put("children", orgList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    @Override
    protected String _getOrgUnitByCondition(Context ctx, String queryCondition) throws BOSException, EASBizException {
        logger.error((Object)("******queryCondition*****: " + queryCondition));
        HashMap queryConditionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)queryCondition);
        if (queryConditionMap == null || queryConditionMap.size() == 0) {
            return null;
        }
        String parentId = (String)queryConditionMap.get("parentId");
        String orgTypeId = (String)queryConditionMap.get("orgTypeId");
        String org = (String)queryConditionMap.get("org");
        String isOUSealUp = (String)queryConditionMap.get("isOUSealUp");
        String startIndex = null;
        String rowCount = null;
        String sorter = (String)queryConditionMap.get("sorter");
        String sorterType = (String)queryConditionMap.get("sorterType");
        if (queryConditionMap.get("startIndex") != null && !queryConditionMap.get("startIndex").equals("")) {
            startIndex = (String)queryConditionMap.get("startIndex");
        }
        if (queryConditionMap.get("rowCount") != null && !queryConditionMap.get("rowCount").equals("")) {
            rowCount = (String)queryConditionMap.get("rowCount");
        }
        OrgStructureInfo rootInfo = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo("where tree.id = '" + orgTypeId + "' and id = '" + parentId + "'");
        Map result = this.getOrgList(ctx, rootInfo.getLongNumber(), orgTypeId, org, startIndex, rowCount, sorter, sorterType, isOUSealUp, false);
        return JSONUtils.convertObjectToJson((Context)ctx, (Object)result);
    }

    private String getFIsSealUp(String orgTreeId) {
        return "00000000-0000-0000-0000-0000000000014F2827FD".equals(orgTreeId) ? "FIsOUSealUp" : "FIsSealUp";
    }

    private Map getOrgList(Context ctx, String longNumber, String orgTypeId, String org, String startIndex, String rowCount, String sorter, String sorterType, String isOUSealUp, boolean isGetAmount) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.orgext.app.OrgStructureQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTypeId));
        filter.getFilterItems().add(new FilterItemInfo("unit.isousealup", (Object)"1", CompareType.NOTEQUALS));
        if (org != null && org.length() > 0) {
            try {
                String filterStr = "lower(unit.name) like '%" + org.toLowerCase() + "%' or lower(unit.number) like '%" + org.toLowerCase() + "%'";
                filter.mergeFilter(new FilterInfo(filterStr), "AND");
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            if (!StringUtils.isEmpty((String)isOUSealUp) && "false".equals(isOUSealUp)) {
                filter.setMaskString("(#0 or #1) and #2 and #3 and (#4 or #5) ");
            } else {
                filter.setMaskString("(#0 or #1) and #2  and (#4 or #5)");
            }
        } else if (!StringUtils.isEmpty((String)isOUSealUp) && "false".equals(isOUSealUp)) {
            filter.setMaskString("(#0 or #1) and #2 and #3");
        } else {
            filter.setMaskString("(#0 or #1) and #2 ");
        }
        viewInfo.setFilter(filter);
        SorterItemCollection sorterColl = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo(sorter);
        sorterItemInfo.setSortType("desc".equalsIgnoreCase(sorterType) ? SortType.DESCEND : SortType.ASCEND);
        sorterColl.getSorter().add(sorterItemInfo);
        viewInfo.setSorter(sorterColl);
        queryExcu.setObjectView(viewInfo);
        int totalCount = queryExcu.getRowCount();
        if (isGetAmount) {
            result.put("records", totalCount + "");
            return result;
        }
        IRowSet rowSet = null;
        rowSet = startIndex != null && rowCount != null ? queryExcu.executeQuery(Integer.parseInt(startIndex), Integer.parseInt(rowCount)) : queryExcu.executeQuery();
        ArrayList list = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", rowSet.getString("id"));
                map.put("name", rowSet.getString("unit.name"));
                map.put("number", rowSet.getString("unit.number"));
                map.put("longNumber", rowSet.getString("longNumber"));
                map.put("level", rowSet.getString("level"));
                map.put("isLeaf", rowSet.getString("isLeaf"));
                map.put("displayName", rowSet.getString("displayName"));
                map.put("parent.id", rowSet.getString("parent.id"));
                list.add(map);
            }
            logger.error((Object)("******getOrgStructureList******list.size=" + list.size()));
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        result.put("records", totalCount + "");
        result.put("rows", list);
        return result;
    }
}

