/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.wssc.ImageHandlerCollection;
import com.kingdee.eas.base.wssc.ImageHandlerFactory;
import com.kingdee.eas.base.wssc.ImageHandlerInfo;
import com.kingdee.eas.base.wssc.SSCUnitFacadeFactory;
import com.kingdee.eas.base.wssc.SSCUnitFactory;
import com.kingdee.eas.base.wssc.SSCUnitInfo;
import com.kingdee.eas.base.wssc.app.AbstractSSCUnitControllerBean;
import com.kingdee.eas.base.wssc.image.helper.NoticeImageSysFactory;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysTransferScanUserInfo;
import com.kingdee.eas.base.wssc.image.pojo.ScanUserDataInfo;
import com.kingdee.eas.base.wssc.imageNew.helper.NoticeImageSysFactory_New;
import com.kingdee.eas.base.wssc.imageNew.util.Configure;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SSCUnitControllerBean
extends AbstractSSCUnitControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.app.SSCUnitControllerBean");

    private void noticeDKWS(Context ctx, SSCUnitInfo info) throws BOSException, EASBizException {
        NoticeImageSysTransferScanUserInfo userInfo = new NoticeImageSysTransferScanUserInfo();
        List<ScanUserDataInfo> scanUserData = userInfo.getScanUserData();
        userInfo.setThirdSystemName("EAS");
        userInfo.setScanLocation(info.getName());
        userInfo.setScanUserData(scanUserData);
        userInfo.setCtx(ctx);
        PersonInfo personInfo = null;
        ImageHandlerCollection handler = info.getHandler();
        if (handler != null && handler.size() > 0) {
            for (int i = 0; i < handler.size(); ++i) {
                ScanUserDataInfo data = new ScanUserDataInfo();
                ImageHandlerInfo imageHandlerInfo = ImageHandlerFactory.getLocalInstance(ctx).getImageHandlerInfo((IObjectPK)new ObjectUuidPK(handler.get(i).getId()));
                try {
                    personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(imageHandlerInfo.getHandlerID().getId()));
                }
                catch (Exception e) {
                    logger.error((Object)("id:" + imageHandlerInfo.getHandlerID().getId() + ";" + e.getMessage()), (Throwable)e);
                    personInfo = null;
                }
                if (personInfo == null) continue;
                data.setUserID(personInfo.getId().toString());
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("select id,number,name where isDelete = 0 and isForbidden = 0 and person.id = '" + personInfo.getId().toString() + "' ");
                if (users != null && users.size() > 0) {
                    data.setAccount(users.get(0).getNumber());
                    data.setUserName(users.get(0).getName());
                }
                scanUserData.add(data);
            }
            if (Configure.enableMultiImage(ctx)) {
                if (info.getImageSys() != null) {
                    try {
                        NoticeImageSysFactory_New.getInstance(ctx, info.getImageSys().getId().toString()).transferScanUserInfo(userInfo);
                    }
                    catch (Exception e) {
                        logger.error((Object)("\u4e0d\u592a\u53ef\u80fd\u4f1a\u51fa\u73b0\uff0c\u9664\u975e\u7528\u6237\u7684\u591a\u5f71\u50cf\u7cfb\u7edf\u9009\u62e9\u4e86\u3010\u5176\u4ed6\u5f71\u50cf\u7cfb\u7edf\u3011\uff0c\u4f46\u53c8\u6ca1\u6709\u914d\u7f6e\u5b9e\u73b0\u7c7b\u540d" + e.getMessage()), (Throwable)e);
                    }
                }
            } else {
                NoticeImageSysFactory.getInstance(ctx, "EAS").transferScanUserInfo(userInfo);
            }
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SSCUnitInfo info = (SSCUnitInfo)model;
        this.checkNumberDup(ctx, info);
        this.checkNameDup(ctx, info);
        IObjectPK pk = super._addnew(ctx, model);
        this.noticeDKWS(ctx, info);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SSCUnitInfo info = (SSCUnitInfo)model;
        this.checkNumberDup(ctx, info);
        this.checkNameDup(ctx, info);
        TreeBaseInfo parent = (TreeBaseInfo)((TreeBaseInfo)model).get("parent");
        String id = parent.get("id").toString();
        SSCUnitFacadeFactory.getRemoteInstance().updateIsLeaf(id, 0);
        SSCUnitInfo oldModel = this.getSSCUnitInfo(ctx, pk);
        this.checkAndUpdateParent(ctx, (SSCUnitInfo)model, oldModel);
        super._update(ctx, pk, model);
        this.noticeDKWS(ctx, info);
    }

    private void checkAndUpdateParent(Context ctx, SSCUnitInfo model, SSCUnitInfo oldModel) throws EASBizException, BOSException {
        if (oldModel.getParent() == null || model.getParent() != null && oldModel.getParent().getId().equals((Object)model.getParent().getId())) {
            return;
        }
        String updateParentSQL = "update T_WSC_SSCUnit set FIsLeaf = 1 where fid = ? and not exists(select fid from T_WSC_SSCUnit where fparentid = ? and fid <> ?)";
        DbUtil.execute((Context)ctx, (String)updateParentSQL, (Object[])new Object[]{oldModel.getParent().getId().toString(), oldModel.getParent().getId().toString(), oldModel.getId().toString()});
    }

    public void checkNumberDup(Context ctx, SSCUnitInfo info) throws EASBizException, BOSException {
        String number = info.getNumber();
        if (null != info.getId() && StringUtils.isNotBlank((String)info.getId().toString()) ? SSCUnitFactory.getLocalInstance(ctx).exists("where number ='" + number + "' and id !='" + info.getId().toString() + "'") : SSCUnitFactory.getLocalInstance(ctx).exists("where number ='" + number + "'")) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{number});
        }
    }

    private void checkNameDup(Context ctx, SSCUnitInfo info) throws EASBizException, BOSException {
        String name = info.getName();
        if (null != info.getId() && StringUtils.isNotBlank((String)info.getId().toString()) ? SSCUnitFactory.getLocalInstance(ctx).exists("where name ='" + name + "' and id !='" + info.getId().toString() + "'") : SSCUnitFactory.getLocalInstance(ctx).exists("where name ='" + name + "'")) {
            throw new EASBizException(EASBizException.CHECKNAMEDUP, new Object[]{name});
        }
    }
}

