/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app.dynamicthreadpool;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.app.dynamicthreadpool.AbstractDynamicThreadPoolFacadeControllerBean;
import com.kingdee.eas.base.wssc.dynamicthreadpool.DynamicThreadPoolExecutor;
import com.kingdee.eas.base.wssc.dynamicthreadpool.DynamicThreadPoolManager;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.utils.DateUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynamicThreadPoolFacadeControllerBean
extends AbstractDynamicThreadPoolFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.app.dynamicthreadpool.DynamicThreadPoolFacadeControllerBean");

    @Override
    protected String _getAllDynamicThreadPool(Context ctx) throws BOSException, EASBizException {
        String allThreadPoolInfo = DynamicThreadPoolManager.getAllThreadPoolInfo();
        return allThreadPoolInfo;
    }

    @Override
    protected String _getDynamicThreadPool(Context ctx, String applicationName, String threadpoolName) throws BOSException, EASBizException {
        DynamicThreadPoolManager manager = DynamicThreadPoolManager.getInstance();
        DynamicThreadPoolExecutor threadPoolExecutor = manager.getThreadPoolExecutor(applicationName, threadpoolName);
        List<ThreadPoolProperties> threadPoolProperties = manager.getDynamicThreadPoolProperties().getExecutors();
        Map result = new HashMap();
        applicationName = StringUtils.isEmpty((String)applicationName) ? "SSC" : applicationName;
        for (int i = 0; i < threadPoolProperties.size(); ++i) {
            if (!threadPoolProperties.get(i).getApplicationName().equals(applicationName) || !threadPoolProperties.get(i).getThreadPoolName().equals(threadpoolName)) continue;
            result = manager.getThreadPoolInfo(threadPoolProperties.get(i), threadPoolExecutor);
            break;
        }
        return JSON.toJSONString(result);
    }

    @Override
    protected String _getAllThreadPool(Context ctx, String beginDate, String endDate) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _getThreadPool(Context ctx, String applicationName, String threadPoolName, String beginDate, String endDate) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _refreshAllThreadPool(Context ctx, String attributes) throws BOSException, EASBizException {
        this.refreshThreadPoolProperties(null, null, attributes);
        return null;
    }

    @Override
    protected String _refreshThreadPool(Context ctx, String applicationName, String threadPoolName, String attributes) throws BOSException, EASBizException {
        this.refreshThreadPoolProperties(applicationName, threadPoolName, attributes);
        return null;
    }

    @Override
    protected String _getThreadPoolAlarm(Context ctx, String applicationName, String threadPoolName) throws BOSException, EASBizException {
        String sql = "select applicationName,threadPoolName,msg,createTime from T_WSC_ThreadAlarm where applicationName = ? and threadPoolName = ? order by createTime desc ";
        ArrayList result = new ArrayList();
        HashMap<String, String> map = null;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{applicationName, threadPoolName});
            if (rowSet != null) {
                while (rowSet.next()) {
                    map = new HashMap<String, String>();
                    map.put("applicationName", rowSet.getString("applicationName"));
                    map.put("threadPoolName", rowSet.getString("threadPoolName"));
                    map.put("msg", rowSet.getString("msg"));
                    map.put("createTime", rowSet.getString("createTime"));
                    result.add(map);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return JSON.toJSONString(result);
    }

    @Override
    protected String _getThreadExecuteRecord(Context ctx, String applicationName, String threadPoolName, String status, String beginDate, String endDate) throws BOSException, EASBizException {
        String sql = "select applicationName,threadPoolName,threadName,className,status,exceptionInfo,beginDate,endDate,beginMem,endMem  from T_WSC_ThreadExecuteRecord where applicationName = ? and threadPoolName = ? ";
        ArrayList result = new ArrayList();
        HashMap<String, String> map = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            IRowSet rowSet;
            Object[] obj = new Object[]{applicationName, threadPoolName};
            if (!StringUtils.isEmpty((String)status)) {
                sql = sql + " and status = ? ";
                obj = new Object[]{applicationName, threadPoolName, status};
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = sql + " order by beginDate desc"), (Object[])obj)) != null) {
                while (rowSet.next()) {
                    map = new HashMap<String, String>();
                    map.put("applicationName", rowSet.getString("applicationName"));
                    map.put("threadPoolName", rowSet.getString("threadPoolName"));
                    map.put("threadName", rowSet.getString("threadName"));
                    map.put("className", rowSet.getString("className"));
                    map.put("status", rowSet.getString("status").equals("0") ? "\u5931\u8d25" : "\u6210\u529f");
                    map.put("exceptionInfo", rowSet.getString("exceptionInfo"));
                    map.put("beginDate", rowSet.getString("beginDate"));
                    map.put("endDate", rowSet.getString("endDate"));
                    String betweenTime = DateUtils.getBetweenTime(sdf.parse(rowSet.getString("endDate")), sdf.parse(rowSet.getString("beginDate")), 1);
                    map.put("costTime", betweenTime);
                    map.put("beginMem", rowSet.getString("beginMem"));
                    map.put("endMem", rowSet.getString("endMem"));
                    double costMem = (Integer.parseInt(rowSet.getString("beginMem")) - Integer.parseInt(rowSet.getString("endMem"))) / 1024;
                    map.put("costMem", String.format(costMem < 0.0 ? "0" : costMem + "", "%.2f"));
                    result.add(map);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return JSON.toJSONString(result);
    }

    private void refreshThreadPoolProperties(String applicationName, String threadPoolName, String attributes) throws EASBizException, BOSException {
        Map map = (Map)JSON.parseObject((String)attributes, Map.class);
        DynamicThreadPoolManager dynamicThreadPoolManager = DynamicThreadPoolManager.getInstance();
        List<ThreadPoolProperties> threadPoolProperties = dynamicThreadPoolManager.getDynamicThreadPoolProperties().getExecutors();
        ThreadPoolProperties properties = null;
        for (int i = 0; i < threadPoolProperties.size(); ++i) {
            if (!threadPoolProperties.get(i).getApplicationName().equals(applicationName) || !threadPoolProperties.get(i).getThreadPoolName().equals(threadPoolName)) continue;
            properties = threadPoolProperties.get(i);
            break;
        }
        if (properties == null) {
            throw new EASBizException(new NumericExceptionSubItem("001", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ebf\u7a0b\u6c60\uff1a" + applicationName + "-" + threadPoolName));
        }
        if (map.get("corepoolsize") != null) {
            properties.setCorePoolSize(Integer.parseInt(map.get("corepoolsize").toString()));
        }
        if (map.get("maximumpoolsize") != null) {
            properties.setMaximumPoolSize(Integer.parseInt(map.get("maximumpoolsize").toString()));
        }
        if (map.get("queueCapacity") != null) {
            properties.setQueueCapacity(Integer.parseInt(map.get("queueCapacity").toString()));
            properties.setQueueCapacityThreshold(Math.round((float)((double)Integer.parseInt(map.get("queueCapacity").toString()) * ThreadPoolProperties.threshold)));
        }
        dynamicThreadPoolManager.refreshThreadPoolExecutor(properties);
    }
}

