/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app.notice.assignjob;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgSourceStatus;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.wssc.app.notice.IWsscNotice;
import com.kingdee.eas.base.wssc.app.notice.assignjob.YzjMessagePusher;
import com.kingdee.eas.base.wssc.dynamicthreadpool.DynamicThreadPoolManager;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.DynamicThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolBuilder;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.enums.QueueTypeEnum;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class AssignJobNoticeImpl
implements IWsscNotice {
    protected static Logger logger = Logger.getLogger(AssignJobNoticeImpl.class);
    private static volatile ExecutorService pool = null;

    @Override
    public void notice(final Context ctx, final String param) throws BOSException {
        if (pool == null) {
            pool = this.getThreadPool(ctx);
        }
        pool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String[] checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)"ASSIGNJB", IWsscNotice.class);
                    ArrayList<IWsscNotice> noticeList = new ArrayList<IWsscNotice>();
                    if (checkers != null && checkers.length > 0) {
                        for (int i = 0; i < checkers.length; ++i) {
                            try {
                                noticeList.add((IWsscNotice)Class.forName(checkers[i]).newInstance());
                                continue;
                            }
                            catch (Exception e) {
                                logger.error((Object)(checkers[i] + ";" + e.getMessage()), (Throwable)e);
                            }
                        }
                    }
                    JSONArray array = JSONArray.parseArray((String)param);
                    Message message = MessageFactory.newMessage();
                    for (int i = 0; i < array.size(); ++i) {
                        if ("true".equalsIgnoreCase(array.getJSONObject(i).getString("isReceiveAssignJobMsg"))) {
                            message.setStringHeader("senderId", "Wp3rRSFxRCaPFjuE2apQjRO33n8=");
                            message.setStringHeader("receiver", array.getJSONObject(i).getString("userId"));
                            message.setStringHeader("solution", ctx.getSolution());
                            message.setStringHeader("databaseCenter", ctx.getAIS());
                            message.setStringHeader("assignid", array.getJSONObject(i).getString("assignId"));
                            message.setStringHeader("sourceID", array.getJSONObject(i).getString("assignId"));
                            message.setBooleanHeader("isSendCommon", true);
                            message.setLocaleStringHeader("sender", "\u5171\u4eab\u4e2d\u5fc3\u7ba1\u7406\u5458", ctx.getLocale());
                            message.setLocaleStringHeader("initiatorName", "\u5171\u4eab\u4e2d\u5fc3\u7ba1\u7406\u5458", ctx.getLocale());
                            message.setLocaleStringHeader("title", "\u5171\u4eab\u670d\u52a1\u4e2d\u5fc3\u4efb\u52a1\u5f85\u5904\u7406\u63d0\u9192", ctx.getLocale());
                            message.setLocaleStringHeader("body", "\u60a8\u6709\u65b0\u7684\u5171\u4eab\u4efb\u52a1\uff1a" + array.getJSONObject(i).getString("subject") + "\uff0c\u8bf7\u5230\u5171\u4eab\u4efb\u52a1\u6c60\u8fdb\u884c\u5904\u7406\uff01", ctx.getLocale());
                            IBMCMessage iMessage = BMCMessageFactory.getLocalInstance((Context)ctx);
                            iMessage.addnew((CoreBaseInfo)AssignJobNoticeImpl.this.transformMessage(ctx, message));
                            new YzjMessagePusher().pushMessage(ctx, message);
                            continue;
                        }
                        if (noticeList == null || noticeList.size() <= 0) continue;
                        for (int j = 0; j < noticeList.size(); ++j) {
                            ((IWsscNotice)noticeList.get(j)).notice(ctx, param);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private synchronized ExecutorService getThreadPool(Context ctx) throws BOSException {
        if (pool == null) {
            ThreadPoolProperties properties;
            String threadPoolName = ctx.getAIS() + "\uff1b\u4efb\u52a1\u5206\u914d\u540e\u901a\u77e5\u7ebf\u7a0b\u6c60";
            String applicationName = "\u5171\u4eab\u5e73\u53f0\u4efb\u52a1\u5206\u914d";
            DynamicThreadPoolManager manager = DynamicThreadPoolManager.getInstance();
            DynamicThreadPoolProperties dynamicThreadPoolProperties = manager.getDynamicThreadPoolProperties();
            if (!dynamicThreadPoolProperties.exists(properties = new ThreadPoolBuilder().ctx(ctx).applicationName(applicationName).threadPoolName(threadPoolName).corePoolSize(6).maximumPoolSize(6).queueCapacity(5000).keepAliveTime(0L).timeUnit(TimeUnit.SECONDS).queueType(QueueTypeEnum.LINKED_BLOCKING_QUEUE).getProperties())) {
                dynamicThreadPoolProperties.getExecutors().add(properties);
            }
            manager.createThreadPoolExecutor(dynamicThreadPoolProperties);
            pool = manager.getThreadPoolExecutor(applicationName, threadPoolName);
        }
        return pool;
    }

    private BMCMessageInfo transformMessage(Context ctx, Message message) {
        BMCMessageInfo messageInfo = new BMCMessageInfo();
        messageInfo.setType(MsgType.getEnum((int)message.getIntHeader("type")));
        messageInfo.setBizType(MsgBizType.getEnum((int)message.getIntHeader("bizType")));
        if (messageInfo.getBizType() == MsgBizType.WORKFLOW && message.getStringHeader("category") == null) {
            messageInfo.setCategory(MsgBizType.WORKFLOW.getName().toLowerCase());
        } else {
            messageInfo.setCategory(message.getStringHeader("category"));
        }
        messageInfo.setExtendParam(message.getStringHeader("extendParam"));
        String forewarnDynVarsId = message.getStringHeader("forewarnDynVarsId");
        if (!StringUtils.isEmpty((String)forewarnDynVarsId)) {
            messageInfo.setBizCustomizedFlag(forewarnDynVarsId);
        }
        messageInfo.setDefaultLocale(ctx.getLocale());
        int priority = message.getIntHeader("priority");
        if (priority != 0 && priority != 10 && priority != 20) {
            priority = 10;
        }
        messageInfo.setPriority(MsgPriority.getEnum((int)priority));
        messageInfo.setSourceStatus(MsgSourceStatus.getEnum((int)message.getIntHeader("sourceStatus")));
        messageInfo.setSendTime(new Timestamp(message.getTimestamp()));
        messageInfo.setStatus(MsgStatus.UNREADED);
        messageInfo.setSender(message.getLocaleStringHeader("initiatorName", ctx.getLocale()), ctx.getLocale());
        int type = message.getIntHeader("type");
        if (type == 0 && !"WfAdmin".equals(message.getStringHeader("sender"))) {
            messageInfo.setSender(message.getLocaleStringHeader("sender", ctx.getLocale()), ctx.getLocale());
        }
        messageInfo.setTitle(message.getLocaleStringHeader("title", ctx.getLocale()), ctx.getLocale());
        if (message.getLocaleStringHeader("body", ctx.getLocale()) != null) {
            messageInfo.setBody(message.getLocaleStringHeader("body", ctx.getLocale()), ctx.getLocale());
        }
        messageInfo.setReceiver(message.getStringHeader("receiver"));
        if (message.getStringHeader("senderId") != null) {
            messageInfo.setSenderId(message.getStringHeader("senderId"));
        } else if (message.getStringHeader("initiatorId") != null) {
            messageInfo.setSenderId(message.getStringHeader("initiatorId"));
        }
        return messageInfo;
    }
}

