/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app.notice.assignjob;

import com.kingdee.eas.base.wssc.app.notice.api.IMessageSection;
import com.kingdee.eas.base.wssc.util.common.SignUtil;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class YzjMessageHead
implements IMessageSection {
    private static Logger logger = Logger.getLogger(YzjMessageHead.class);
    private static String PUSH_ALL_USERS = "PUSH_ALL_USERS";
    private Map<String, Object> from = null;
    private Map<String, Object> to = null;
    private String eid = null;

    public YzjMessageHead(String eid) {
        this.eid = eid;
    }

    @Override
    public void makeContent(Map<String, Object> fields) throws NullPointerException {
        if (fields != null && fields.containsKey("account") && fields.containsKey("signtime") && fields.containsKey("users")) {
            this.makeMessage("no", this.eid, true);
            this.makeMessage("pub", fields.get("account"), true);
            String signtime = String.valueOf(System.currentTimeMillis());
            this.makeMessage("time", signtime, true);
            String pubacckey = (String)fields.get("pubacckey");
            String openid = (String)fields.get("account");
            SecureRandom secureRandom = new SecureRandom();
            byte[] seed = SecureRandom.getSeed(16);
            secureRandom.setSeed(seed);
            int nonce = secureRandom.nextInt(Integer.MAX_VALUE);
            secureRandom.nextBytes(seed);
            this.makeMessage("nonce", nonce, true);
            String pubtoken = SignUtil.getPubtoken(this.eid, openid, pubacckey, String.valueOf(nonce), signtime);
            this.makeMessage("pubtoken", pubtoken, true);
            this.makeMessage("no", this.eid, false);
            String code = (String)fields.get("code");
            if (code == null || code.trim().equals("")) {
                code = "0";
            }
            this.makeMessage("code", code, false);
            List users = (List)fields.get("users");
            if (users == null) {
                throw new NullPointerException("user list is null or empty");
            }
            if (users.size() != 1 || !((String)users.get(0)).equals(PUSH_ALL_USERS)) {
                this.makeMessage("user", fields.get("users"), false);
            }
        }
    }

    @Override
    public Map<String, Object> getContent() {
        ArrayList<Map<String, Object>> to = new ArrayList<Map<String, Object>>();
        to.add(this.to);
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("from", this.from);
        content.put("to", to);
        return content;
    }

    @Override
    public boolean hasReady() {
        if (this.from != null && this.to != null) {
            return true;
        }
        logger.debug((Object)"message head field has not ready");
        return false;
    }

    protected void makeMessage(String key, Object value, boolean isFromInfo) {
        if (isFromInfo) {
            if (this.from == null) {
                this.from = new HashMap<String, Object>();
            }
            this.from.put(key, value);
        } else {
            if (this.to == null) {
                this.to = new HashMap<String, Object>();
            }
            this.to.put(key, value);
        }
    }

    protected Object getMessage(String key, boolean isFrom) {
        Map<String, Object> target = isFrom ? this.from : this.to;
        return target == null ? "" : target.get(key);
    }

    @Override
    public boolean isSupportMultiEntries() {
        return false;
    }
}

