/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.app.util.WSSCUtils;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CQSysHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.util.CQSysHelper");
    private static String accessToken = "";
    private static String expireTime = "";
    private static String cqUrl = "";
    private static String appId = "";
    private static String appSecuret = "";
    private static String accountId = "";
    private static String cqUser = "";
    private static String userType = "";

    public void test() {
        String token = CQSysHelper.getToken();
        Map<String, String> cqImageInfo = CQSysHelper.getCQImageInfo(token, "KD051-100001-20180901-914421143073478656");
    }

    public static Map<String, String> getCreatorAndPhone(Context ctx, String imageNumber) throws BOSException {
        try {
            CQSysHelper.getCQLoginParams(ctx);
        }
        catch (BOSException e) {
            throw new BOSException("\u68c0\u67e5\u53c2\u6570\u914d\u7f6e", (Throwable)e);
        }
        String token = CQSysHelper.getToken();
        return CQSysHelper.getCQImageInfo(token, imageNumber);
    }

    private static void getCQLoginParams(Context ctx) throws BOSException {
        if (StringUtils.isEmpty((String)cqUrl) || StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)appSecuret) || StringUtils.isEmpty((String)cqUser) || StringUtils.isEmpty((String)userType)) {
            cqUrl = WSSCUtils.getConfigValue(ctx, "cqUrl");
            appId = WSSCUtils.getConfigValue(ctx, "appId");
            appSecuret = WSSCUtils.getConfigValue(ctx, "appSecuret");
            accountId = WSSCUtils.getConfigValue(ctx, "accountId");
            cqUser = WSSCUtils.getConfigValue(ctx, "cqUser");
            userType = WSSCUtils.getConfigValue(ctx, "userType");
        }
        if (StringUtils.isEmpty((String)cqUrl) || StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)appSecuret) || StringUtils.isEmpty((String)cqUser) || StringUtils.isEmpty((String)userType)) {
            logger.error((Object)"\u53c2\u6570\u672a\u914d\u9f50\u6216\u8005key\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
    }

    private static Map<String, String> getCQImageInfo(String accessToken, String imageNumber) {
        String url = cqUrl + "/api/image/getImageInfo.do?access_token=" + accessToken;
        StringBuffer xmlData = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xmlData.append("<ImageList>");
        xmlData.append(String.format("<Image imageNo= \"%s\" billNo= \"%s\" />", imageNumber, ""));
        xmlData.append("</ImageList>");
        logger.error((Object)("\u82cd\u7a79\u83b7\u53d6\u5f71\u50cf\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a" + xmlData.toString()));
        String httpResultStr = CQSysHelper.dopost(url, xmlData.toString(), "utf-8");
        JSONObject result = JSONObject.parseObject((String)httpResultStr);
        String data = null;
        if (result != null && "success".equals(result.getString("state"))) {
            data = (String)result.get((Object)"data");
        }
        Map<String, String> creatorMessages = CQSysHelper.getCreatorMessages(data);
        return creatorMessages;
    }

    private static Map<String, String> getCreatorMessages(String inputXML) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)inputXML)) {
            logger.error((Object)"\u4ece\u82cd\u7a79getimageinfo\u83b7\u53d6value\u4e3a\u7a7a");
            return map;
        }
        try {
            Document document = DocumentHelper.parseText((String)inputXML);
            Element root = document.getRootElement().element("Image");
            Attribute applier = root.attribute("applier");
            Attribute applierPhone = root.attribute("applierPhone");
            Attribute applierEmail = root.attribute("applierEmail");
            Attribute billNumber = root.attribute("billNumber");
            Attribute applierName = root.attribute("applierName");
            map.put("applier", applier == null ? "" : applier.getValue());
            map.put("applierPhone", applierPhone == null ? "" : applierPhone.getValue());
            map.put("applierEmail", applierEmail == null ? "" : applierEmail.getValue());
            map.put("billNumber", billNumber == null ? "" : billNumber.getValue());
            map.put("applierName", applierName == null ? "" : applierName.getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private static String getToken() {
        JSONObject jsonObject;
        if (!StringUtils.isEmpty((String)accessToken) && !StringUtils.isEmpty((String)expireTime) && Long.parseLong(expireTime) > System.currentTimeMillis()) {
            return accessToken;
        }
        String getappToken = CQSysHelper.getappToken();
        if (StringUtils.isEmpty((String)getappToken)) {
            cqUrl = "";
            logger.error((Object)"\u83b7\u53d6apptoken\u5931\u8d25\uff0c\u786e\u8ba4\u53c2\u6570\u6709\u6548");
        }
        if ((jsonObject = CQSysHelper.getAccessToken(getappToken)) == null) {
            cqUrl = "";
            logger.error((Object)"\u83b7\u53d6accesstoken\u5931\u8d25\uff0c\u786e\u8ba4\u53c2\u6570\u6709\u6548");
        }
        accessToken = jsonObject.getString("access_token");
        expireTime = jsonObject.getString("expire_time");
        return accessToken;
    }

    private static String getappToken() {
        JSONObject appTokenResultData;
        JSONObject appTokenParam = new JSONObject();
        appTokenParam.put("appId", (Object)appId);
        appTokenParam.put("appSecuret", (Object)appSecuret);
        if (!StringUtils.isEmpty((String)accountId)) {
            appTokenParam.put("accountId", (Object)accountId);
        }
        appTokenParam.put("language", (Object)"zh_CN");
        String appTokenUrl = cqUrl + "/api/getAppToken.do";
        JSONObject appTokenResult = null;
        String apptokenPostResult = CQSysHelper.dopost(appTokenUrl, appTokenParam.toJSONString(), "utf-8");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)apptokenPostResult)) {
            appTokenResult = JSON.parseObject((String)apptokenPostResult);
        }
        if (appTokenResult != null && "success".equals(appTokenResult.getString("state")) && (appTokenResultData = appTokenResult.getJSONObject("data")) != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)appTokenResultData.getString("app_token"))) {
            return appTokenResultData.getString("app_token");
        }
        return "";
    }

    private static JSONObject getAccessToken(String appToken) {
        JSONObject appTokenResultData;
        JSONObject accessTokenParam = new JSONObject();
        accessTokenParam.put("user", (Object)cqUser);
        accessTokenParam.put("apptoken", (Object)appToken);
        if (!StringUtils.isEmpty((String)accountId)) {
            accessTokenParam.put("accountId", (Object)accountId);
        }
        accessTokenParam.put("usertype", (Object)"Mobile");
        String accessTokenUrl = cqUrl + "/api/login.do";
        String accessTokenResult = CQSysHelper.dopost(accessTokenUrl, accessTokenParam.toJSONString(), "utf-8");
        JSONObject acessTokenResultJson = JSONObject.parseObject((String)accessTokenResult);
        if (accessTokenResult != null && "success".equals(acessTokenResultJson.getString("state")) && (appTokenResultData = acessTokenResultJson.getJSONObject("data")) != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)appTokenResultData.getString("access_token"))) {
            return appTokenResultData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dopost(String url, String params, String charSet) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        StringEntity entity = new StringEntity(params, charSet);
        entity.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
        entity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
            StatusLine status = response.getStatusLine();
            int state = status.getStatusCode();
            if (state == 200) {
                String jsonString;
                HttpEntity responseEntity = response.getEntity();
                String string = jsonString = EntityUtils.toString((HttpEntity)responseEntity);
                return string;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            try {
                httpclient.close();
            }
            catch (IOException iOException) {}
        }
        return "";
    }
}

