/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.autoupdater.util;

import java.io.File;
import java.util.Comparator;

public class MyFileComparator
implements Comparator {
    private boolean case_sensitive;

    public MyFileComparator() {
        this(false);
    }

    public MyFileComparator(boolean is_case_sensitive) {
        this.case_sensitive = is_case_sensitive;
    }

    protected int compareTimes(File f1, File f2) {
        long time2;
        long time1 = f1.lastModified();
        if (time1 > (time2 = f2.lastModified())) {
            return -1;
        }
        if (time1 < time2) {
            return 1;
        }
        return 0;
    }

    private int compareFileNames(File f1, File f2) {
        String name1 = f1.getName();
        String name2 = f2.getName();
        return this.case_sensitive ? name1.compareTo(name2) : name1.compareToIgnoreCase(name2);
    }

    public int compare(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            throw new ClassCastException("Null\tparameter");
        }
        if (!(o1 instanceof File) || !(o2 instanceof File)) {
            if (!(o1 instanceof String) || !(o2 instanceof String)) {
                throw new ClassCastException("Parameters are not files");
            }
            String name1 = (String)o1;
            String name2 = (String)o2;
            return this.case_sensitive ? name1.compareTo(name2) : name1.compareToIgnoreCase(name2);
        }
        File f1 = (File)o1;
        File f2 = (File)o2;
        return this.compareFileNames(f1, f2);
    }

    @Override
    public boolean equals(Object o) {
        return this.getClass() == o.getClass();
    }

    public boolean isCaseSensitive() {
        return this.case_sensitive;
    }

    public void setCaseSensitive(boolean is_case_sensitive) {
        this.case_sensitive = is_case_sensitive;
    }
}

