/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.autoupdater.util;

import com.kingdee.eas.cp.autoupdater.util.MyProperties;
import com.kingdee.eas.cp.autoupdater.util.OddsJARUtil;
import com.twmacinta.util.MD5;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ServerOddsGenerator {
    private static Logger logger = Logger.getLogger(ServerOddsGenerator.class);
    public static String CONSOLE = "CONSOLE";
    public static String BIM = "BIM";
    public static String RESOURCESET_FILENAME = "resourceSet.properties";
    public static String ODDS_CONFIG_FILENAME = "oddsConfig.properties";
    public static String SERVIER_ODDS_FILENAME = "serverodds.properties";
    public static String UPDATE_ODDS_LIST_FILENAME = "updateodds.lst";
    public static String fileserverDir = "";
    private static String useOddsJarFunction = null;
    public static int maxOddsJarCount = 5;
    public static String[] oddsDemandResPathArray = null;
    public static String BIM_MD5 = "md5.properties";

    public static void generateOddsJARforConsole(String oldJarFileName, String newJarFileName) {
        ServerOddsGenerator.generateOddsJAR(oldJarFileName, newJarFileName, CONSOLE);
    }

    public static void generateOddsJARforBIM(String oldJarFileName, String newJarFileName) {
        ServerOddsGenerator.generateOddsJAR(oldJarFileName, newJarFileName, BIM);
    }

    public static void batchGenerateOddsJARforBIM(String oldJarPath, String newJarPath) {
        File newPath = new File(newJarPath);
        File[] newFiles = newPath.listFiles();
        if (newFiles == null || newFiles.length == 0) {
            return;
        }
        if (!"/".equals(Character.valueOf(oldJarPath.charAt(oldJarPath.length() - 1))) && !"\\".equals(Character.valueOf(oldJarPath.charAt(oldJarPath.length() - 1)))) {
            oldJarPath = oldJarPath + "/";
        }
        if (!"/".equals(Character.valueOf(newJarPath.charAt(newJarPath.length() - 1))) && !"\\".equals(Character.valueOf(newJarPath.charAt(newJarPath.length() - 1)))) {
            newJarPath = newJarPath + "/";
        }
        for (int i = 0; i < newFiles.length; ++i) {
            ServerOddsGenerator.generateOddsJAR(oldJarPath + newFiles[i].getName(), newJarPath + newFiles[i].getName(), BIM);
        }
    }

    public static void generateOddsJAR(String oldJarFileName, String newJarFileName, String callFrom) {
        int i;
        File newJarFile;
        long timeStart = System.currentTimeMillis();
        if (oldJarFileName == null) {
            oldJarFileName = "";
        }
        if (newJarFileName == null || newJarFileName.trim().length() == 0) {
            ServerOddsGenerator.logInfo("\u65b0\u5305\u4e3a\u7a7a\u3002");
        }
        oldJarFileName = oldJarFileName.replace('\\', '/');
        newJarFileName = newJarFileName.replace('\\', '/');
        ServerOddsGenerator.readConfig();
        if (BIM.equalsIgnoreCase(callFrom)) {
            fileserverDir = fileserverDir.substring(0, fileserverDir.indexOf("/server")) + fileserverDir.substring(fileserverDir.indexOf("/server/deploy/"));
        }
        if (useOddsJarFunction == null || !useOddsJarFunction.equalsIgnoreCase("true")) {
            return;
        }
        Properties serverOddsProperties = ServerOddsGenerator.getServerOddsProperties();
        boolean needGenerateOddsJAR = ServerOddsGenerator.checkNeedGenerateOddsJAR(newJarFileName);
        ServerOddsGenerator.logInfo("needGenerateOddsJAR: " + needGenerateOddsJAR);
        if (!needGenerateOddsJAR) {
            return;
        }
        String key = null;
        if (newJarFileName.indexOf("/lib/") > 0) {
            key = newJarFileName.substring(newJarFileName.indexOf("/lib/"));
        } else if (newJarFileName.indexOf("/metas/") > 0) {
            key = newJarFileName.substring(newJarFileName.indexOf("/metas/"));
        } else {
            return;
        }
        ServerOddsGenerator.logInfo("key: " + key);
        String versionStr = serverOddsProperties.getProperty(key);
        ServerOddsGenerator.logInfo("versionStr: " + versionStr);
        if (versionStr == null || versionStr.trim().length() == 0 || oldJarFileName == null || oldJarFileName.trim().length() == 0) {
            versionStr = "1";
            serverOddsProperties.put(key, versionStr);
            ServerOddsGenerator.updateServerOddsProperties(serverOddsProperties);
            if (oldJarFileName == null || oldJarFileName.trim().length() == 0) {
                ServerOddsGenerator.logInfo("oldJarFileName: " + oldJarFileName);
                return;
            }
        }
        ServerOddsGenerator.logInfo("versionStr: " + versionStr);
        try {
            String oldJarFileMD5 = ServerOddsGenerator.getJarFileMD5(oldJarFileName, callFrom);
            String newJarFileMD5 = ServerOddsGenerator.getJarFileMD5(newJarFileName, callFrom);
            ServerOddsGenerator.logInfo("oldJarFileName: " + oldJarFileName + " MD5: " + oldJarFileMD5 + "\n newJarFileName: " + newJarFileName + " MD5: " + newJarFileMD5);
            if (newJarFileMD5.equals(oldJarFileMD5)) {
                ServerOddsGenerator.logInfo("\u8865\u4e01\u4e2d\u7684JAR\u4e0e\u670d\u52a1\u7aef\u73b0\u6709JAR\u4e00\u6837\uff0c\u65e0\u9700\u751f\u6210\u5dee\u5f02\u5305\u3002");
                return;
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return;
        }
        Properties updateOddsListProperties = ServerOddsGenerator.getUpdateOddsListProperties();
        int versionInt = 0;
        int newVersionInt = 0;
        try {
            versionInt = Integer.parseInt(versionStr);
            newVersionInt = versionInt + 1;
        }
        catch (Exception e) {
            logger.error((Object)("\u8d44\u6e90 " + key + " \u7248\u672c\u53f7 " + versionStr + " \u65e0\u6548\uff01\u5c06\u7248\u672c\u53f7\u7f6e\u4e3a 1 ."));
            serverOddsProperties.put(key, "1");
            ServerOddsGenerator.updateServerOddsProperties(serverOddsProperties);
            updateOddsListProperties.put(key, "");
            ServerOddsGenerator.updateUpdateOddsListProperties(updateOddsListProperties);
            return;
        }
        ServerOddsGenerator.logInfo("newVersionInt: " + newVersionInt);
        serverOddsProperties.put(key, new Integer(newVersionInt).toString());
        ServerOddsGenerator.updateServerOddsProperties(serverOddsProperties);
        String oddsJarFileName = null;
        String jarFileName = newJarFileName.substring(newJarFileName.lastIndexOf("/"), newJarFileName.lastIndexOf("."));
        boolean generatoOddsJARSuccesed = true;
        if (CONSOLE.equals(callFrom)) {
            oddsJarFileName = fileserverDir + "lib/odds/patch" + jarFileName + "-" + new Integer(versionInt).toString() + "-" + new Integer(newVersionInt).toString() + ".jar";
        } else if (BIM.equals(callFrom)) {
            oddsJarFileName = fileserverDir + "lib/odds/sp" + jarFileName + "-" + new Integer(versionInt).toString() + "-" + new Integer(newVersionInt).toString() + ".jar";
        }
        generatoOddsJARSuccesed = OddsJARUtil.generatoOddsJAR(oldJarFileName, newJarFileName, oddsJarFileName);
        File oldJarFile = new File(oldJarFileName);
        if (oldJarFile.exists()) {
            ServerOddsGenerator.logInfo("\u65e7\u5305 " + oldJarFile.getName() + " \u7684\u5927\u5c0f\u4e3a  " + oldJarFile.length());
        }
        if ((newJarFile = new File(newJarFileName)).exists()) {
            ServerOddsGenerator.logInfo("\u65b0\u5305 " + newJarFile.getName() + " \u7684\u5927\u5c0f\u4e3a  " + newJarFile.length());
        }
        if (!generatoOddsJARSuccesed) {
            ServerOddsGenerator.logInfo("\u751f\u6210\u5dee\u5f02\u5305\u5931\u8d25\uff0c\u5c06\u6e05\u7a7a\u539f\u6709\u5dee\u5f02\u5305\u3002");
        }
        String oddsJarFileMD5 = "";
        try {
            File oddsJarFile = new File(oddsJarFileName);
            if (oddsJarFile.exists()) {
                ServerOddsGenerator.logInfo("\u5dee\u5f02\u5305 " + oddsJarFile.getName() + " \u7684\u5927\u5c0f\u4e3a  " + oddsJarFile.length());
            }
            if (generatoOddsJARSuccesed) {
                oddsJarFileMD5 = MD5.asHex(MD5.getHash(oddsJarFile));
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        String updateOddsList = (String)updateOddsListProperties.get(key);
        String newUpdateOddsList = "";
        if (generatoOddsJARSuccesed && oddsJarFileName != null && oddsJarFileName.length() > 0) {
            newUpdateOddsList = oddsJarFileName.substring(oddsJarFileName.indexOf("/lib/")) + "," + oddsJarFileMD5;
        }
        String[] updateOddsArray = new String[]{};
        if (updateOddsList != null && updateOddsList.trim().length() > 0) {
            updateOddsArray = updateOddsList.split(";");
        }
        for (i = updateOddsArray.length - 1; generatoOddsJARSuccesed && i >= 0; --i) {
            String oldUpdateOddsJarFileName = updateOddsArray[i].substring(0, updateOddsArray[i].indexOf(","));
            String newUpdateOddsJarFileName = oldUpdateOddsJarFileName.substring(0, oldUpdateOddsJarFileName.lastIndexOf("-") + 1) + new Integer(newVersionInt).toString() + ".jar";
            OddsJARUtil.mergeOddsJAR(fileserverDir + oldUpdateOddsJarFileName, oddsJarFileName, fileserverDir + newUpdateOddsJarFileName);
            File oddsJarFile = new File(fileserverDir + newUpdateOddsJarFileName);
            if (oddsJarFile.exists()) {
                ServerOddsGenerator.logInfo("\u5dee\u5f02\u5305 " + oddsJarFile.getName() + " \u7684\u5927\u5c0f\u4e3a  " + oddsJarFile.length());
            }
            String newUpdateOddsJarMD5 = "";
            File newUpdateOddsJarFile = new File(fileserverDir + newUpdateOddsJarFileName);
            try {
                newUpdateOddsJarMD5 = MD5.asHex(MD5.getHash(newUpdateOddsJarFile));
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
                continue;
            }
            newUpdateOddsList = newUpdateOddsJarFileName + "," + newUpdateOddsJarMD5 + ";" + newUpdateOddsList;
            if (updateOddsArray.length - i + 1 >= maxOddsJarCount) break;
        }
        updateOddsListProperties.put(key, newUpdateOddsList);
        ServerOddsGenerator.updateUpdateOddsListProperties(updateOddsListProperties);
        for (i = 0; i < updateOddsArray.length; ++i) {
            String updateOddsJarFileName = fileserverDir + updateOddsArray[i].substring(0, updateOddsArray[i].indexOf(","));
            File updateOddsJarFile = new File(updateOddsJarFileName);
            if (!updateOddsJarFile.exists()) continue;
            updateOddsJarFile.delete();
        }
        ServerOddsGenerator.logInfo("\u7ed3\u675f\u751f\u6210\u5dee\u5f02\u5305");
        long timeEnd = System.currentTimeMillis();
        ServerOddsGenerator.logInfo("\u4e3a\u65b0\u5305\uff1a" + newJarFileName + " \u751f\u6210\u5dee\u5f02\u5305\u8017\u65f6\uff1a" + (timeEnd - timeStart) + " ms");
    }

    private static void updateUpdateResourceProperties(Properties resourceProperties) {
        String localDir = ServerOddsGenerator.getLocalDir();
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localDir + RESOURCESET_FILENAME));
            resourceProperties.store(out, "resourceProperties");
            out.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }

    private static void updateUpdateOddsListProperties(Properties updateOddsListProperties) {
        try {
            BufferedOutputStream out;
            File updataOddsListFile = new File(fileserverDir + "classloader", UPDATE_ODDS_LIST_FILENAME);
            if (!updataOddsListFile.exists()) {
                try {
                    updataOddsListFile.createNewFile();
                    out = new BufferedOutputStream(new FileOutputStream(fileserverDir + "classloader/" + UPDATE_ODDS_LIST_FILENAME));
                    new MyProperties(updateOddsListProperties).store(out, "updateOddsList");
                    out.close();
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
            out = new BufferedOutputStream(new FileOutputStream(fileserverDir + "classloader/" + UPDATE_ODDS_LIST_FILENAME));
            new MyProperties(updateOddsListProperties).store(out, "UpdateOddsList");
            out.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getUpdateOddsListProperties() {
        Properties updateOddsListProperties = new Properties();
        File updataOddsListFile = new File(fileserverDir + "classloader", UPDATE_ODDS_LIST_FILENAME);
        if (updataOddsListFile.exists()) {
            ServerOddsGenerator.logInfo(fileserverDir + "classloader/" + UPDATE_ODDS_LIST_FILENAME);
            FileInputStream is = null;
            try {
                is = new FileInputStream(updataOddsListFile);
                updateOddsListProperties.load(is);
            }
            catch (Exception e) {
                logger.error((Object)("load " + UPDATE_ODDS_LIST_FILENAME + " error."));
                logger.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException ex1) {
                    logger.error((Object)"IOException when closing!");
                }
            }
        } else {
            try {
                updataOddsListFile.createNewFile();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileserverDir + "classloader/" + UPDATE_ODDS_LIST_FILENAME));
                new MyProperties(updateOddsListProperties).store(out, "updateOddsList");
                out.close();
            }
            catch (FileNotFoundException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        return updateOddsListProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateServerOddsProperties(Properties serverOddsProperties) {
        if (serverOddsProperties == null) {
            return;
        }
        FilterOutputStream out = null;
        try {
            File serverOddsFile = new File(fileserverDir + "classloader", SERVIER_ODDS_FILENAME);
            if (!serverOddsFile.exists()) {
                try {
                    serverOddsFile.createNewFile();
                    out = new BufferedOutputStream(new FileOutputStream(fileserverDir + "classloader/" + SERVIER_ODDS_FILENAME));
                    new MyProperties(serverOddsProperties).store(out, "serverOddsProperties");
                    out.close();
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
            out = new BufferedOutputStream(new FileOutputStream(fileserverDir + "classloader/" + SERVIER_ODDS_FILENAME));
            new MyProperties(serverOddsProperties).store(out, "serverodds.properties");
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean checkNeedGenerateOddsJAR(String newJarFileName) {
        boolean checkResult = false;
        if (oddsDemandResPathArray == null || oddsDemandResPathArray.length == 0) {
            return checkResult;
        }
        for (int i = 0; i < oddsDemandResPathArray.length; ++i) {
            if (newJarFileName.indexOf(oddsDemandResPathArray[i]) <= 0) continue;
            checkResult = true;
            return checkResult;
        }
        return checkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readConfig() {
        File oddsConfigFile;
        String seperator = ",";
        String localDir = ServerOddsGenerator.getLocalDir();
        String oddsDemandResPaths = "";
        File resourceFileHandler = new File(localDir, RESOURCESET_FILENAME);
        if (resourceFileHandler.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(resourceFileHandler);
                Properties prop = new Properties();
                prop.load(is);
                seperator = prop.getProperty("seperator");
                if (seperator == null || seperator.trim().length() == 0) {
                    seperator = ",";
                }
                if ((fileserverDir = prop.getProperty("fileserverDir")) != null && fileserverDir.indexOf("${EAS_HOME}") >= 0 && System.getProperty("EAS_HOME") != null) {
                    fileserverDir = ServerOddsGenerator.replaceMacro(fileserverDir, "EAS_HOME", System.getProperty("EAS_HOME"));
                }
            }
            catch (Exception e) {
                logger.error((Object)("load " + RESOURCESET_FILENAME + " error."));
                logger.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"IOException when closing!");
                    e.printStackTrace();
                }
            }
        }
        if ((oddsConfigFile = new File(localDir, ODDS_CONFIG_FILENAME)).exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(oddsConfigFile);
                Properties prop = new Properties();
                prop.load(is);
                oddsDemandResPaths = prop.getProperty("oddsdemand_resPaths");
                String maxOddsJarCountStr = prop.getProperty("maxOddsJarCount");
                useOddsJarFunction = prop.getProperty("useOddsJarFunction");
                ServerOddsGenerator.logInfo("fileServerDir: " + fileserverDir + " , oddsDemandResPaths: " + oddsDemandResPaths + " , maxOddsJarCountStr: " + maxOddsJarCountStr + " , useOddsJarFunction: " + useOddsJarFunction);
                boolean isNeedUpdate = false;
                try {
                    maxOddsJarCount = Integer.parseInt(maxOddsJarCountStr);
                }
                catch (Exception e) {
                    maxOddsJarCount = 5;
                    isNeedUpdate = true;
                }
                if (maxOddsJarCount > 10) {
                    maxOddsJarCount = 10;
                    isNeedUpdate = true;
                }
                if (isNeedUpdate) {
                    prop.setProperty("maxOddsJarCount", new Integer(maxOddsJarCount).toString());
                    ServerOddsGenerator.updateUpdateResourceProperties(prop);
                }
                if (oddsDemandResPaths != null && oddsDemandResPaths.trim().length() > 0) {
                    oddsDemandResPathArray = oddsDemandResPaths.split(seperator);
                }
            }
            catch (Exception e) {
                logger.error((Object)("load " + RESOURCESET_FILENAME + " error."));
                logger.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"IOException when closing!");
                    e.printStackTrace();
                }
            }
        }
        ServerOddsGenerator.logInfo("fileServerDir: " + fileserverDir);
        fileserverDir = fileserverDir.replace('\\', '/');
        ServerOddsGenerator.logInfo("fileServerDir: " + fileserverDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getServerOddsProperties() {
        Properties serverOddsProperties = new Properties();
        File serverOddsFile = new File(fileserverDir + "classloader", SERVIER_ODDS_FILENAME);
        if (serverOddsFile.exists()) {
            ServerOddsGenerator.logInfo(fileserverDir + "classloader/" + SERVIER_ODDS_FILENAME);
            FileInputStream is = null;
            try {
                is = new FileInputStream(serverOddsFile);
                serverOddsProperties.load(is);
            }
            catch (Exception e) {
                ServerOddsGenerator.logError("load " + SERVIER_ODDS_FILENAME + " error.", e);
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException ex1) {
                    logger.error((Object)"IOException when closing!", (Throwable)ex1);
                }
            }
        } else {
            try {
                serverOddsFile.createNewFile();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileserverDir + "classloader/" + SERVIER_ODDS_FILENAME));
                new MyProperties(serverOddsProperties).store(out, "serverOddsProperties");
                out.close();
            }
            catch (FileNotFoundException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        return serverOddsProperties;
    }

    private static String getLocalDir() {
        String configDir = System.getProperty("portal.config");
        if (configDir == null) {
            throw new RuntimeException("cann't find the portalConfig file!");
        }
        configDir = configDir.replace('\\', '/');
        ServerOddsGenerator.logInfo("configDir: " + configDir);
        File configFile = new File(configDir);
        if (!configFile.exists()) {
            throw new RuntimeException("cann't find the config file!");
        }
        configDir = configFile.getParentFile().getAbsolutePath() + "/";
        ServerOddsGenerator.logInfo("configDir: " + configDir);
        return configDir;
    }

    private static String replaceMacro(String source, String macro, String value) {
        int startIndex = 0;
        int openIndex = source.indexOf("${", startIndex);
        if (openIndex == -1) {
            return source;
        }
        int closeIndex = source.indexOf(125, startIndex);
        if (closeIndex == -1 || openIndex > closeIndex) {
            return source;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(source.substring(startIndex, openIndex));
        while (true) {
            String key;
            if ((key = source.substring(openIndex + 2, closeIndex)).equals(macro)) {
                sb.append(value);
            } else {
                sb.append("${").append(key).append("}");
            }
            startIndex = closeIndex + 1;
            openIndex = source.indexOf("${", startIndex);
            if (openIndex == -1) {
                sb.append(source.substring(startIndex));
                break;
            }
            closeIndex = source.indexOf(125, startIndex);
            if (closeIndex == -1 || openIndex > closeIndex) {
                sb.append(source.substring(startIndex));
                break;
            }
            sb.append(source.substring(startIndex, openIndex));
        }
        return sb.toString();
    }

    public static String getJarFileMD5(String fileName, String callFrom) throws FileNotFoundException {
        String md5 = "";
        ArrayList<String> excludeList = new ArrayList<String>();
        if (BIM.equals(callFrom)) {
            excludeList.add("md5.properties");
        }
        md5 = MD5.getJarFileMD5NoManifest(fileName, excludeList);
        return md5;
    }

    private static String getMD5(InputStream fis, long length) throws IOException {
        String tmpVersion = MD5.asHex(MD5.getHash(fis, length));
        return tmpVersion;
    }

    public static void main(String[] args) {
        String oldJarFileName = args[0];
        String newJarFileName = args[1];
        ServerOddsGenerator.logInfo("oldJarFileName: " + oldJarFileName + " /nnewJarFileName " + newJarFileName);
        ServerOddsGenerator.generateOddsJARforBIM(oldJarFileName, newJarFileName);
    }

    private static void logInfo(String msg) {
        logger.info((Object)msg);
        System.out.println(msg);
    }

    private static void logError(String msg, Throwable e) {
        logger.error((Object)msg, e);
        System.out.println(msg + e.getMessage());
    }
}

