/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.mainmenu;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class DbConnector {
    private static final Logger logger;
    private static Connection con;

    public static Connection getConnection(String jndiName) {
        InitialContext initContext = null;
        DataSource ds = null;
        try {
            initContext = new InitialContext();
            ds = (DataSource)initContext.lookup(jndiName);
            if (ds == null) {
                return null;
            }
        }
        catch (NamingException e) {
            logger.error((Object)(e.toString() + ".No found jndi:" + jndiName));
        }
        try {
            con = ds.getConnection();
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return con;
    }

    public static void close() {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
    }

    static {
        con = null;
        logger = Logger.getLogger((String)DbConnector.class.getName());
    }
}

