/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.web.filters;

import com.kingdee.bos.Context;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class PermissionFilter
implements Filter {
    private static String USER_SESSION_NAME = "userSessionName";
    private static String LOGIN_PAGE = "loginPage";
    private Logger logger = Logger.getLogger((String)PermissionFilter.class.getName());
    private String userSessionName = null;
    private String loginPage = null;
    private Object userSession = null;

    public void init(FilterConfig conf) throws ServletException {
        this.userSessionName = conf.getInitParameter(USER_SESSION_NAME);
        this.loginPage = conf.getInitParameter(LOGIN_PAGE);
        this.logger.debug((Object)("[EAS Portal] Permission filter: init userSessionName = " + this.userSessionName + ",loginPage = " + this.loginPage));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpResp = (HttpServletResponse)response;
        HttpSession session = httpReq.getSession();
        this.userSession = session.getAttribute(this.userSessionName);
        if (this.userSession == null || !(this.userSession instanceof Context)) {
            this.logger.error((Object)("[EAS Portal] Permission filter: userSession " + this.userSessionName + " is null or is not com.kingdee.bos.context object."));
            httpReq.getRequestDispatcher(this.loginPage).forward(request, response);
        } else {
            filterChain.doFilter(request, response);
        }
    }

    public void destroy() {
        this.userSessionName = null;
        this.loginPage = null;
        this.userSession = null;
        this.logger.debug((Object)"[EAS Portal] Permission filter: destory attribute(userSessionName/loginPage/userSession).");
    }
}

