/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.web.util;

import com.kingdee.eas.cp.common.web.util.DAOException;
import com.kingdee.eas.cp.common.web.util.ValueListDAO;
import java.util.List;

public class ValueListHandler {
    private ValueListDAO valueListDAO;
    private List valueList;
    private int recordsCount;
    private int pageSize;
    private int pageNo;
    private String orderByField = "";
    private String orderType = "";
    public static final int DEFAULT_PAGE_SIZE = 15;

    public ValueListHandler(ValueListDAO valueListDAO) throws DAOException {
        this.valueListDAO = valueListDAO;
    }

    public ValueListHandler(ValueListDAO valueListDAO, int pageSize) throws DAOException {
        this.valueListDAO = valueListDAO;
        if (pageSize <= 0) {
            pageSize = 15;
        }
        this.setPageSize(pageSize);
    }

    public int getPageCount() {
        if (this.recordsCount > 0) {
            return (this.recordsCount - 1) / this.pageSize + 1;
        }
        return 0;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getRecordsCount() {
        return this.recordsCount;
    }

    public List getValueList() {
        return this.valueList;
    }

    public void absolute(int pageNo) throws DAOException {
        this.pageNo = pageNo > 0 && pageNo <= this.getPageCount() ? pageNo : (pageNo <= 0 ? 1 : this.getPageCount());
        this.valueList = this.valueListDAO.getRecords(this.pageSize, this.pageNo, this.orderByField, this.orderType);
    }

    public void relative(int offset) throws DAOException {
        if (offset != 0 && this.pageNo + offset > 0 && this.pageNo + offset <= this.pageSize) {
            this.pageNo += offset;
            this.valueList = this.valueListDAO.getRecords(this.pageSize, this.pageNo, this.orderByField, this.orderType);
        }
    }

    public void setPageSize(int pageSize) throws DAOException {
        this.pageSize = pageSize;
        this.recordsCount = this.valueListDAO.getRecordsCount();
        this.pageNo = this.recordsCount > 0 ? 1 : 0;
    }

    public void setOrderByField(String orderByField) {
        this.orderByField = orderByField;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }
}

