/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.protocal.io;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Stack;
import net.buffalo.protocal.ProtocolException;
import net.buffalo.protocal.io.StreamException;
import net.buffalo.protocal.io.StreamReader;

public class FastStreamReader
implements StreamReader {
    public static final int TAG_EOF = -1;
    public static final int TAG_NULL = 0;
    public static final int TAG_BOOLEAN = 1;
    public static final int TAG_INT = 2;
    public static final int TAG_LONG = 3;
    public static final int TAG_DOUBLE = 4;
    public static final int TAG_DATE = 5;
    public static final int TAG_STRING = 6;
    public static final int TAG_MAP = 9;
    public static final int TAG_LIST = 10;
    public static final int TAG_TYPE = 11;
    public static final int TAG_LENGTH = 12;
    public static final int TAG_REF = 13;
    public static final int TAG_CALL = 15;
    public static final int TAG_FAULT = 17;
    public static final int TAG_METHOD = 18;
    public static final int TAG_NULL_END = 100;
    public static final int TAG_BOOLEAN_END = 101;
    public static final int TAG_INT_END = 102;
    public static final int TAG_LONG_END = 103;
    public static final int TAG_DOUBLE_END = 104;
    public static final int TAG_DATE_END = 105;
    public static final int TAG_STRING_END = 106;
    public static final int TAG_MAP_END = 109;
    public static final int TAG_LIST_END = 110;
    public static final int TAG_TYPE_END = 111;
    public static final int TAG_LENGTH_END = 112;
    public static final int TAG_REF_END = 113;
    public static final int TAG_CALL_END = 115;
    public static final int TAG_FAULT_END = 117;
    public static final int TAG_METHOD_END = 118;
    protected static HashMap tagCache = new HashMap();
    protected int peek;
    protected int peekTag;
    protected StringBuffer sbuf = new StringBuffer();
    protected StringBuffer entityBuffer = new StringBuffer();
    private final Reader in;
    protected Stack stack = new Stack();
    protected int depth = 0;
    protected Tag currentTag;

    protected FastStreamReader() {
        this.in = null;
    }

    public FastStreamReader(Reader in) {
        this.in = in;
        this.peek = -1;
        this.peekTag = -1;
        this.moveDown();
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    @Override
    public String getNodeName() {
        return FastStreamReader.tagName(this.currentTag.tag);
    }

    @Override
    public String getValue() {
        return this.currentTag.value;
    }

    @Override
    public boolean hasMoreChildren() {
        int tag;
        this.peekTag = tag = this.parseTag();
        return 0 < tag && tag < 100;
    }

    @Override
    public void moveDown() {
        int tag = this.parseTag();
        switch (tag) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 18: {
                this.currentTag = new Tag(tag, this.parseString());
                this.stack.push(this.currentTag);
                ++this.depth;
                break;
            }
            default: {
                throw new ProtocolException("unexpected tag: " + FastStreamReader.tagName(tag));
            }
        }
    }

    @Override
    public void moveUp() {
        int tag = this.parseTag();
        this.currentTag = (Tag)this.stack.pop();
        if (this.currentTag.tag + 100 == tag) {
            --this.depth;
        } else {
            throw new ProtocolException("tag not match: " + FastStreamReader.tagName(this.currentTag.tag));
        }
        this.currentTag = (Tag)this.stack.get(this.depth - 1);
    }

    protected String parseString() {
        int ch;
        this.sbuf.setLength(0);
        while ((ch = this.readChar()) >= 0) {
            this.sbuf.append((char)ch);
        }
        return this.sbuf.toString();
    }

    private int readChar() {
        int ch = this.read();
        if (ch == 60 || ch < 0) {
            this.peek = ch;
            return -1;
        }
        if (ch == 38) {
            ch = this.read();
            if (ch == 35) {
                ch = this.read();
                if (ch >= 48 && ch <= 57) {
                    int v = 0;
                    while (ch >= 48 && ch <= 57) {
                        v = 10 * v + ch - 48;
                        ch = this.read();
                    }
                    if (ch != 59) {
                        throw new ProtocolException("expected ';' at " + (char)ch);
                    }
                    return (char)v;
                }
                throw new ProtocolException("expected digit at " + (char)ch);
            }
            this.entityBuffer.setLength(0);
            while (ch >= 97 && ch <= 122) {
                this.entityBuffer.append((char)ch);
                ch = this.read();
            }
            String entity = this.entityBuffer.toString();
            if (ch != 59) {
                throw this.expectedChar("';'", ch);
            }
            if (entity.equals("amp")) {
                return 38;
            }
            if (entity.equals("apos")) {
                return 39;
            }
            if (entity.equals("quot")) {
                return 34;
            }
            if (entity.equals("lt")) {
                return 60;
            }
            if (entity.equals("gt")) {
                return 62;
            }
            throw new ProtocolException("unknown XML entity &" + entity + "; at `" + (char)ch + "'");
        }
        if (ch < 128) {
            return (char)ch;
        }
        if ((ch & 0xE0) == 192) {
            int ch1 = this.read();
            int v = ((ch & 0x1F) << 6) + (ch1 & 0x3F);
            return (char)v;
        }
        if ((ch & 0xF0) == 224) {
            int ch1 = this.read();
            int ch2 = this.read();
            int v = ((ch & 0xF) << 12) + ((ch1 & 0x3F) << 6) + (ch2 & 0x3F);
            return (char)v;
        }
        throw new ProtocolException("bad utf-8 encoding");
    }

    protected static String tagName(int tag) {
        switch (tag) {
            case 0: {
                return "null";
            }
            case 1: {
                return "boolean";
            }
            case 2: {
                return "int";
            }
            case 3: {
                return "long";
            }
            case 4: {
                return "double";
            }
            case 6: {
                return "string";
            }
            case 9: {
                return "map";
            }
            case 10: {
                return "list";
            }
            case 11: {
                return "type";
            }
            case 12: {
                return "length";
            }
            case 13: {
                return "ref";
            }
            case 15: {
                return "buffalo-call";
            }
            case 17: {
                return "fault";
            }
            case 18: {
                return "method";
            }
            case 5: {
                return "date";
            }
            case -1: {
                return "end of file";
            }
        }
        return "unknown " + tag;
    }

    private int parseTag() {
        if (this.peekTag >= 0) {
            int tag = this.peekTag;
            this.peekTag = -1;
            return tag;
        }
        int ch = this.skipWhitespace();
        int endTagDelta = 0;
        if (ch != 60) {
            throw this.expectedChar("'<'", ch);
        }
        ch = this.read();
        if (ch == 47) {
            endTagDelta = 100;
            try {
                ch = this.readSingleChar();
            }
            catch (IOException e) {
                throw new StreamException(e);
            }
        }
        if (!this.isTagChar(ch)) {
            throw this.expectedChar("tag", ch);
        }
        this.sbuf.setLength(0);
        while (this.isTagChar(ch)) {
            this.sbuf.append((char)ch);
            ch = this.read();
        }
        if (ch != 62) {
            throw this.expectedChar("'>'", ch);
        }
        Integer value = (Integer)tagCache.get(this.sbuf.toString());
        if (value == null) {
            throw new ProtocolException("Unknown tag <" + this.sbuf + ">");
        }
        return value + endTagDelta;
    }

    protected int readSingleChar() throws IOException {
        return this.in.read();
    }

    private boolean isTagChar(int ch) {
        return ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57 || ch == 58 || ch == 45;
    }

    private int skipWhitespace() {
        int ch = this.read();
        while (ch == 32 || ch == 9 || ch == 10 || ch == 13) {
            ch = this.read();
        }
        return ch;
    }

    private int read() {
        if (this.peek >= 0) {
            int value = this.peek;
            this.peek = -1;
            return value;
        }
        try {
            return this.readSingleChar();
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    private ProtocolException expectedChar(String expect, int ch) {
        if (ch < 0) {
            return new ProtocolException("expected " + expect + " at end of file");
        }
        return new ProtocolException("expected " + expect + " at " + (char)ch);
    }

    static {
        tagCache.put("null", new Integer(0));
        tagCache.put("boolean", new Integer(1));
        tagCache.put("int", new Integer(2));
        tagCache.put("long", new Integer(3));
        tagCache.put("double", new Integer(4));
        tagCache.put("date", new Integer(5));
        tagCache.put("string", new Integer(6));
        tagCache.put("map", new Integer(9));
        tagCache.put("list", new Integer(10));
        tagCache.put("type", new Integer(11));
        tagCache.put("length", new Integer(12));
        tagCache.put("ref", new Integer(13));
        tagCache.put("buffalo-call", new Integer(15));
        tagCache.put("fault", new Integer(17));
        tagCache.put("method", new Integer(18));
    }

    class Tag {
        protected final int tag;
        protected final String value;

        public Tag(int tag, String value) {
            this.tag = tag;
            this.value = value;
        }
    }
}

