/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import net.buffalo.service.NoSuchServiceException;
import net.buffalo.service.ServiceFactory;
import net.buffalo.service.ServiceRepository;
import net.buffalo.service.defaults.DefaultServiceFactory;
import net.buffalo.service.defaults.ServiceHolder;
import net.buffalo.service.spring.SpringServiceFactory;
import net.buffalo.service.spring.SpringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultServiceRepository
implements ServiceRepository {
    private static final Log LOG = LogFactory.getLog(DefaultServiceRepository.class);
    private static final String SPRING_IDENTIFIER = "org.springframework.web.context.WebApplicationContext";
    private Map services = new HashMap();
    private ServiceFactory simpleFactory = new DefaultServiceFactory();
    private ServiceFactory springFactory;
    private ServletContext context;
    private String serviceConfigProperties = "/buffalo-service.properties";

    public DefaultServiceRepository(ServletContext ctx) {
        this(ctx, null);
    }

    public DefaultServiceRepository(ServletContext ctx, String defaultProperties) {
        if (this.springAvailable()) {
            this.springFactory = new SpringServiceFactory(ctx);
        }
        this.context = ctx;
        if (defaultProperties != null) {
            this.serviceConfigProperties = defaultProperties;
        }
        this.initialize();
    }

    @Override
    public Object get(String serviceId) {
        Object serviceInstance = null;
        ServiceHolder s = (ServiceHolder)this.services.get(serviceId);
        if (s == null) {
            throw new NoSuchServiceException(serviceId);
        }
        if (s.getFactoryId().equals("default")) {
            serviceInstance = this.simpleFactory.getService(s.getServiceId(), s.getServiceName());
        } else if (s.getFactoryId().equals("spring") && this.springAvailable()) {
            serviceInstance = this.springFactory.getService(s.getServiceId(), s.getServiceName());
        }
        return serviceInstance;
    }

    @Override
    public void register(String serviceId, String serviceName, String factoryId) {
        this.services.put(serviceId, new ServiceHolder(serviceId, serviceName, factoryId));
    }

    public void register(String serviceId, String serviceName) {
        this.register(serviceId, serviceName, "default");
    }

    public void registerAll(Map services, String factoryId) {
        for (String name : services.keySet()) {
            String serviceImpl = (String)services.get(name);
            this.register(name, serviceImpl, factoryId);
        }
    }

    private void initialize() {
        this.loadDefaultProperties();
        this.loadFromSpring();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultProperties() {
        FileInputStream fis = null;
        try {
            Properties prop = new Properties();
            String contextPath = (String)this.context.getAttribute("fileContextPath");
            String fileFullNameRegex = (String)this.context.getAttribute("fileFullNameRegex");
            File[] files = this.getFiles(contextPath, fileFullNameRegex);
            if (files != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    Properties tempProp = new Properties();
                    fis = new FileInputStream(files[i]);
                    tempProp.load(fis);
                    LOG.info((Object)("Buffalo2.0 log : load config file ,file path {" + files[i].getPath() + " }, file name {" + files[i].getName() + " } "));
                    if (tempProp.isEmpty()) continue;
                    String str = this.getInterSection(tempProp.keySet(), prop.keySet());
                    if (str != null && str.trim().length() > 0) {
                        LOG.info((Object)("Buffalo2.0 log : config file {" + files[i].getName() + "} 's keys {" + str + "}  have override the values of the config files before "));
                    }
                    prop.putAll((Map<?, ?>)tempProp);
                }
                this.registerAll(prop, "default");
            } else {
                LOG.error((Object)"Buffalo2.0 log : Not buffalo config file in the dir WEB-INF ");
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Buffalo2.0 log : read buffalo config file error ", (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private File[] getFiles(String dirStr, String regex) throws IOException {
        File dir = new File(dirStr);
        if (!dir.isDirectory()) {
            return null;
        }
        FileListFilter select = new FileListFilter(regex);
        File[] files = dir.listFiles(select);
        return files;
    }

    private String getInterSection(Set tempSet, Set set) {
        Object[] array = tempSet.toArray();
        String str = "";
        if (array.length <= 0) {
            return null;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!set.contains(array[i])) continue;
            str = str + array[i].toString() + ";";
        }
        return str;
    }

    private void loadFromSpring() {
        if (this.context == null) {
            return;
        }
        if (!this.springAvailable()) {
            return;
        }
        LOG.info((Object)"Found spring, load services from spring");
        Map serviceNames = SpringUtil.getConfigedBeanNames(this.context);
        this.registerAll(serviceNames, "spring");
        LOG.info((Object)"Load service from spring finished.");
    }

    private boolean springAvailable() {
        boolean available = false;
        try {
            Class.forName(SPRING_IDENTIFIER);
            available = true;
        }
        catch (ClassNotFoundException e) {
            available = false;
        }
        return available;
    }

    class FileListFilter
    implements FilenameFilter {
        private String myFileFullNameRegex;

        public FileListFilter(String fileFullNameRegex) {
            this.myFileFullNameRegex = fileFullNameRegex;
        }

        @Override
        public boolean accept(File directory, String filename) {
            if (this.myFileFullNameRegex != null) {
                String regEx = this.myFileFullNameRegex;
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(filename);
                return m.find();
            }
            return false;
        }
    }
}

