/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.service.spring;

import javax.servlet.ServletContext;
import net.buffalo.service.BuffaloServiceConfigurer;
import net.buffalo.service.NoSuchServiceException;
import net.buffalo.service.ServiceCreationFailException;
import net.buffalo.service.ServiceFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringServiceFactory
implements ServiceFactory {
    private ServletContext context;

    public SpringServiceFactory(ServletContext ctx) {
        this.context = ctx;
    }

    @Override
    public Object getService(String serviceId, String serviceName) throws NoSuchServiceException, ServiceCreationFailException {
        WebApplicationContext appCtx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.context);
        BuffaloServiceConfigurer config = (BuffaloServiceConfigurer)appCtx.getBean(serviceName);
        Object instance = config.getServices().get(serviceId);
        if (instance == null) {
            throw new NoSuchServiceException("In configBean '" + serviceName + "', no service named '" + serviceId + "' configed.");
        }
        return instance;
    }
}

